<?php
$product_meta_info_top_stuts = codebean_option('product_meta_info_top_stuts');
if ($product_meta_info_top_stuts == 1) {
    // Assuming $teachers is an array of teacher IDs passed from the parent context
    // If not passed, fetch it here
    $prefix = '_studiare_';
    $teachers = get_post_meta(get_the_ID(), $prefix . 'course_teachers', true);
    if (empty($teachers) || !is_array($teachers)) {
        // Fallback to old fields for backward compatibility
        $teachers = array_filter([
            get_post_meta(get_the_ID(), $prefix . 'course_teacher', true),
            get_post_meta(get_the_ID(), $prefix . 'course_teacher_2', true),
            get_post_meta(get_the_ID(), $prefix . 'course_teacher_3', true),
            get_post_meta(get_the_ID(), $prefix . 'course_teacher_4', true)
        ], function($id) {
            return !empty($id) && $id !== 'no-teacher';
        });
    }
?>
    <div class="product-info-before-gallery">
        <?php if (!empty($teachers)) : ?>
            <div class="course-author before-gallery-unit">
                <div class="icon">
                    <i class="fal fa-chalkboard-teacher"></i>
                </div>
                <div class="info">
                    <span class="label">
                        <?php 
                        // Display "Teachers" if more than one, otherwise "Teacher"
                        echo count($teachers) > 1 ? esc_html__('Teachers', 'studiare') : esc_html__('Teacher', 'studiare');
                        ?>
                    </span>
                    <div class="value">
                        <?php 
                        $teacher_count = count($teachers);
                        foreach ($teachers as $index => $teacher_id) :
                            if (empty($teacher_id) || $teacher_id === 'no-teacher') continue;
                        ?>
                            <a href="<?php echo esc_url(get_permalink($teacher_id)); ?>"><?php echo esc_attr(get_the_title($teacher_id)); ?></a>
                            <?php 
                            if ($index < $teacher_count - 1) {
                                echo $index == $teacher_count - 2 ? esc_html__(' and ', 'studiare') : esc_html__(', ', 'studiare');
                            }
                            ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php $product_cats = get_the_terms(get_the_ID(), 'product_cat'); ?>

        <?php if (!empty($product_cats)) : ?>
            <div class="course-category before-gallery-unit">
                <div class="icon">
                    <i class="fal fa-folder-open"></i>
                </div>
                <div class="info">
                    <span class="label"><?php esc_html_e('Category', 'studiare'); ?></span>
                    <div class="value">
                        <?php 
                        $cat_count = count($product_cats);
                        foreach ($product_cats as $index => $product_cat) : 
                        ?>
                            <a href="<?php echo esc_url(get_term_link($product_cat)); ?>">
                                <?php echo esc_html($product_cat->name); ?>
                            </a>
                            <?php 
                            if ($index < $cat_count - 1) {
                                echo $index == $cat_count - 2 ? esc_html__(' and ', 'studiare') : esc_html__(', ', 'studiare');
                            }
                            ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <?php $comments_num = get_comments_number(get_the_ID()); ?>

        <div class="course-rating before-gallery-unit">
            <div class="icon">
                <?php 
                // Since v12.7: Handle star icon based on Redux option
                $product_stars = true;
                if (class_exists('Redux')) {
                    $product_stars = codebean_option("product_stars");
                }
                $st_icon = $product_stars ? '' : '<i class="fal fa-star"></i>';
                echo $st_icon;
                ?>
            </div>
            <?php woocommerce_template_loop_rating(); ?>
        </div>
    </div>
<?php } ?>