<?php

// Atts
if ( function_exists( 'vc_map_get_attributes' ) ) {
	$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
}

extract( $atts );

// Element Class
$class = $this->getExtraClass( $el_class );
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class, $this->settings['base'], $atts );

$css_class = 'section-heading';
$css_class .= ' '.$sc_studi_heading_style;

$title_color_style = array();
$subtitle_color_style = array();

if ( $title_color !== '' ) {
	$title_color_style[] = 'color:' . $title_color;
}
if ( $title_font_size !== '' ) {
	$title_color_style[] = 'font-size:' . $title_font_size.'px';
}
if ( $title_font_weight !== '' ) {
	$title_color_style[] = 'font-weight:' . $title_font_weight;
}

if ( $subtitle_color !== '' ) {
	$subtitle_color_style[] = 'color:' . $subtitle_color;
}

$svgColor = 'fill="'.$element_color.'";';
$svg_head4 ='<svg xmlns="http://www.w3.org/2000/svg" width="220.105" height="17.264" viewBox="0 0 220.105 17.264"> <g id="highlight" transform="translate(-90.731 -43.875)" opacity="0.24"> <path '.$svgColor.' id="Path_23525" data-name="Path 23525" d="M266.954,56.83c.393.154.628.281.523.281a1.325,1.325,0,0,1-.471-.08.526.526,0,0,0-.356-.176c-.154,0-.614.034-.453.077a1.76,1.76,0,0,1,.531.214l-.05.033c-.149.1-.309.189-.482.278a.551.551,0,0,1-.5.03l-.366-.1c.031.127-.083.22-.252.207a1.357,1.357,0,0,0-.616.155l-.171-.014-.352-.03c-.368.222-.426.445-.131.495l-.087-.032-.412-.148c-.528-.156-.913-.2-.857-.1a1.045,1.045,0,0,0,.521.381c.179.02.316-.251.336-.327s.388-.087.461-.025a1.407,1.407,0,0,0,.81.122,4.381,4.381,0,0,1,1.223.039.363.363,0,0,0,.247.171c.114.007.406.056.37.093h-.028l-.338,0c-.424,0-.649-.046-.5-.1v-.03c0-.048-.063-.1-.14-.139a.8.8,0,0,0-.278.041l-.194.271a1.248,1.248,0,0,1-.694.644c-.243.057-.8-.075-.551-.161s.35-.426.133-.4a1.971,1.971,0,0,0-.72.252l-.307-.16c-.309-.161-.5.052-.777.057l-.232,0c-.3.122-.553.163-.553.091a.4.4,0,0,1,.251-.3c.138-.025.61-.168.594-.234l.032-.069.109-.227a2.458,2.458,0,0,0-1.457.086l-.268.149c-.039.022.029.083.081.118l.269.18c-.078.246-.289.4-.47.345s-.245-.192.149-.209l-.339-.2-.115-.068a.513.513,0,0,0-.379-.2,1.933,1.933,0,0,0-.513.053c.009.029-.131.079-.328.046s-1.05.066-1.453.073a6.156,6.156,0,0,1-1.262-.281c-.039,0,.006.077.216.177l-.386.1c-.192.052-.239.187-.431.237l-.211.056c-.344.02-.483-.063-.31-.184s-.493-.353-.511-.3l-.034.039-.044.049a.576.576,0,0,1-.393.037l-.01-.034c-.04-.123-.263-.087-.43-.086a.6.6,0,0,0-.263.052c-.028.032.039.11.084.112.257.013.516.057.312.152-.147.069-.561.137-.65-.072a.522.522,0,0,0-.192-.029.728.728,0,0,1-.576-.016.9.9,0,0,0-.369.028l-.186.1c-.161.125-.125.252.079.282s.68-.093.673-.014-.029.27-.068.239-.227-.107-.246-.033-.121.252-.188.254l-.038-.011c-.327-.094-.634-.2-.975-.283-.241-.06-.546-.068-.487-.24a1.787,1.787,0,0,0-.664-.161l-.569-.056c-.538.124-1,.141-1.031.038s.21-.366-.2-.435l-.263-.082-.234-.074c-.227-.105-.408-.08-.4.057s.93.348.819.375-.427.122-.531.154-.531-.161-.552-.105a.55.55,0,0,1-.481.09l-.166.131-.087.068c-.144.04-.237-.034-.209-.164l-.522.14-.12.033c-.269-.025-.516.039-.548.143l-.053.111a.51.51,0,0,1-.2.019l-.057-.01c-.034-.032-.013-.133.046-.223s-.248-.175-.2-.023l-.5-.164a.638.638,0,0,0-.2-.026c-.166.007-.428-.042-.433.077l0,.05c.1.057.148.113.1.125l-.054.017-.1.031c-.105.035-.139.1-.075.134l.081.014c.165.027.347.036.518.057l.135.017c.189.032.1.09-.194.128a6.416,6.416,0,0,1-1.073.071c.039-.041-.133-.173-.444-.226l-.245-.077-.23-.073a1.5,1.5,0,0,1-.493.046l-.016-.023c-.038-.055-.156-.138-.21-.051-.136.217-.329.15-.585.051l-.162-.063a2.22,2.22,0,0,0-.724-.056l-.158-.025-.164-.026a.744.744,0,0,0-.452-.075c-.114.029-.51.033-.6.115l.055.053a2.659,2.659,0,0,0,.429.2l.1.056c.069.071.18.187.244.259s.213.27.115.255-.425-.017-.405.04-.022.237-.148.24a1.72,1.72,0,0,1-.526-.054l.029-.014c.071-.035.172-.062.24-.1l.251-.132a1.053,1.053,0,0,1-.623-.164l-.036-.054-.021-.032c-.028-.034.014-.065.093-.068l.069-.006c.149-.014.21.156.382.032.04-.029-.073-.109-.169-.142a3.937,3.937,0,0,0-.461-.1c-.376-.075-.673-.042-.735.1-.038.083-.071.2.045.252l.179.073c.4.044.633.116.524.16a1.447,1.447,0,0,1-.552.11c-.094-.034-.422-.081-.422.007s-.024.3-.053.306a.277.277,0,0,1-.161-.177l-.124-.061c-.187-.092-.1-.136.012-.226.154-.121.452-.244.3-.4l-.063-.065c-.172-.062-.251-.161-.174-.219s.026-.341-.4-.407l-.059.259c-.009.034-.143.071-.239.094a.917.917,0,0,1-.3.036c-.256-.05.037-.079.043-.118a.125.125,0,0,0-.094-.143l-.156-.035c-.214-.011-.624-.037-.912-.059l-.071.171-.041.1a2.35,2.35,0,0,1-.86.138l.219-.158.268-.194a2.249,2.249,0,0,0-.977-.187l.239.135c.068.038.106.12.05.148a3.625,3.625,0,0,1-.65.254,1.481,1.481,0,0,1-.51.039c-.429-.2-.818-.014-1.209.009l-.4.024c.158.109.2.216.084.238s-.421,0-.43-.09-.621-.127-.629-.065-.243.193-.642.12l-.17-.146-.192-.164a.765.765,0,0,1-.549.059c-.1-.057-.34-.232-.3-.251s.294-.068.342-.023.34.152.45.041l.009-.036c.03-.136-.127-.218-.475-.254l-.309-.032c-.336-.046-.426-.193-.2-.328s-.079-.406-.1-.244l-.488-.2c-.094-.039-.57-.06-.527.128a2.875,2.875,0,0,1-.376.021c-.026,0-.076-.08-.049-.115l.032-.041c.138-.057-.113-.035-.556.048l-.184.124c-.05.034-.029.091,0,.133.058.095.493.015.5.188,0,.1.326.019.522-.027l.135-.032c.3.006.5.089.452.184a1.027,1.027,0,0,1-.653.193,7.632,7.632,0,0,1-.986-.245l-.273-.084a1.6,1.6,0,0,0-.6.013c-.227.057-.257.268-.111.33a.592.592,0,0,0,.541.025c.079-.039.112-.116.2-.123.275-.026.2.081.3.132l.2.112c.328-.037.647-.068.707-.068s.213.051.2.116l.029.055.162.307a7.76,7.76,0,0,1-1.409.216c-.174-.015-.269-.226-.4-.254l-.051.014-.678.187a13.166,13.166,0,0,1-1.514-.158.906.906,0,0,0-.524-.032c-.206.059-.7.185-.546.3s-.769.347-1.1.319l-.336.015-.566.025c-.357-.145-.551-.421-.431-.612l-.377-.043c-.157-.018-.477-.068-.552.071l-.035.065c-.027.1-.3.093-.611-.009a12.778,12.778,0,0,0-1.837-.156l-.046.1c-.068.148.286.086.476.1l.068.006c.078.021.069.051-.02.067s-.286.121-.182.185.161.242-.156.221l-.212-.033c-.1-.016-.218-.078-.212-.117l.035-.214a2,2,0,0,0-.724.153c-.018.045-.162.164-.258.105s-.156-.214.074-.218.684-.182.493-.292l-.331.087a.621.621,0,0,1-.235,0l-.521-.157c-.015.16-.1.207-.18.1a1.535,1.535,0,0,0-.907-.016c0,.08-.025.287-.054.288a.34.34,0,0,1-.191-.145l.016-.072.028-.129c-.241-.062-.417-.132-.393-.156s.022-.1-.082-.1a1.339,1.339,0,0,0-.458.073.776.776,0,0,1-.45.172c-.205.009-.915.061-.942-.079l.308-.085c.175-.048.384-.08.548-.132l.05-.016a1.993,1.993,0,0,0-.308-.341l-.3-.068c-.278-.062-.606-.1-.846-.177a2.743,2.743,0,0,1-.588-.3l-.047-.028c.025-.05.121-.073.215-.051l.074,0,.342-.021c.418-.035.759-.141.759-.236s.105-.361.233-.377.418.024.367.13l.273-.018.649-.044c-.024.179.092.25.256.157s-.127-.377-.234-.377a3.766,3.766,0,0,1-.7-.1,3.2,3.2,0,0,0-1.013-.1c-.2.052-.523.3-.8.311l.027-.157.007-.042c-.119-.05-.115-.13.009-.178s.609-.182.461-.243l-.145-.011c-.358-.028-.381-.025-.215-.1l.253-.109c-.013-.15-.4-.273-.848-.272l-.375.052-.148.021c-.192.079-.17.145.05.146l.2-.027.062-.008a.422.422,0,0,1,.261.224c.059.114.051.428-.146.445a5.124,5.124,0,0,0-1.27.023l-.537-.139a.813.813,0,0,0-.36.053l-.039.04c.086.066,0,.155-.182.2a2.773,2.773,0,0,1-1.142-.2c-.026-.092.76-.162.713-.05l-.027.1a.6.6,0,0,0,.186.031.524.524,0,0,0,.191-.027,1.77,1.77,0,0,0,.05-.264c.013-.067-.071-.15.238-.164l.084,0c.077-.061.029-.13-.108-.154l-.127-.017-.1-.013c-.156-.011-.209-.164-.117-.338l.52-.033.036,0c.014-.063-.056-.115-.156-.116l-.061.017-.47.125c-.247-.149-.419-.235-.383-.191s-.174.176-.546.2-.544.431-.423.438.387.075.328.136-.5.431-.071.538,1.447.429,1.261.469-.791.087-.8-.011l-.031-.068c-.024-.053-.052-.137-.133-.149-.222-.031-.289.024-.342.114-.064.109-.184,0-.288-.012-.325-.037-.432,0-.39.119.009.029-.029.075.009.087l.237.075c.218.1.338.285.266.416l-.037.121c-.005.018.149.062.232.063.232,0,.145-.031.107-.1l-.044-.074a1.034,1.034,0,0,1,.569-.189,3.182,3.182,0,0,0,.68-.052c-.044-.029-.069-.109.016-.131l.034.008.247.059a1.684,1.684,0,0,0,.8.038l.115-.056.038-.018c-.017-.039-.107-.065-.2-.059l-.075-.008-.145-.015c-.281-.043-.272-.091.02-.108l.145-.016.2-.023a2.6,2.6,0,0,1,.874.071l.086.131c.115.174.309.34.451.512l.125.152a1.652,1.652,0,0,1,.568-.076c.06.023.157.114.02.125s-.509.082-.434.127.316.14.362.1.216-.116.268-.089a.115.115,0,0,1-.05.217l-.148.061c-.144.059-.194.157-.35.207-.059.019-.3-.073-.453-.067l-.281.01c-.3.041-.422,0-.269-.092s-.039-.371-.479-.332l-.1.2a1.324,1.324,0,0,1-.389.074l-.072.009c-.092-.005-.168.01-.168.035a.675.675,0,0,1-.418-.005l-.066-.118c-.032-.058-.387-.088-.422-.147-.089-.146-.369-.1-.535-.086l-.3.025c-.344.064-.586.145-.538.179s-.086.18-.469.2l-.309-.114-.155-.058c-.137.059-.163.152-.058.206l.187,0,.1,0c.137.017.154.05.038.073a2.138,2.138,0,0,1-.624.033l-.087-.045a.493.493,0,0,0-.457-.029l-.063.038c.1.092.121.174.057.181l-.083.016-.1.019a.935.935,0,0,1-.491-.1,3.81,3.81,0,0,0-1.289-.214l-.312.032-.108.011a.566.566,0,0,0-.513-.015,1.176,1.176,0,0,1-.867.023l-.095-.192-.07-.142a1.316,1.316,0,0,0-.742-.164,1.041,1.041,0,0,1-.539.124c-.146-.034-.463-.022-.4.1s.939.236,1.072.325-.068.323-.14.242a1.351,1.351,0,0,0-.647-.3,9.558,9.558,0,0,1-1.157-.025l.327-.109.108-.036c-.05-.14-.3-.227-.563-.193a2.707,2.707,0,0,0-.692.284,1.121,1.121,0,0,0-.259.173.508.508,0,0,1-.489.111c-.2-.081-.029-.371-.287-.313a5.494,5.494,0,0,1-1.019.214,1.8,1.8,0,0,0-.684,0,1.182,1.182,0,0,0-.258.342.772.772,0,0,1-.623-.07,2.289,2.289,0,0,0-1.259-.128l-.142.09a.644.644,0,0,1-.293.084c-.286-.032-.009-.07.009-.11.089-.187.21-.38-.288-.521-.033-.009,0-.061.022-.092s.105-.062.086-.073a.988.988,0,0,0-.4-.182c-.633,0,.105-.134-.145-.193l-.2-.047c-.221-.022-.232-.114-.024-.2l.162.008A11.6,11.6,0,0,1,190.68,58c.162.024.293.083.457.1l.387.036c0-.139,0-.252,0-.253s.212.024.48.03l.176.046.235.06a.616.616,0,0,0,.667-.052l.179-.027c.251-.037.411-.059.35-.17l-.115-.212c.315-.2.394-.369.177-.382l-.08.028a1.491,1.491,0,0,1-.831-.028c-.092-.015-.081-.118-.179-.142s-.2.122-.41.019a.975.975,0,0,0-.369,0l-.267.179c-.263.206-.05.368.475.361l.212-.234c.072-.079.407-.1.406-.04l0,.231c.425-.016.725.014.667.067a1.777,1.777,0,0,1-.751.226c-.275,0-1.178.005-1.379-.035s-.713-.236-.578-.291l.117-.041c.239-.084.157-.168-.065-.214-.345-.071-.517-.151-.523-.319l0-.114c-.221-.13-.349-.266-.283-.3l.092,0,.382-.019a.554.554,0,0,1,.07-.375l.007-.09c0-.034.079-.089.148-.1a.715.715,0,0,1,.291.038,1.667,1.667,0,0,1,.464.283l.077.091c.063.116.127.148.142.073a.32.32,0,0,1,.363-.18l.181.024.2.027c.239.014.355.06.257.1s-.5.052-.549.1a.145.145,0,0,0,.114.243l.11.042a.729.729,0,0,0,.57-.007l.231-.08c.332-.075.6-.085.6-.022a.96.96,0,0,0,.741.207c.407-.018,1.291.2,1.311.14L195.7,57l.09-.033a.677.677,0,0,1,.383.055l-.027.031a.748.748,0,0,1-.3.219l-.234.09c.261.218.308.359.1.312s-.493-.32-.747-.155l-.188-.089c-.082-.039-.1-.123-.186-.132-.261-.027-.246.055-.308.129l-.089.106c-.188.106-.316.2-.284.205a.59.59,0,0,0,.252-.039,1.349,1.349,0,0,1,.681.041l.2-.007.724-.024c.12.223.288.382.375.353s-.021-.373.026-.457.482-.228.428-.169a.174.174,0,0,0,.116.274c.172.033.464-.251.556-.309a.975.975,0,0,1,.511-.136h.05c.061,0,.174-.046.163-.057l-.071-.076c-.044-.107,0-.169.089-.139l.092.021a1.9,1.9,0,0,0,.461.089c.283-.07.031-.134-.056-.212l-.1-.087a.193.193,0,0,0-.169-.229c-.106,0-.093-.121.252-.251l-.788-.033c-.137-.006-.226-.123-.375-.169-.092-.028-.336-.006-.136-.09a.906.906,0,0,1,.321-.056l.23.007c.3.03.5.022.437-.017s-.2-.279-.236-.255l.08.089c.048.052.341.064.481.112l.391.137c.148.21.279.4.292.425s.19-.034.321-.246l.118-.161c.048-.066.174-.123.217-.188l.022-.034a.67.67,0,0,0-.377-.055l-.091.032-.066.023c-.005.041-.166,0-.357-.094s-1.163-.128-1.395-.183l-.228-.135-.24-.142c.408-.173.592-.282.408-.244s-.6.151-.624.139l-.032-.008c-.2-.051-.3-.2-.634-.124-.218.052-.086.3.262.324.575.039.092.124.139.178l.08.092c.181.092.095.155-.192.139s-.924.135-.812.192.372.489.488.5.393.057.3.088l-.063,0a2.929,2.929,0,0,1-.345,0l-.323-.018a2.179,2.179,0,0,0-.81.033c-.1.052-.527.158-.636.067l-.073-.055-.081-.062a1.006,1.006,0,0,0-.464-.143c-.151,0-.5-.1-.384-.2l.389.019c.344.017.427-.106.647-.15l.1-.02c.159.016.29.07.29.119l-.055.03c-.109.06-.28.1-.381.166-.037.023.021.093.09.113l.064.018a2.842,2.842,0,0,0,.61-.2c.209-.093.157-.448.155-.48a.233.233,0,0,1,.2-.134c.114,0,.373-.066.3-.132l.047-.036c.072-.056.207-.106-.061-.1a1.9,1.9,0,0,0-.584.09l-.132.055c-.044.1-.364.043-.712-.126l-.607.049h-.006a.475.475,0,0,0-.26-.165c-.105-.027-.044-.212.227-.3l.307.125c.127.052.225.114.346.168l.082.036a.552.552,0,0,0,.367-.026l0-.046c.012-.168.172-.177.485-.087l.348.1c.049-.135-.379-.309-.949-.386a17.642,17.642,0,0,0-2.125-.064c.133.024.4.111.135.111s-.794.112-.738.248l.316.029c.2.019.472-.031.462.122s-.17.222-.517.24l-.185.01c-.283,0-.436-.046-.339-.091s.195-.158.041-.165-.685.149-.855.115-.628-.071-.638-.007-.411-.035-.345-.116l.051-.074.105-.154c.305.077.561.1.569.05s-.221-.177-.524-.183-.74.425-.785.387a.72.72,0,0,0-.445-.043c-.162.043,0,.254-.156.3s-.222.232-.306.216-.263-.143-.206-.245l-.283.013a3.95,3.95,0,0,1-.745,0l-.464-.056c.056-.125-.01-.19-.147-.146s-.547.173-.547.095-.384-.263-.853-.238l.365.227.077.048a.637.637,0,0,1-.64.089l-.107-.075c-.191-.135-.305-.318-.6-.387a1.074,1.074,0,0,1-.379-.168,2.206,2.206,0,0,0-1.391-.044,1.674,1.674,0,0,1-.8.221l-.149.006a.6.6,0,0,1-.5.036l-.118-.055a.727.727,0,0,0-.264-.1c-.157-.009-.426-.043-.414.078,0,.033.172.065.269.1l.056.018c.109.027-.093.06-.45.074l-.284.022c-.1.008-.2.116-.284,0-.022-.028.122-.106.213-.112.286-.02.3-.092.18-.154a.408.408,0,0,0-.481-.05.228.228,0,0,1-.092.016l-.1-.028c-.107-.034-.141-.1-.076-.144l.071,0c.227-.011.461,0,.692,0a2.682,2.682,0,0,0,.559-.006c.187-.084.682-.02.633-.19-.029-.1-.227-.093-.416-.045-.089.023-.2.034-.28.061a3.446,3.446,0,0,1-1.178.086l-.364-.009a4.039,4.039,0,0,1-.712.07c-.046-.015-.236-.018-.254.047a.184.184,0,0,1-.216.116c-.092-.035-.365-.144-.362-.146s-.015-.074-.242-.074l-.075.028a1.1,1.1,0,0,1-.707.027.717.717,0,0,0-.57.011l-.378.161c-.315-.119-.828-.341-1.14-.494l-.1.323c0,.01-.392,0-.6,0h-.074c-.168.087-.335.112-.372.055a.774.774,0,0,0-.469-.2c-.189,0-.709-.043-.735.046a2.367,2.367,0,0,1-1.067.077c-.225-.058-.714-.3-.741-.265a.664.664,0,0,1-.421.083l-.153-.013c-.263-.023-.617-.107-.648.107l0,.014c-.2.011-.385-.031-.405-.094l.059-.038.112-.072c.174-.067.057-.182-.26-.254l-.127.079a2.486,2.486,0,0,1-1.066.127l-.381.026a.215.215,0,0,1-.253.1l-.093-.019c-.2-.041,0-.2-.364-.181l-.439.023c.073.13.062.131-.025,0l-.383.066-.231.039a1.349,1.349,0,0,1-.777-.009l-.193-.07-.275-.1c-.206.162-.469.223-.582.138l-.11-.055a.986.986,0,0,0-.829-.05c-.327.089-.891-.051-1.3.081a.6.6,0,0,1-.159-.022c-.543-.121-.543-.121-.79-.056a1.7,1.7,0,0,1-1.176,0,1.492,1.492,0,0,0-.8-.053,2.609,2.609,0,0,1-.83.037l-.563-.186a1.532,1.532,0,0,1-.859.222,1.28,1.28,0,0,0-.509-.145,4.469,4.469,0,0,1-1.08.1l-.436.033-.159.012a.281.281,0,0,1-.344-.214l-.543.143-.408.107a2.909,2.909,0,0,0-.951-.187l-.127.039a.766.766,0,0,1-.653.038.868.868,0,0,0-.307-.03,6.984,6.984,0,0,1-.828.077c-.221-.011-.4-.129-.628-.164a2.407,2.407,0,0,0-.518.043c-.379.042-.751.1-1.136.126-.154.013-.415.046-.468-.063-.087-.182-.253-.129-.529-.052a9.177,9.177,0,0,1-1.664.029l-.252-.021c-.3-.009-.553.044-.553.118s-.118.278-.263.246-.358-.137-.188-.169-.291-.189-.465-.1l-.455-.055a3.949,3.949,0,0,0-1.532.054,1.879,1.879,0,0,1-.742-.016l-.3-.1a1.617,1.617,0,0,1-.71.069l-.3.031-.619.065c-.762-.064-1.377-.032-1.367.071l-.027.085c-.009.03-.121.075-.194.078a.514.514,0,0,1-.25-.056c-.067-.064-.038-.148-.129-.2a.648.648,0,0,0-.557-.067,2.656,2.656,0,0,1-.736.054l-.249-.02a.333.333,0,0,0-.239-.3l.236-.062c.006,0-.04-.044-.08-.061l-.148-.061c-.18-.069-.31-.053-.289.035s-.306.314-.254.38,0,.262-.139.2l-.1-.011c-.143-.016-.34.015-.447-.013-.123-.032-.155-.146-.259-.154-.146-.01-.328.072-.486.067l-.489-.015a1.286,1.286,0,0,1-.962.082l-.118-.059a.634.634,0,0,0-.633-.025l-.168.1a1.078,1.078,0,0,0-.456,0c-.026.029-.15.094-.2.056a2.12,2.12,0,0,0-.806-.132,9.946,9.946,0,0,0-1.31.086.307.307,0,0,1-.246.151l0-.009c.02-.091-.063-.162-.306-.129l-.268.036a1.6,1.6,0,0,1-.951-.1l-.257-.115-.029-.012c-.1.011-.168.048-.145.083l.018.032.028.049c-.062.07-.28.022-.485-.105l-.212-.108a.709.709,0,0,0-.3-.021c-.07.016-.13.081-.1.111l.058.063c.157.086-.031.158-.416.161l-.285.019a1.784,1.784,0,0,1-.748,0,.9.9,0,0,0-.588.081,1.012,1.012,0,0,1-.78.053c-.308-.1-.964,0-.971-.279l0-.121a2.445,2.445,0,0,0-1.1-.367l-.152.263a3.843,3.843,0,0,1-.636-.065,1.266,1.266,0,0,0-.714.047.437.437,0,0,1-.412.067c-.352-.068-.5-.012-.427.105.043.066.176.123.22.189.088.134-.15.286-.493.285a8.834,8.834,0,0,0-1.78.181l-.049.01c-.11-.032-.17-.072-.134-.088s-.122-.117-.535-.14l-.1.049c-.345.168-.754-.016-1.144.068a3.883,3.883,0,0,1-1.238,0,5.568,5.568,0,0,0-1.545.032,2.032,2.032,0,0,1-.987-.016.8.8,0,0,0-.306.075c-.078.138-.235.123-.471.062a.627.627,0,0,0-.233,0,.8.8,0,0,1-.7.042,4.635,4.635,0,0,1-.512.055l-.455-.052c-.475.031-.628.03-.34,0l-.061-.158-.057-.149c-.234.018-.265,0-.068-.043s.771-.185.785-.271l.044-.068c.1-.156-.027-.232-.4-.207a3.812,3.812,0,0,1-.643.065l-1.118-.238a5,5,0,0,0-1.734.507l.074.029c.266.1.5.155.57-.059l.008-.022c.232-.02.341.025.242.1s-.486.3-.213.456l.269.131.036.017c.147-.014.247-.045.222-.068s.016-.116.188-.116.46.141.275.314l-.7-.037a2.669,2.669,0,0,0-.752.03l-.363.125c-.083-.114-.084-.218,0-.234s.272-.149.2-.256l-.149-.068-.079-.036c-.3.011-.54-.019-.53-.066l-.077-.047c-.114-.07.535-.132.021-.168-.369-.027-.191.119-.245.191l-.02.026a.8.8,0,0,1-.387-.04c-.163-.048.033-.27-.234-.3l-.073.028-.186.073a.729.729,0,0,1-.479.15c-.124-.023-.429-.1-.389-.118s.042-.088-.084-.118l-.049.012-.215.054a.821.821,0,0,1-.6-.022c-.131-.081-.706-.214-.674-.275l.087-.029.159-.052c.273-.052.391-.164.261-.247L98.436,54a3.187,3.187,0,0,1-1.634.067.381.381,0,0,0-.156.024l-.356.231c-.4-.107-.7-.245-.671-.3s-.254-.181-.7-.153l-.356.052-.038.005c.018.068-.157.256-.387.416l-.5.023-.206.009c-.29.031-.5,0-.473-.066s-.05-.255-.247-.252l-.216-.007c-.369-.012-.162.149-.368.18l-.179.027c-.216.023-.167-.175.109-.44l.623-.124a2.827,2.827,0,0,0,.462-.067c.058-.053-.005-.146-.1-.2-.129-.074-.134-.121.007-.191l.07-.035c-.006-.064-.1-.111-.2-.106s-.4-.1-.435-.243l.773-.048.4-.025c.068-.1.129-.083.135.033s-.23.455-.015.526l.146-.014.486-.047c.4-.021.643-.134.535-.251s.768-.184.66-.23-.243-.177-.019-.177.788-.074.641-.163l.014-.054.014-.055a.7.7,0,0,1,.41-.044,1.619,1.619,0,0,0,.594.05,1.671,1.671,0,0,1,.763.027c.09.08.183.29.434.268s1.44.041,1.5-.109l-.135-.07c-.284-.147-.019-.115.185-.139.059-.007.115-.078.093-.113s-.145-.065-.212-.1l-.344-.18c.268-.136.509-.2.537-.146a.579.579,0,0,0,.487.137l.133-.045c.189-.064.135-.131-.038-.184l-.346-.105a2.488,2.488,0,0,0-.885.036c-.019.046-.086.167-.108.167a.162.162,0,0,1-.11-.078.784.784,0,0,0-.5-.189c-.239,0-.649-.057-.334-.127s1.013-.354.9-.407a1.31,1.31,0,0,0-.624-.1l-.071-.005c-.619-.045-.853.147-.912.3-.078.2-.385.307-.683.435l-.18.078c-.172.1-.337.151-.366.123a.7.7,0,0,0-.4-.025c-.167.035-.73.086-.753.009a.474.474,0,0,0-.334-.265,2.169,2.169,0,0,0-.6.075.332.332,0,0,1-.235.147v0l.044-.213a1.981,1.981,0,0,1-.718-.016.471.471,0,0,0-.381-.16,5.87,5.87,0,0,0-.8.046l-.015.027c-.037.064.1.161-.2.173s-.261-.072-.269-.147l0-.041A.172.172,0,0,0,91.5,51.4a1.106,1.106,0,0,1-.772.145l.141-.116a1.857,1.857,0,0,1,.648-.271c.23-.058.548-.061.812-.1l.038-.006c-.037-.093.092-.168.286-.168h.336a1.031,1.031,0,0,0,.429-.092c.086-.05.277-.114.242-.035s.545.121.6.113v-.007c-.006-.141.052-.292-.052-.422s-.195-.227.026-.275l.115-.025c.189.011.322.072.3.134a.21.21,0,0,0,.153.257l.041-.011c.4-.107.366-.113.472-.388.022-.058.269-.114.442-.148.284-.056.618-.078.885-.143.356-.087.32-.148-.08-.313-.042-.018-.063-.068-.031-.084a.8.8,0,0,1,.811.026l.191.134c-.226.274-.348.547-.271.606l.085-.175c.009-.017.086-.034.14-.042.319-.047.316-.045.2-.1l-.166-.086c-.208-.114-.387-.151-.4-.082s-.142.246-.264.253-.421.06-.421.1a10.267,10.267,0,0,0,1.711-.153l.157.031.181.036c.228.065.346-.07.26-.3l.3-.153a1.129,1.129,0,0,1,.861-.04l.1.034c.056.061,0,.138-.135.172l-.121,0-.559.008a1.587,1.587,0,0,0,1.107.056l.045-.011.422-.1c-.059-.172-.07-.3-.025-.286a.6.6,0,0,0,.31-.023l-.025-.02-.2-.163c-.261-.189-.223-.348.084-.352l.275-.014.391-.021a1.179,1.179,0,0,1,.309-.338,1.3,1.3,0,0,1,.621-.11c.172.039.522.18.418.213l-.026.037c-.022.035.031.084.086.118a.577.577,0,0,0,.2.011c.239-.171.611.1.927-.056a2.012,2.012,0,0,1,1.167-.314c.257,0,.179-.15.115-.222l-.09-.1c-.617-.091-.945-.177-.73-.189l.068-.032a3.037,3.037,0,0,1,1.1-.35c.2-.039.334-.111.514,0a.6.6,0,0,0,.22,0c.237-.056.076-.314.564-.215.446.091.5-.068.738-.1a2.51,2.51,0,0,1,.617-.007l.267.034a1.747,1.747,0,0,0,.712.061,1.8,1.8,0,0,1,.712-.059c.141.055.455.258.239.272s-.67.145-.464.259a2.358,2.358,0,0,0,1.294.188l-.289-.168c-.111-.064-.183-.208-.09-.244l.326-.127c-.179-.12-.066-.182.251-.138s1.129.059,1.092-.05.127-.171.369-.128l0,.038c.011.152.263.118.477.118.314,0,.18.1.25.157l.08.064c.164.059.236.157.159.217s-.1.276.238.257l.218-.03c.065-.009.139-.1.1-.119l-.357-.2c.4-.121.626-.247.5-.28s-.143-.13.319-.127l.289-.066.273-.063c.2-.16.422-.229.5-.152l.23-.064a1.388,1.388,0,0,1,.388-.023c.173.011.334.053.507.063a.636.636,0,0,0,.247-.06l.04-.018c.005-.055.269-.111.587-.125s1.175.107,1.2.051a.391.391,0,0,1,.426-.046,1.668,1.668,0,0,0,.865-.007c-.038-.057-.049-.216.062-.221l.027.011c.259.1.625.185.516.37a.861.861,0,0,0,.272.043c.07,0,.185-.077.168-.084l-.462-.225c.458-.122.852-.09.877.072l.516-.159a.861.861,0,0,1,.287-.046l.416.106a4.27,4.27,0,0,1,.968-.213l.162.052c.177.057.444.122.464.192l.063.217c.393-.052.627-.158.519-.235l-.047-.059c-.112-.142.04-.185.475-.178.261,0,.729-.067.758-.043.244.21.659-.114.942.062l.15.093a1.9,1.9,0,0,0,.82.019c.033-.051.193-.2.23-.134a.615.615,0,0,0,.555.054,2.448,2.448,0,0,1,.841-.043l-.086.027-.069.022c-.021.051.033.1.117.108l.073,0a5.059,5.059,0,0,1,.529-.042c.585.027,1-.023,1.219-.268a.6.6,0,0,1,.632-.034,1.794,1.794,0,0,0,.236-.043l.438-.089c.028.133.354.106.723-.06l.532.214a2.515,2.515,0,0,0,.527-.028,3.525,3.525,0,0,1,.734-.047.93.93,0,0,0,.7-.057c.2-.079.4-.078.448.061l.009.026a3.793,3.793,0,0,0,.784.02l.345-.011c.365-.012.735-.028,1.084-.068.121-.014.165-.144.274-.151a3.409,3.409,0,0,1,.481.077l.061.007c.094-.032.144-.071.109-.087s-.059-.078.074-.078.472.018.422.041-.05.107.16.111.765-.059.623-.153V45.69c0-.062.126-.13.236-.183a.718.718,0,0,1,.3-.032.159.159,0,0,1,.122.107c.007.021-.093.045-.109.071l-.033.05c-.015.057.093.1.239.1l.129-.01c.258-.02.6.044.747-.1a1.633,1.633,0,0,1,.233.027c.192.044.349.056.422-.049.031-.045-.039-.123.225-.067.185.039.469.022.611.072.357.128.285.008.351-.068a.682.682,0,0,1,.288-.035c.069.009.156.071.136.1l-.072.1c-.034.127.064.155.219.064l.171-.072c.114-.048.251.138.369.014l.044-.046c-.126-.083-.073-.159.117-.168a2.445,2.445,0,0,1,.74.271c.136.062-.011.218.006.16a.614.614,0,0,1,.483-.186l.21-.007a2.826,2.826,0,0,0,.617-.066c.243-.073.314-.113.368.048.027.078.29.073.439,0l.069-.033c.056-.043.12-.04.141.006l.052.035a1.581,1.581,0,0,0,.235-.018,1.794,1.794,0,0,1,.31-.028l.094.009a.234.234,0,0,0,.274-.1c.067-.1,1.344-.166,1.309-.039l.455-.071.127-.02c.182-.055.348-.04.368.032a.914.914,0,0,0,.662.272,6.873,6.873,0,0,1,1.208.086.826.826,0,0,0,.6.037l.121-.2.016-.027c.03-.032.281.082.557.255l.463-.23a.682.682,0,0,1,.22,0l.478.05c.574.063,1.04.03,1.037-.074l.008-.1c0-.042.022-.118.056-.12l.392-.022c.007-.123-.168-.335-.387-.47l-.475.006-.172,0c-.17-.1-.091-.18.175-.187l.116.044.4.15a5.532,5.532,0,0,0,1-.058,1.461,1.461,0,0,1,.535-.114c.234-.006.443.155.163.138s-.587.27-.5.317-.032.2-.453.237L158,45.6c-.211.034-.344.109-.044.189l.06.016c-.005.052.162.1.37.1s.822-.033.684-.073-.374-.154-.275-.18.375-.02.43.06a1.551,1.551,0,0,0,.993.18c.434-.065,1.381-.279,1.3-.22s-.008.277.352.328l.086-.223c.056-.143.517-.2.652-.335a.717.717,0,0,1,.216-.013l.363.02a1.336,1.336,0,0,1,.9.328l.605-.11c.413-.075.568.031.459.253l-.027.055c.012.09.389.074.836-.035l.451.073a.775.775,0,0,0,.34-.061c.019-.194.5-.134.577-.106.423.148.546,0,.576-.1l.038-.123c.227-.079.3-.078.173,0s.387.28.613.236a8.291,8.291,0,0,1,1.279.105,2.25,2.25,0,0,0,1.065-.3l.01-.122c.005-.062-.229-.126-.347-.191-.076-.042-.053-.03.254-.083l.242-.043c.234-.085.317-.177.185-.2s-.1-.264-.074-.23a1.229,1.229,0,0,0,.631-.008l.286-.026.382-.034a1.221,1.221,0,0,1-.169.292l-.077.021-.407.107c.183.133.133.339-.11.457l.03.012.5.2c-.405.007-.533.058-.281.112a2.746,2.746,0,0,0,1.31-.079l.357.091a1.492,1.492,0,0,0,.986-.005.9.9,0,0,1,.294.036l.475.144c.133-.129.136-.276.006-.327a1.459,1.459,0,0,0-.6-.1l-.16.036-.092.02c-.162-.019-.272-.088-.243-.152h.009c.439.02.338-.163.555-.224l.019-.005a.248.248,0,0,0-.223-.05,1.618,1.618,0,0,1-.474.012.886.886,0,0,0-.381-.056c-.038.033-.26.152-.26.075a.563.563,0,0,1,.358-.339c.2-.063.877.085,1.073.051a2.573,2.573,0,0,1,1.286.284l.565.119c.262.055.328.121-.065.212l-.368.085c-.325.2-.337.363-.026.363l.133-.044a1.75,1.75,0,0,1,.747-.046,1.516,1.516,0,0,0,.875,0c.115-.043.526.054.744.024l.263-.036c.237-.1.431-.144.431-.1a3.019,3.019,0,0,0,1.179.065l.605.018c.017,0,.065-.05.061-.075a.113.113,0,0,0-.089-.071l-.178-.015c-.325-.01-.315-.1.023-.189l.121.021.426.075a8.375,8.375,0,0,0,.871-.135c.06-.023.034-.116-.282-.119l-.246-.016c-.07,0-.165-.058-.163-.089s.126-.087.171-.083l.422.032c.234-.118.4-.157.363-.088s.58.18.777.227l-.271.123a1.574,1.574,0,0,0-.541.483l-.028.03a.907.907,0,0,0,.463.051l0-.022c.036-.2.2-.042.363-.039l.266,0c.3-.047.613-.085.7-.085s.549.007.842.017l.134.037.251.068c.179.136.366.191.416.123s.529-.053.543-.039a.126.126,0,0,0,.1.025,2.534,2.534,0,0,1,.452-.078,4.249,4.249,0,0,1,.779,0c.038.032.105-.071.044-.317l-.176-.2-.033-.038a1.006,1.006,0,0,0-.448.026c-.015.03-.087.111-.129.111a.865.865,0,0,1-.347-.365l-.022-.184-.011-.089a.358.358,0,0,1,.564.114l.2.036.379.068a.221.221,0,0,0,.339.073l.162-.06.074-.028a1.538,1.538,0,0,1,.571.151l.21.049.192.045c.194.089.091.165-.23.168l-.048.042c-.171.147-.71-.033-.818.17l-.059.111a.7.7,0,0,0,.278.244l.047-.007a2.677,2.677,0,0,1,.369-.08c.282.013.57.091.828.075.3-.019.555-.132.858-.164l.28-.03c.323.013.558-.017.523-.066s-.372-.173-.428-.273h.773a1.389,1.389,0,0,1,.534.3l-.056.017c-.365.11-.047.165.117.221l.05.017c.139-.018.231-.051.206-.075s.139-.079.459-.041a6.559,6.559,0,0,0,1.261.024c.057-.046.029-.191-.218-.2l-.18.012-.172.011c-.233.039-.187-.084.1-.273l.387.114.4.116c.208-.084.345-.083.3,0s.545.333.665.291l.1-.042.019-.007a.85.85,0,0,1,.323.07,2.248,2.248,0,0,0,.807.068,1.242,1.242,0,0,1,.479-.26c.193-.048.753-.088.83.029a1.864,1.864,0,0,0,1.032.072.887.887,0,0,1,.629-.218,2.962,2.962,0,0,0,1.025.227l-.151-.08-.239-.127a.646.646,0,0,1,.546.113l.007.1c.01.126.189.234.4.233.326,0,.812.125.985-.076.121-.14.416-.112.525-.085l.328.083a3.825,3.825,0,0,1,1-.236l-.169-.189a.269.269,0,0,1,.074-.02l.193.07c.2-.041.294-.143.219-.227l-.082-.077-.014-.013a5.719,5.719,0,0,0-.589-.025c-.287,0-.938.232-.992.191s-.138-.218-.006-.255.464-.161.414-.181-.083-.086-.005-.123l.039,0,.5.064c.616.041,1.022.044.9.007l0-.033,0-.045a1.665,1.665,0,0,1,.512-.109c.185-.011.6-.168.613-.125a1.73,1.73,0,0,1-.015.334l.4.011a1.255,1.255,0,0,1,.41.152c.116.047.1.037-.2.1l-.216.05c-.253.107-.494.141-.537.077a.613.613,0,0,0-.352-.216c-.114,0-.44.082-.278.159s.44.284.225.279l-.137.013a.441.441,0,0,0-.207.077c-.024.018.011.065.057.076l.3.075a1.061,1.061,0,0,0,.913-.184l.466.221.047.022c.16-.011.291.02.291.066a.847.847,0,0,0,.653.066,4.025,4.025,0,0,1,1.09-.062l.314-.025c.342-.032.8-.077,1.007-.1l.2.079.122.048c.289-.03.466-.065.393-.076s-.322-.085-.1-.091.691.016.632.057.091.1.488.014l.31.141a.636.636,0,0,0,.234-.012c.122-.035.2-.1.334-.122l.614-.122c-.145-.152-.051-.235.208-.185l.132.054c.144.059.186.165.347.207l.124.032a2.1,2.1,0,0,1,.511-.009.509.509,0,0,0,.3.06c.115-.022.333-.154.18-.237s.1-.354-.068-.42-.48-.3-.3-.377l.1.011.235.025a1.547,1.547,0,0,0,.7.05c.165-.042.709-.041.643,0l-.052.014c-.553.149-.558.15-.041.323l.073.024c.174.012.317-.047.317-.13s.106-.238.236-.187.58.117.679.023.771.013.929,0l.049-.093.049-.091a.774.774,0,0,1,.458.239c.05.091.392.412.312.289l-.718.045a1.838,1.838,0,0,0-.794-.186.618.618,0,0,1-.518.072l-.311.1-.37.118a2.81,2.81,0,0,0-.939-.1c-.114.039-.245.167-.1.218l.133.056c.126.053.222.116.352.166l.039.015c.1-.007.2-.043.211-.082l-.038-.023c-.157-.093-.115-.218.148-.164a1.024,1.024,0,0,0,.7-.062.958.958,0,0,1,.374-.013l.269.126c.376-.018.47-.018.21,0s-.473.2.011.264a10.4,10.4,0,0,0,1.908.084l.107-.053c.142-.071.326-.127.481-.194l.029-.013a.179.179,0,0,0-.1-.079.746.746,0,0,0-.34-.012c-.088.032-.536-.1-.45-.152s.479-.174.486-.276.546-.2.442-.141-.139.4-.107.416h.031l.151,0c.188,0,.27.067.183.15l.007.071c.005.051.2.064.086.167s.322.063.455.052a1.2,1.2,0,0,0,.415-.147l.092-.043a.337.337,0,0,1,.279-.007,2.731,2.731,0,0,0,.883.021l.289.117a2.234,2.234,0,0,0,.614.064,2.465,2.465,0,0,1,.857,0,.992.992,0,0,0,.324-.01,2.281,2.281,0,0,1,.949-.051.6.6,0,0,0,.341.011,2.776,2.776,0,0,1,1.515-.043l.055.019c.231-.049.434-.052.452-.006a.926.926,0,0,0,.7-.178l.6-.022c.042,0,.113-.081.085-.112a.791.791,0,0,0-.262-.055c-.16-.021-.2.139-.433.041l-.135-.057c.059-.057.038-.133-.046-.168l-.038.006c-.232.036-.446.088-.677.124a2.762,2.762,0,0,1-.522.049l-.694-.031a.4.4,0,0,1-.594-.147l.458-.157a.822.822,0,0,1,.735-.04,3.093,3.093,0,0,0,.878-.133.8.8,0,0,1,.2-.03c.346-.016.118.228.6.186l.559-.048c-.05.175.032.289.181.253a2.007,2.007,0,0,1,.694-.052l.038.036c.118.116.156.278.375.336a9.461,9.461,0,0,0,1.295.188l.376.041c.02-.12.176-.2.346-.183s.446-.085.544-.068a1.755,1.755,0,0,1,.581.119,2.138,2.138,0,0,0,.749.3,2.437,2.437,0,0,1,.564-.095,2.35,2.35,0,0,0,.873-.212l-.363-.173-.035-.017a.8.8,0,0,1,.582-.05c.141.061.407.236.3.263s-.257.1-.055.084.71-.071.674-.125.27-.2.764-.191l-.156.244a.612.612,0,0,0,.221.062,2.051,2.051,0,0,1,1.1.092l.287.045c.1-.275-.054-.405-.347-.288l.93.057c.329.02.357.067.351.166l0,.037c.074.074.162.081.195.015s.166-.209.217-.168a.76.76,0,0,0,.446.059c.164-.033.632-.048.7.034s.6.068.564-.013-.2-.3-.113-.33.167-.179-.072-.239-.987-.171-1-.076a.671.671,0,0,1-.359.408c-.176.052-.5-.143-.4-.174s.072-.149-.2-.112a2.413,2.413,0,0,0-1,.412l-.142-.016-.394-.044a1.252,1.252,0,0,1,.15-.332c.044-.054-.221-.211.054-.212a5.374,5.374,0,0,0,1.08-.124c.021-.043.139-.165.21-.164l.029.013a6.16,6.16,0,0,0,1.172.134l.051.01a.674.674,0,0,1,.52-.043c.123.06.553.179.635.109a1.033,1.033,0,0,1,.559-.207,2.186,2.186,0,0,0,.618.076l.092-.025a3.194,3.194,0,0,1,.633-.16,5.945,5.945,0,0,1,.7.067l.543.034a1.779,1.779,0,0,1,1.02-.052l.117.012.36.038a4.538,4.538,0,0,0,.846.01l.061,0c.386-.032.8.082.635.166l-.276.143c.227.174.358.267.293.207h-.1c-.571,0-.227-.181-.394-.249a1.206,1.206,0,0,0-.3-.029c-.017,0-.059.039-.064.06-.026.124-.06.142-.177.1l-.162-.052a2.878,2.878,0,0,0-.632.255l-.18.1c-.183.107.068.156.214.214a.541.541,0,0,0,.467-.031l.119-.064c.127-.086.252-.113.281-.061a.569.569,0,0,0,.447.127,8.072,8.072,0,0,1,1.054-.26l.3.047.37.059c-.168.1-.209.2-.088.216l.1,0c.152-.007.566.055.228-.121l-.066-.034c.21-.136.4-.2.424-.142a.634.634,0,0,0,.408.228l.118-.023c.23-.044.427-.1.6.024a.173.173,0,0,0,.08.03,3.834,3.834,0,0,1,.771-.04l.286.072c.323-.022.476-.068.339-.1s-.4-.147-.265-.171l.079.013.265.042c.3.065.532.025.508-.091l.446.042a1.969,1.969,0,0,0,1.169-.195l.061-.035c-.031-.064-.218-.105-.416-.092l0,.018-.043.22c-.4-.056-.525-.147-.272-.2l.05-.054.071-.078c-.029-.141.091-.187.266-.1l.133.014c.534.057.544.217.452.369-.044.074-.387.122.1.146l.182.009a1.351,1.351,0,0,0,.7.112c.191-.034.611-.243.523-.323s-.693-.024-.719-.066.068-.2.3-.214l.09.027a1.191,1.191,0,0,0,1-.081.764.764,0,0,1,.7-.2.3.3,0,0,0,.09-.022l.185-.055c.138.044.274.055.3.025a.315.315,0,0,1,.31.027l.139.019c.258.035.271-.055.3-.132a.679.679,0,0,1,.285-.039c.274.042,0,.074-.027.115l-.057.08c-.033.084-.205.114-.382.066s-.442.206-.517.15a1.04,1.04,0,0,0-.632-.05c-.228.062-.71.246-.516.261l.128.005.7.029c-.084.165-.123.318-.087.341a.878.878,0,0,0,.38.043,6.007,6.007,0,0,0,.634-.035c.08-.041.216-.176.08-.187s-.489-.073-.272-.1h.1c.351,0,.534-.031.289-.178l-.039-.023c.011-.039.144-.067.294-.062l.027.024c.2.18.537.367-.1.527l-.065.016c-.007.057.114.118.267.136l.113-.014.405-.052a.877.877,0,0,1,.833-.145l-.006.162a.719.719,0,0,0,.209.014l.672-.172a8.99,8.99,0,0,1,1.338.193c-.028.024-.008.084.107.082s.4-.034.371-.068.074-.158.3-.163.848-.025.866-.031.03-.032-.009-.042l-.009-.013c-.071-.1.081-.2.3-.191a1.863,1.863,0,0,1,.283.059,1.33,1.33,0,0,0,.8-.067l.34-.13c-.265-.074-.358-.172-.206-.217s.575.061.492.1-.166.116-.119.154a.84.84,0,0,0,.417.1L269,45.8c.2-.1.376-.209.587-.307l.022-.01c.23.044.375-.011.321-.123s-.1-.426.021-.428.508.044.434.11a.211.211,0,0,0,.058.3c.092.045.153.208.107.255s-.1.228.089.221a2.231,2.231,0,0,1,.715.07.426.426,0,0,0,.439.114l.024-.06c.041-.1.175-.134.369-.1l.095.017a.3.3,0,0,0,.293.1c.115-.022.363-.1.275-.113s-.006-.081.376-.107l-.458-.16c-.024-.008.056-.091.126-.1a.72.72,0,0,1,.3.032,1.64,1.64,0,0,1,.253.183.806.806,0,0,0,.337.208,3.475,3.475,0,0,0,.614-.026.761.761,0,0,1,.236.016c.2.151.436.08.706.036.353-.059.213-.123.056-.2l-.025-.011c-.032-.011-.014-.1.038-.2a1.544,1.544,0,0,1,.766-.275c.149.019-.045.178.017.2a1.582,1.582,0,0,0,.474.066c.135-.014.463.046.421.15l.09.025a6.393,6.393,0,0,0,.855.144l.076.009c.116-.028.159-.109.095-.18h-.061l-.387,0a.457.457,0,0,1,.372-.185,2.058,2.058,0,0,0,.635-.089c.025-.049.107-.18.127-.18a.172.172,0,0,1,.1.084.553.553,0,0,0,.469.117l.173-.037.143-.031c.22,0,.287.043.151.1s-.428.272-.281.342l.143.041.068.019c.132-.009.212-.046.179-.082l-.038-.031c-.092-.075-.125-.135.154-.16l.385-.034c.463-.05.665-.152.448-.227s-.694-.327-.526-.376a2.845,2.845,0,0,1,.814-.124c.05.049.149.2.092.21s-.151.154.073.25l.1.1.09.086c-.017.127.091.1.24-.07l.233-.05.189-.041c.38.068.576.154.437.19s-.169.111.233.09l.346-.014.163-.007c.165-.031.638-.084,1.051-.119l.3-.1.029-.01a1.111,1.111,0,0,1,.412.08c.186.061.806.013.723-.047l-.024-.057-.03-.073c.012-.091-.174-.2-.414-.233s-.393-.308-.27-.308.26.044.077.1l.309.064c.126.026.256.05.387.071l.132.021c.153.019.181.066.063.1l-.02.037-.036.068c.015.094.162.153.327.13a5.622,5.622,0,0,1,.574-.057c.013.011-.05.066-.173.1s-.286.169-.1.234l.351-.118.1-.035a.727.727,0,0,0,.585-.153c.066-.1.32-.4.387-.375s.181.171.1.264l-.15.062c-.3.125-.053.193.151.249A.966.966,0,0,0,289,45.4c.11-.068.12-.16.189-.239s.218-.065.476,0a1.491,1.491,0,0,0,.3.039l.261,0a2.169,2.169,0,0,1,.893.044l.143-.053a2.721,2.721,0,0,1,1.208.018l.239.01a3.911,3.911,0,0,0,.781-.234l.368.091.086.021c.145.012.281-.018.3-.067s.163-.2.232-.147a1.537,1.537,0,0,0,.913-.028l.407.066a4.815,4.815,0,0,1,1.084.071.506.506,0,0,0,.151-.016c0-.207.444-.176.616-.118a.78.78,0,0,0,.787-.084l.058-.031c.039-.084.1-.1.127-.039a.467.467,0,0,0,.405.137c.17-.032.493-.191.611-.144s.564.1.672-.016l.121-.016a2.007,2.007,0,0,1,.665,0l.482.2c.262-.165.541-.259.623-.21a1.066,1.066,0,0,0,.465.13c.1-.021.334-.094.25-.11s-.229-.077-.123-.1a1.19,1.19,0,0,1,.574.055l.149.018c.283.035.2-.085.285-.14l.073-.05a.787.787,0,0,1,.62.171l.324-.082.334-.085c0,.083.122.211.263.285s.594-.168.738-.192l.029.014c.151.07.521.107.3.245l-.045.028c-.131.065.062.08.426.031l.217-.039c.309-.055.384-.134.169-.253l-.07-.039c.032-.053.191-.045.351.018a5.467,5.467,0,0,0,1.625.08l.447-.047.067-.007c.094.027.355.1.578.171l.291-.008c.05,0,.161.059.157.089s-.111.08-.181.082a6.519,6.519,0,0,0-1.188.086l-.365.08a1.608,1.608,0,0,0-.793-.212,2.854,2.854,0,0,0-.7.269l.018,0,.446.095c-.2.121.022.2.485.184a8.466,8.466,0,0,1,1.929.118l-.37.013-.458.015c-.507.019-1.149.056-1.423.083l-.145.062-.153.066c-.048.114-.068.223-.047.241a.247.247,0,0,0,.16.041.615.615,0,0,1,.368.042c.078.065-.418.213-.44.255s.015.184-.2.175l-.119-.017-.13-.019a.5.5,0,0,0-.352.023.178.178,0,0,0,.052.287,1.835,1.835,0,0,0,.692.187.949.949,0,0,1,.653.035l.518-.024L309.2,47c.194.112.034.252-.355.309s-1.032.412-.858.412.618.052.618.117a.354.354,0,0,1-.293.244,5.276,5.276,0,0,0-.735.1c-.085.035-.139.153.013.216a2.566,2.566,0,0,0,.789.184c.1-.037.4-.036.437.086l.412-.03c.013,0,.109.081.08.113a.554.554,0,0,1-.262.052l-.2-.009c-.263-.033-.43-.013-.372.045a.8.8,0,0,1,.148.327c0,.065.092.255.2.255s.382-.069.324-.154l-.053-.083-.051-.08c-.057-.1.007-.189.144-.206a2.967,2.967,0,0,1,.614-.015l-.019.02-.06.065a.647.647,0,0,0-.188.412l.4.061.363.057c.406.083.636.23.511.327s-.523.321-.535.225a.387.387,0,0,0-.365-.275c-.181.024-.614.1-.561.044s.022-.213-.152-.268-.71.1-.545.185l.135.078.264.154c-.317.018-.5.067-.4.111s.8.145.7.184.1.219.072.266-.2.1-.226.016-.6-.006-.724-.02-.471-.054-.471.012.079.228.174.19l.074,0a2.015,2.015,0,0,1,.391.027l.092.016c.115.058.04.1-.166.1l-.124.02-.106.016c-.078.047-.043.127.078.178l.192-.046.068-.017c.1-.005.184.036.194.091l-.057.018c-.195.062-.434.1-.629.165a.858.858,0,0,1-.487,0l-.346-.063a4.492,4.492,0,0,1-.475.278c-.063.024-.34.11-.47.139s-.354-.164-.428-.243l-.216.03c-.194.026-.182.212.01.265l.144.04c.178.034.509.108.735.164s.665.5.773.559.351.156.144.128-.78.049-.866.008-.058-.2.013-.317l-.414-.046-.123-.014a.438.438,0,0,0-.381-.086l-.095.037c-.226.089-.433.146-.526-.039l-.057-.116a1.155,1.155,0,0,1-.642-.113c-.131-.086-.158-.454-.083-.463a2.514,2.514,0,0,0,.328-.056,2.054,2.054,0,0,0-.348-.027,1.719,1.719,0,0,0-.58.081.441.441,0,0,1-.337.168,1.822,1.822,0,0,0-.625.114l.036.02.206.115c.03.145.119.269.2.275a4.667,4.667,0,0,0,.507,0c.122-.012.241.232.241.378s-.1.535-.215.54-.437.051-.437.089a1.91,1.91,0,0,1-.8.215l-.151-.121a.433.433,0,0,0-.409-.066,2.957,2.957,0,0,0-.7.191c-.368.221-1.055.1-1.482.238a.423.423,0,0,1-.174-.036c-.015-.039.006-.114.035-.116l.728-.044c-.157-.342-.172-.7-.032-.79l-.121.052-.25.106c.162.082.155.189-.015.239l-.135.053c-.038.015-.026.081,0,.084l.268.035a1.448,1.448,0,0,0,.68-.043c.069-.055.176-.221.077-.239s-.274-.109-.2-.168a3.213,3.213,0,0,0-.9.214,4.94,4.94,0,0,0-.67.271c-.045.071.19.284.08.322s-.454.073-.535-.007-.732.109-.946.147l-.215.022-.121.012c-.121.1-.273.141-.336.1a.72.72,0,0,0-.349-.1.91.91,0,0,1-.281.05v-.011c0-.213-.237-.445.337-.615l.064-.019a.226.226,0,0,0-.205-.126,3.25,3.25,0,0,0-.688.27l.065.034c.345.184-.261.172-.294.264-.014.039.019.09.081.12.114.054.2.1-.06.1l-.6.017a.853.853,0,0,1-.18.214.921.921,0,0,1-.344-.034,1.956,1.956,0,0,0-.638-.13c-.143.029-.523.035-.476-.061a.171.171,0,0,0-.215-.234,4.071,4.071,0,0,1-.8-.094l-.015.018a.053.053,0,0,0,.016.085c.209.089.444.168.641.26l.046.021a.559.559,0,0,1-.359.1l-.1-.024c-.067-.016-.029-.091-.1-.115a3.246,3.246,0,0,0-.464-.1c-.009,0-.133.061-.143.1-.023.089-.056.186.322.175h.046c.094.1-.115.178-.464.18l-.258-.006c-.229,0-.278.03-.371.114l-.12.109c-.288-.068-.682-.173-.876-.231l-.174.015a7.851,7.851,0,0,0-.895.135l-.4.08c-.469.033-1.455.122-2.19.2l-.215-.063a1.645,1.645,0,0,0-1.316.124l-.049.022a1.861,1.861,0,0,1-.6-.094l-.305.083c-.356.1-.2-.038-.253-.082l-.02-.016a.257.257,0,0,0-.17.027.6.6,0,0,1-.35.057l-.138-.025a2.083,2.083,0,0,0-1.169.045l-.051.011c-.058.008-.272.019-.475.026a4.359,4.359,0,0,1-.821-.048.349.349,0,0,0-.29-.038,2.1,2.1,0,0,1-.685.167l-.2.006-.121,0c-.2-.106-.426-.13-.511-.053s.614.135.749.112.3.132.087.229l-.32-.014c-.129-.005-.236-.067-.369-.084l-.457-.058c.132-.144.054-.218-.173-.162s-.7.234-.635.3l.09.008.238.021c.109.08-.044.154-.341.165s-.907-.181-.8-.229l-.026-.036a.869.869,0,0,0-.31-.174.693.693,0,0,0-.215-.011c-.26.017-.081.255-.47.171a2.3,2.3,0,0,0-.691-.077l-.161.223c.154.12.038.216-.257.214l-.181-.039c-.254-.054-.383-.141-.076-.247l.146-.05c.168-.121-.225-.152-.872-.069l.071.28c.015.059-.292.069-.436-.007-.075-.041-.11-.1-.209-.124l-.119-.026c-.172,0-.292-.02-.267-.044s-.137-.158-.415-.248l-.318.132c-.066.027-.28.031-.281.047-.012.172-.167.162-.5.089-.275-.061-.612-.124-.723.1-.045.092-.363.114-.652.135l-.548.039a.7.7,0,0,1-.47.3,1.627,1.627,0,0,1-.521-.066h.01l.606-.016a.707.707,0,0,0-.593-.229l-.129.013-.124.012c-.149,0-.188-.04-.09-.081l-.021-.02a2.246,2.246,0,0,0-1.512-.207l-.135.023a1.073,1.073,0,0,1-.482.226l-.035-.016c-.089-.04-.1-.107-.18-.149a.743.743,0,0,0-.727-.037l0,0c-.153-.044-.277.025-.275.153s-.2.491-.273.491a.7.7,0,0,1-.411-.263l-.21-.08a1.054,1.054,0,0,0-.694.064.978.978,0,0,1-.289-.019c-.078-.237-.7-.192-.833-.141l-.332.131a1.839,1.839,0,0,0-.723.049,1.2,1.2,0,0,0,.671.225l.3-.119.056-.023a1.662,1.662,0,0,1,.459.118c.082.044.517.046.631.126l.145.016c.355.04.173-.134.366-.166.029,0,.1.041.161.05l.135.019c.183.013.412.039.51.057s.432-.041.416-.127l.086-.055a1.143,1.143,0,0,1,.848.077c.009.012-.141.035-.184.061l-.251.153a4.116,4.116,0,0,1-1.614,0l-.55.023a2.7,2.7,0,0,1-1.2-.1,2.588,2.588,0,0,0-.381-.075l-.1-.011c-.205.012-.251.07-.1.128s.285.2-.073.171-1.079-.413-1.29-.354a4.95,4.95,0,0,1-1.082.165c-.158-.032-.537-.068-.5-.014s-.342.257-.726.323l-.294-.03a1.663,1.663,0,0,1-.886-.2,2.451,2.451,0,0,0-.8-.261c-.087-.02-.311.074-.464.07l-.439-.012a1.387,1.387,0,0,0-.939-.073l-.109.088-.31.249c.393.079.473.228.176.331l.6.061a.687.687,0,0,1,.19.034c.039.021.059.064.028.081a.482.482,0,0,1-.2.023,1.123,1.123,0,0,0-.874.059l-.239.115a.8.8,0,0,0-.667,0c-.1.094.4.173.012.214l-.265-.076a3.811,3.811,0,0,0-.736-.172l-.188-.016c-.281.062-.473.031-.426-.069s.081-.35-.018-.345a1.762,1.762,0,0,1-.616-.141l-.258.1a2.79,2.79,0,0,1-.84.1l-.315-.022a.909.909,0,0,1-.7.1l-.21-.064-.288-.087c.331-.077.317-.241-.031-.365l-.44-.011a1.417,1.417,0,0,0-1.03.219,1.27,1.27,0,0,1-.229,0,2.661,2.661,0,0,0-.381-.017l-.3.2a12.511,12.511,0,0,1-1.376-.327l-.031.043c-.079.112-.185.018-.282-.006a.658.658,0,0,0-.546.09.08.08,0,0,0,.017.146,1.356,1.356,0,0,0,.446.1c.354-.113.9-.071,1.185-.252l.168-.106c.341-.084.5-.232.359-.327l-.261.135c-.216.112-.363-.134-.648-.025l-.132.051a.423.423,0,0,0-.061.382c.049.085.1.217.2.241a6.457,6.457,0,0,0,1.068.048l.323-.08a4.17,4.17,0,0,1,1.1-.169h.052c.1-.114.446-.077.779.08l-.493.192a.745.745,0,0,1-.369.112,1.533,1.533,0,0,0-.469.093.879.879,0,0,1-.661.016c-.305-.081-.659-.014-.588.066l.1.109c-.162.053-.28.163-.26.243h.027c.216,0,.4.019.339.121a.486.486,0,0,1-.281.131l-.326.05c-.423.042-.771.033-.771-.02s-.4-.291-.308-.218.824-.065.641-.159a3.275,3.275,0,0,0-.8-.3c-.076.024-.074.38-.151.448s-.481.287-.358.455l.529-.094a.711.711,0,0,1,.311.041c.113.086.117.2.275.266l.121.048a3.106,3.106,0,0,1,.909.2l.239.075.088.027c.164,0,.292-.05.283-.107l-.031-.05c-.016-.026-.095-.045-.121-.071-.049-.048.032-.085.194-.081l.057,0c.1.041.188.037.194-.009a.316.316,0,0,0-.288-.2c-.172-.008-.462-.072-.263-.124a11.461,11.461,0,0,1,1.2.006c.233-.01.4-.287.514-.216a1.738,1.738,0,0,0,.443.2l.03-.018c.118-.071.192-.2.335-.208.773-.065.282-.164.074-.258l-.058-.027c-.115-.059.021-.052.3.014s.7.344.865.31.075-.253.308-.339l.227-.071.027-.008a4.15,4.15,0,0,1,.569.244l.044.121v0c.163-.005.3-.059.3-.121a1.377,1.377,0,0,1,.979-.154l.437.05a1.441,1.441,0,0,0,.382.016c.3-.129.351.032.5.064l.04.009a.274.274,0,0,1-.243.1,1.116,1.116,0,0,0-.459.073c-.039.05.078.225.391.215l.045-.046c.082-.082.13-.137.363-.115a3.313,3.313,0,0,0,.476.077,2.526,2.526,0,0,0,.418-.149.678.678,0,0,1,.549.088c.143.065.152.145-.122.158s-.319.071-.223.145a1.086,1.086,0,0,0,.375.007c.508-.085.5-.089.376-.337-.01-.021-.05-.054-.028-.062.394-.15.115-.184-.227-.222l-.1-.011c-.093-.049-.125-.125-.069-.169a2.743,2.743,0,0,1,1.033-.067l.432-.043.059-.006c.058-.018.585-.07,1.172-.117l.305.251a.606.606,0,0,0,.216,0l.339-.157a1.954,1.954,0,0,1,.919.181.261.261,0,0,0,.3.166c.168-.035.558-.162.533-.214s.34-.135.46-.121.015.239.076.321.458.247.472.178a.592.592,0,0,1,.5-.242l.2.021.289.031a3.36,3.36,0,0,1,.584-.114l.08,0a1.981,1.981,0,0,0,.381.012l.122-.06c.076-.084.071-.159-.012-.166l-.045-.018-.087-.035c-.077-.046.01-.112.193-.146l.156.007.455.019a.742.742,0,0,1-.228.317l-.086.021-.294.074c.123.107.449.06.724-.1l.387-.027.628-.043c.091-.189.2-.3.238-.255l0,.045c-.008.127.195.208.457.209a1.347,1.347,0,0,0,.469-.157l.059-.025a.1.1,0,0,1,.174.007v.041c0,.08.009.167.279.137.158-.017.478-.057.314-.164-.225-.146.086-.093.212-.1a.51.51,0,0,1,.165.057c.056.021.167.051.156.063Zm-63.623.885c-.186-.281-.355-.426-.375-.321s-.718.012-.769.039l-.009.026a.074.074,0,0,0,.053.077,7.642,7.642,0,0,1,.765.042c.181.033.091.206.5.17.079-.007.185.066.3.083l.318.05c.074-.114.058-.239-.034-.278l-.069-.04-.257-.15c.3.569.53.922.519.783l-.071-.061-.053-.044c-.164-.03-.268-.1-.229-.168l-.128-.043a.527.527,0,0,0-.192-.012c-.065.011-.168.047-.156.06.109.128-.145.237-.112.36,0,.015-.007.031.008.044l.015.013c.056.019.165-.347-.021-.628m9.808-.7a17.263,17.263,0,0,1,1.872-.149l.152.03.156.03a1.246,1.246,0,0,1,.44.262c.091.1.955-.05,1.057-.013a1.019,1.019,0,0,0,.652-.043c.128-.107.7-.15.422-.073s0,.319.113.2l.415.019a1.283,1.283,0,0,0,.618-.134l.084-.082c-.1-.118.017-.215.265-.214l.069-.04a.813.813,0,0,0,.263-.3l0,0c-.105-.015-.191-.041-.191-.057a.543.543,0,0,1,.305-.02c.168.022.57.116.473.153s-.279.2-.179.267a1.678,1.678,0,0,0,1,.038l.024-.111.068-.316c-.446-.125-.835-.239-.865-.254s.03-.1.406-.044l.228.027c.351.042.426.008.46-.183,0-.024.084-.057.147-.066a.468.468,0,0,1,.191.023l.048.111a.274.274,0,0,0,.293.211c.123-.023.327.009.222.113l.074.067.077.071c.26.05.17.174-.2.277l0,.188v.036a.49.49,0,0,1-.316,0c-.131-.035-.636-.048-.673.089l.08.02.251.061a2.412,2.412,0,0,0,.961-.083l.2-.067a1.148,1.148,0,0,1,.3-.032c.543,0,.618,0,.565-.127l-.092-.215a2.623,2.623,0,0,1,1.1-.264c.293.015.971.055.83.13l-.159.018c-.38.043-.78.059-1.164.1l-.105.011a.579.579,0,0,0-.153.445l-.509.078c-.237.037-.144.05-.062.109l.1.074c.037.086.025.05-.028-.082l.505.135a1.017,1.017,0,0,0,.293.035l.259-.113a1.435,1.435,0,0,1,.7-.179,1.045,1.045,0,0,0,.731-.233l.617.071c.014,0,.162-.1.136-.138l-.051-.08a.626.626,0,0,0-.539-.026l-.151.043-.115.032c-.2.013-.256-.062-.129-.166a2.2,2.2,0,0,1,1.091-.168c.18.077.4.384.245.551l-.1.134-.017.024a.683.683,0,0,0,.379.014l.088-.035.046-.018c.022-.031.161-.017.309.031s.021.242.189.242.574-.1.523-.224l.11-.055c.4-.2.176-.275-.319-.337-.286-.035.01-.077.008-.114-.005-.073-.166-.193-.108-.209l.2-.055a2.024,2.024,0,0,0,.291-.243l.066-.005c.619-.052.274-.137.081-.234-.131-.066-.359-.027-.5-.136l-.277-.218c-.47.074-.54.159-.156.19l.138.134.046.045c-.014.059-.109.1-.212.093s-.452.027-.452.1-.141.287-.313.263a1.86,1.86,0,0,1-.593-.152c0-.047-.254-.126-.564-.1l-.056-.029c-.265-.138-.358.074-.545.028-.082-.02-.22-.052-.213-.073l.088-.286c-.557-.016-.96-.066-.9-.11s.294-.1.354-.007l.095.016.2.035c.093-.074.231-.182.307-.24s.024-.253-.352-.268l-.165.051c-.349.107-.316.03-.36-.068a1.132,1.132,0,0,0-.363-.015l-.089.038a.167.167,0,0,0,0,.224l0,.054c0,.036-.065.093-.134.1a1.093,1.093,0,0,1-.3-.034l-.42-.086c.21-.112.16-.183-.112-.158s-.71-.178-.978-.1l-.095-.023c-.305-.075-.464.048-.663.065a2.252,2.252,0,0,1-.838-.025,1,1,0,0,0-.729.024.943.943,0,0,0-.543.3l-.043.087c.2.118.346.161.313.094s.363-.075.338.007.233.174-.156.179l-.175.061-.3.105c-.29-.041-.588-.072-.665-.07l-.012-.01c-.03-.024-.059-.072-.029-.081l.133-.041c.167-.036.144-.075-.05-.088a3.016,3.016,0,0,0-.8-.009l.027.043a3.608,3.608,0,0,0,.339.392c.186.211.16.246-.271.36a5.394,5.394,0,0,0-.535.139,2.2,2.2,0,0,1-.941.161l-.358-.119c-.18.1-.262.132-.181.073s.061-.228-.229-.246-.964-.188-.848-.261.357-.276.25-.276a1.362,1.362,0,0,0-.635.244c-.139.134.181.465-.254.464l-.879-.175a.9.9,0,0,0-.3.034c-.039.01-.056.059-.028.08Zm-.9-1.208a.732.732,0,0,1-.453.248l-.122.04c-.18.059-.306.146-.5.2l-.19.049c-.248.018-.247.071,0,.118l.245.012.24.012c.268-.041.873-.093,1.346-.117l.422.125.375.111c.2-.131.357-.275.352-.321a.949.949,0,0,0-.717-.116l-.151.08-.3.158a1.254,1.254,0,0,1-.647-.262l-.023-.071-.005-.014c-.314-.186-.362-.295-.106-.242l.01.047c.042.189.446.216.653.155a1.024,1.024,0,0,1,.759.006,1.192,1.192,0,0,0,.3-.08c.019-.008-.1-.092-.146-.091l-.415,0c-.523.007-.835-.029-.692-.08s-.175-.072-.239.034m26.275.247c-.005.033-.145.026-.31-.015s-.622-.311-.617-.5l-.021-.177a.505.505,0,0,0-.239-.056c-.275.059-.369.234-.814.187a.169.169,0,0,0-.078.03c-.015.012-.027.036-.012.041l.417.139c-.221.181-.324.305-.231.278l.058-.007c.652-.077.652-.073.689.21.005.038.139.079.233.109a1.2,1.2,0,0,0,.351.079c.159,0,.392-.082.461-.061l.575.173c-.133-.154.008-.333.313-.4l.02-.071.066-.238c.476-.178.783-.343.679-.366a.555.555,0,0,0-.458.152h-.07l-.469-.008c-.044.133-.32.281-.611.328l.056.144Zm-7.958,1.873a.423.423,0,0,1,.4.254l-.194.084-.31.134a.661.661,0,0,0,.2.094,1.012,1.012,0,0,0,.461-.032c.132-.052.429-.13.4-.069l.056.018a3.047,3.047,0,0,0,1.138.006c.038-.012.027-.059,0-.084a.284.284,0,0,0-.145-.034l-.168.017c-.174.026-.214-.061-.086-.193l.05-.109.009-.023c-.191-.038-.318-.1-.284-.145h.018l.564.032c.046-.193.352-.258.68-.144l.412.023.336.018c.355.136.662.2.683.15a1.1,1.1,0,0,1,.653-.194l.265.011c.353.015.619-.038.707-.162l.062-.087c-.221-.064-.388-.154-.371-.2h.008c.252.007.38-.043.3-.13a1.132,1.132,0,0,0-.381-.052l-.3-.007a1.475,1.475,0,0,1-.733-.131l.385-.049a.547.547,0,0,0,.241-.091.394.394,0,0,0,.111-.162c.027-.057-.015-.139.068-.166.251-.082-.009-.11-.044-.166-.024-.038.173-.092.191-.143a.617.617,0,0,0-.3-.073,2.03,2.03,0,0,0-.341.113c-.328.095-.339.1-.727-.062a1.044,1.044,0,0,0-.689-.017l-.062.016c-.121.012-.221-.018-.221-.066s-.173-.119-.384-.071l-.122-.016-.223-.03c.1-.079.136-.189.073-.246s-.1-.263.053-.318a2.714,2.714,0,0,1,.748-.167.254.254,0,0,0,.332-.173l-.647.037-.217.013c-.231-.006-.4.066-.37.158s-.548.069-.5.028.056-.153-.117-.142-.448-.042-.337-.137-.588-.239-.731-.2.227.321.4.446l-.545.025c-.063,0-.107.091-.149.142-.067.079-.159.159-.174.239a.178.178,0,0,0,.146.179l.2.052c.246.023.379.144.3.268s-.407.446-.5.392a.941.941,0,0,0-.655.024l-.258.045-.877.151a1.689,1.689,0,0,0,.015.476l-.052.052-.189.189c.365.048.852.1,1.081.112l.206,0c.093,0,.177-.059.272-.063a.636.636,0,0,1,.251.058c.033.015.016.07-.024.08-.086.022-.221.016-.3.041s-.136.074-.121.107.135.061.221.068Zm7.93-1.233a.567.567,0,0,0,.213.021.524.524,0,0,1,.349.135l.3-.009.1,0c.118.045.133.121.034.167l-.1.007a2.542,2.542,0,0,1-.553-.015l-.115-.019a.382.382,0,0,0-.367-.027l-.084-.127-.094-.143c-.28.052-.667.112-.861.135s-.606.2-.6.267.566.071.706.113.549-.043.635,0l-.015.007c-.288.131-.127.346-.566.453l-.074.018c0,.072.121.129.267.127l.128-.009c.06,0,.11-.039.164-.039l.51,0a1.591,1.591,0,0,0,.5-.382c0-.046.229-.13.51-.075l.041-.018a1.955,1.955,0,0,1,.727-.088l.117,0c.124-.037.158-.107.075-.155l-.1-.018c-.319-.053-.292-.116-.052-.182l.174-.048c.22-.042.342-.1.272-.126a.931.931,0,0,0-.512.036c-.145.073-.7-.022-.622-.059s.176-.189-.173-.157a3.829,3.829,0,0,0-.932.209m-27.471-1.526a9.066,9.066,0,0,1-2.183-.019l-.682-.017-.155,0c-.25.13-.233.257.035.28l.109-.02a4.876,4.876,0,0,1,1.9,0,4.82,4.82,0,0,0,.5-.051c.186,0,.382.053.553.04l.092-.007c.074-.089.3-.036.5.117l.466-.147a.825.825,0,0,1,.3-.033.869.869,0,0,0,.672.03,6.147,6.147,0,0,1,.665.052c.3,0,.673.147.915-.048a1.071,1.071,0,0,1,.233.024c.192.047.367.059.411-.046.012-.03-.14-.089-.244-.1a2.5,2.5,0,0,0-.653-.042,2,2,0,0,1-1.02.031c-.46-.189-.813.019-1.208,0-.06,0-.118-.061-.162-.058-.245.016-.36-.131-.643-.068Zm8.942,3.92c-.141.022-.09-.069.115-.2l.153-.086a.707.707,0,0,1,.229-.065.982.982,0,0,0,.848-.114l.062-.025a.083.083,0,0,0-.105-.08,1.285,1.285,0,0,1-.526-.162l-.4.01-.433.011a9.317,9.317,0,0,0-.927-.194l-.029.015c-.062.032-.126.107-.106.111.341.082.346.274.75.339l.095.015c.068.1-.076.123-.322.053s-.744.078-.487.243l.29.121c.217.091-.13.116-.059.162a2.8,2.8,0,0,0,1.007.117l.308-.081c-.021-.14-.322-.209-.464-.187M101.012,51.508c.046-.128-.144-.189-.422-.136l.3.129c.417.178.465.206.284.365-.1.089-.262.167-.358.256-.03.028.047.082.11.112a.53.53,0,0,0,.216,0c.232-.1.618-.15.39-.364-.189-.176.216-.293.676-.205a1.1,1.1,0,0,0,.569-.056,3.575,3.575,0,0,1,1.821-.2c.157.038.625-.116.6-.175-.042-.117-.286-.058-.443-.079s-.316-.064-.484-.084l-.041,0a.291.291,0,0,0-.162.18l-.174,0c-.184,0-.381-.052-.543-.036l-.21.02a8.057,8.057,0,0,0-1.228.052l-.37.094Zm-4.823-.561a1.178,1.178,0,0,0-.694.091l-.226.02c-.37.032-.29.14-.233.2a1.9,1.9,0,0,0,.5.32,1.594,1.594,0,0,0,.851-.043l.061-.209c.359.028.7-.031.755-.131s-.516-.267-.541-.218-.371.028-.47-.027m143.6,5.116c-.208.081-.225.144-.038.142l.09-.028.16-.049.549.041a3.162,3.162,0,0,0,.855-.273l.488.151.271.084c.277-.032.345-.215.15-.406l.181-.1c.285-.159-.066-.2-.194-.218l-.242-.032c-.294.037-.431.092-.3.123s.1.217-.546.294l-.511.051-.056.006a3.153,3.153,0,0,0-.852.216m-130.985-1.81c-.043.191-.379.381-.747.423l-.341-.05-.162-.024c-.144.2-.064.333.177.293l.158-.042c.232-.061.305.136.66.031.262-.078.611-.059.63-.257l.007-.08a.273.273,0,0,1,.109-.228l.064,0c.385-.018.269-.144.22-.2-.111-.134-.31-.067-.506-.011-.047.013-.211-.05-.328-.056-.092,0-.384-.018-.218.066Zm136.421-8.3c.311-.271.416-.389.231-.262a7.425,7.425,0,0,1-1.126.2c.061.026.109.1-.015.113l-.1.008-.132.011c-.216.015-.235.131-.043.258a3.366,3.366,0,0,0,1.087.121c-.121-.022-.183-.1.068-.134l0-.033Zm12.954,12.149a.2.2,0,0,0,.188-.165,1.361,1.361,0,0,0-.942-.323l.045-.249c0-.024-.149-.079-.2-.074l-.692.068c.05-.192-.08-.28-.286-.2l-.191.073-.346.132c.3.1.547.091.553-.012l.348.017.205.01a4.634,4.634,0,0,1,.423.352l.444.005c.281,0,.279.092.143.152-.121.053-.535.02-.369.15a2.571,2.571,0,0,0,.6.054Zm-55.535-2.2c.169-.095-.084-.229-.564-.3l-.174.289a1.34,1.34,0,0,1-.5.036,2.126,2.126,0,0,1-.4-.19l-.086-.035a.584.584,0,0,0-.4.079l.041.042c.074.077.265.137.345.214l.043.041c-.048.032.092.036.312.008a8.8,8.8,0,0,0,1.381-.184m-77.753-2.236c.34.007.433-.061.207-.152l-.16-.031A2.125,2.125,0,0,0,123.6,53.4a4.308,4.308,0,0,1-.568-.074.4.4,0,0,0-.224.063c-.017.034.081.11.1.109l.618-.05a1.821,1.821,0,0,0,.966.255l.2-.016Zm109.984,1.164a3.676,3.676,0,0,0,.576,0,.559.559,0,0,0-.263-.143l-.166-.016-.345-.032c-.383-.032-.91-.089-1.172-.126l-.239.075-.293.091c.032.137.5.28,1.037.32l.35-.2a1.523,1.523,0,0,1,.234.014ZM108.333,50.821c-.318-.007-.486.038-.374.1s.3.258-.044.3l-.27.027c-.125.013-.194-.184-.346-.016-.02.022.138.077.234.106l.344.1c.425-.02.774-.606.456-.613m2.257,3.816c.219.027.367-.057.329-.187l.087-.086.1-.1c.233-.088.215-.125-.04-.082s-.942.088-.913.112l.038.018.408.2c-.423.016-.227.1-.007.123m19.695-1.429c-.154-.05-.28-.018-.28.07a.578.578,0,0,0,.488.34,5.762,5.762,0,0,0,1.08-.016.1.1,0,0,0-.069-.185c-.151-.012-.548-.157-.587-.125a2.056,2.056,0,0,1-.633-.084m31.354-6.285a1.732,1.732,0,0,0-.826.021l-.209.075c-.2.074-.086.2.2.255a2.253,2.253,0,0,0,.364.085l.245.011c.169-.078.364-.387.225-.449m39.656,10.123c-.43.066-.562.162-.292.213l.208-.007.257-.007c.3-.057.205-.223-.205-.37l.817-.056c.041,0,.1-.2.008-.223-.245-.073-.355-.012-.4.105-.021.055-.422.1-.417.141ZM252.677,56c.237-.043.357-.177.266-.3l-.374.109a2.081,2.081,0,0,1-.813,0,.815.815,0,0,0-.724.08l-.044.017a.212.212,0,0,0,.182.082c.059-.01.241.053.257.165l.128.033c.41.105.294-.1.464-.14.112-.027.3,0,.434-.02Zm-37.067,2.43c-.132.043-.224.089-.205.1a1.37,1.37,0,0,0,.422,0c.195-.026.665-.289.629-.528l-.962.1a2.152,2.152,0,0,0-.221,0c-.069.027-.155.091-.131.1a1.05,1.05,0,0,0,.33.072l.1,0c.121-.03.2-.007.18.053l-.068.043Zm91.42-7.516c.032.036.253-.055.491-.2l-.063-.139-.079-.174c.233-.146.125-.162-.238-.035s-.75.622-.625.577a1.16,1.16,0,0,1,.515-.027m-147.3,2.383c-.053.042.059.193.251.336l.24.017a7.108,7.108,0,0,0,.958-.14l.257-.025c-.007-.068-.107-.1-.223-.082l-.11,0a1.183,1.183,0,0,1-.3-.023l-.3-.076a1.477,1.477,0,0,0-.772-.012m51.541,4.775c.066-.171.058-.317-.015-.324a4.873,4.873,0,0,0-.67.1l-.227-.113a.406.406,0,0,0-.161-.06h-.129c-.142.016-.244.078-.226.138l.053.006c.566.064.859.2.879.435a.431.431,0,0,0,.182.03.525.525,0,0,0,.232-.065Zm-4.661-2.686c.237,0,.354-.047.26-.1l-.068-.043a2.448,2.448,0,0,0-1.265-.2c-.42.1.195.184.115.293l-.011.015c.058.019.734.034.97.034m91.4-2.663a.8.8,0,0,0,.345.056l.006-.01c.066-.122.3-.165.555-.22l.28-.06c.19-.113.21-.176.044-.141s-.978.06-1.345.152l.1.187Zm-67.529,3.538a.451.451,0,0,0,.419-.213l-.31-.075-.472-.114c-.363.119-.585.317-.5.44l.1.087a.551.551,0,0,0,.266.092c.43-.059-.056-.086-.046-.135l.014-.069c-.006-.09.4-.047.523-.012m-27.871,1.8c.173-.027.095-.1-.174-.164l-.1-.118a2.317,2.317,0,0,0-.7-.371l-.047-.02c-.182.023-.292.086-.245.141l.085.034.063.025c.156.009.2.032.1.05s-.263.089-.208.131a.6.6,0,0,0,.423.055c.125-.052.632.265.8.237m.794-2.6c.276.027.374-.028.217-.123l-.009-.058L203.6,55.2c.073-.081-.115-.146-.418-.146l-.25.067-.174.047c-.13.108.37.257.647.284m-4,1.868c-.146.254-.239.471-.206.482a.959.959,0,0,0,.36-.044l.032-.05c.09-.144.179-.22.566-.087l.174.059c.218-.105.369-.2.334-.209h-.032c-.33,0-.785.032-.389-.195.026-.015.026-.055.005-.059a.668.668,0,0,0-.206-.016Zm73.859-2.657c-.074.1.145.2.483.211l.039-.026c.158-.1.328-.219.349-.335l.021-.117a1.283,1.283,0,0,0-.893.267m-59.413,2.852c.154.2.374.3.489.24l.111-.036a3.28,3.28,0,0,0,.411-.1c.105-.062.094-.15-.19-.143-.313.007-.506-.011-.469-.161.008-.034-.134-.1-.222-.107-.305-.013-.254.091-.221.152ZM230.86,46.43a1.082,1.082,0,0,0,.718-.03l-.037-.061a1.471,1.471,0,0,0-.453-.369,1.14,1.14,0,0,0-.375-.025c-.037,0-.057.075-.073.116-.048.127.423.2.374.24ZM107.01,48.96c-.038-.032-.24.036-.448.151l.522.067.242.032c.278.151.6.175.725.054s-.272-.409-.393-.356a1.814,1.814,0,0,1-.648.052m93.912,7.61c.405-.05.266-.092-.309-.092h-.588c-.215,0-.4.058-.411.129l.055.018.291.094a1.194,1.194,0,0,1,.585-.061l.006.028c.016.067-.06.164.239.149.086,0,.227-.079.211-.11Zm2.738.139a.463.463,0,0,0-.446-.227l-.064.025c-.169.067-.47.19-.432.212.375.207-.4.06-.316.165.021.027-.029.073.009.086a.785.785,0,0,0,.279.046,4.543,4.543,0,0,0,.849-.245Zm-80.842-6.242a.652.652,0,0,1-.317.011c-.1-.023-.517.157-.148.216l.736-.15a1.177,1.177,0,0,1,.158.02l.078,0c.088,0,.091-.057.006-.125l-.09-.058-.024-.015a1.741,1.741,0,0,0-.4.1M248.616,58a3.63,3.63,0,0,0,1.231-.125l-.029,0a3.954,3.954,0,0,1-1.283-.216,1.152,1.152,0,0,0-.288.04.046.046,0,0,0-.015.083Zm-54.28-8.454a3.065,3.065,0,0,0-1.037-.085l.117.176c.074.112.522.173.907.166l.141,0c.18,0-.01-.188-.128-.254m34.9,8.569c.273,0,.309-.212.081-.467l-.515.008a.614.614,0,0,0-.24.064c-.031.016-.009.068.032.08.146.038.308.069.47.1.341.059-.123.148.033.185Zm-111.553-7.5c-.591.125-.951.25-.8.278A3.428,3.428,0,0,0,118,50.755l.367-.091c.038-.009.05-.067.015-.081a.669.669,0,0,0-.256-.055Zm188.855-4.98c0-.076.1-.149.222-.162h.069c.251,0,.553-.015.393-.132-.209-.152-.425.023-.641.044a1.507,1.507,0,0,0-.365.086c-.07.027-.146.1-.122.108l.309.1c-.14.121-.21.223-.153.227s.289-.2.289-.275M248.026,47.45c.012.1.161.114.328.034s.428-.3.284-.353-.625.22-.612.32m58.124,1.189c-.11-.2-.245-.346-.3-.325a.678.678,0,0,0-.232.434l.469.1a.588.588,0,0,0,.157.025,1.474,1.474,0,0,0,.236-.089ZM111.462,51.008c0-.062-.193-.069-.433-.017s-.642-.177-.712-.171a.935.935,0,0,0-.434.27l.488-.03.421-.026c.066.123.276.157.469.073l.162-.08Zm71.817,2.539c-.214-.05-.334,0-.267.1l.134.025a1.992,1.992,0,0,0,.892.08l.064-.015a4.086,4.086,0,0,0-.824-.191m58.673,3.269c-.266-.333-.266-.333-1.106-.307a1.108,1.108,0,0,0,1.106.307m-41.879,1.236a1.714,1.714,0,0,0-.605-.009l-.061.039c-.033.021.033.092.1.108.3.068.611.132.935.18l.08.012c.141-.041.193-.118.116-.171l-.1-.012c-.189-.023-.466.034-.471-.116Zm41.063-.551c-.262-.106-.452-.123-.424-.039s.679.054.91.018l.105-.061c.074-.043.029-.157-.073-.2a.336.336,0,0,0-.38.067ZM264.53,46.567c-.161,0-.31.05-.331.112l-.063.028c-.105.047-.215.079-.022.13.1.027.147.1.335.029s.431-.1.625-.166l.056-.018c-.01-.064-.44-.116-.6-.116M221.884,57.832a2.318,2.318,0,0,0-.969.018l.05.039.06.048c.14.039.548.117.906.174l.3-.116a.122.122,0,0,0,.069-.115Zm-11.678-1.978a.4.4,0,0,0,.443-.146l.078-.121.02-.03a.687.687,0,0,0-.415-.038c-.148.029-.238.267-.126.335m6.77.216a.888.888,0,0,0-.46.176c-.193.12-.077.478-.04.373s.56-.525.5-.548m-115.39-2.317c.013.223.139.322.281.221s.309-.39.044-.405l-.058.033Zm146.806,1.838c-.2,0-.346.025-.319.056l.033.016c.192.092.39.259.585.259h.465c.019-.182-.563-.33-.765-.33m52.574-3.423a3,3,0,0,0-.981-.076l.09.164c.074.135.383.045.57.073.066.01.106.056.167.059l.128.007c.145-.008.241-.064.212-.125l-.076-.041ZM102.4,50.612c0-.049-.194-.1-.43-.113l-.087.029c-.153.052-.311.134-.323.208l-.013.079c.16.123.343.173.408.111s.446-.264.446-.314m108.47-3.639c-.178.057-.16.1.038.1s.766-.062.621-.138l-.119-.023c-.144-.028-.4.036-.44-.082-.018-.05,0-.135-.219-.057-.081.029-.165.115-.145.12Z" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23526" data-name="Path 23526" d="M182.1,75.361c.43.234.333.622-.216.863h-.722c.173-.156.248-.35.166-.431l-.072,0a1.767,1.767,0,0,1-1.267-.259c-.154-.083-.457-.181-.536-.125l-.629.444a1.665,1.665,0,0,0-1.327-.57l.408.326c.031.025-.1.206-.19.294a.336.336,0,0,1-.24-.047c-.358-.312-.353-.309-.981-.3l-.118,0-.882-.334.1-.312.07-.215c.313-.3.306-.423-.016-.286l-.209.039-.2.038c-.3-.017-.48.1-.41.252s.006.44-.294.307-1.053-.515-1.085-.384a2.279,2.279,0,0,1-.154.455.28.28,0,0,1-.12-.192c-.02-.107-.273-.36-.5-.245l-.074.193-.075.192c-.065.232-.054.446.024.475a.557.557,0,0,1,.156.6l-.139.205a.414.414,0,0,1-.339.09c-.307-.114,0-.188.049-.283.033-.062.077-.168.042-.2-.142-.122-.434-.216-.443-.333l-.014-.183c.155-.232-.142-.474-.66-.538l-.441.213-.5.242c-.456-.141-.853-.134-.881.014l-.032.126-.026.1c-.054.156-.281.094-.5-.136s-.67-.788-.483-.8l.155-.05c.494-.157.573-.27.666-.75l.025-.13c.1-.135.221-.244.276-.243a.94.94,0,0,1,.2.676l.417-.188.421-.19c.451-.288.52-.671.154-.851l-.25.02-.24.019a.806.806,0,0,1-.695.219c-.164-.067-.633-.1-.556.125s-.426.661-.625.6-.881.395-.944.47a.635.635,0,0,1-.61.116l-.231-.007-.121,0a1.389,1.389,0,0,0-.3.543c-.021.138-.169.438-.273.267s-.68-.5-1.024-.324-1.436.148-1.494-.126l.283-.216.071-.055a.39.39,0,0,0-.427-.26l-.084.082-.238.233a.755.755,0,0,1-.893.308c-.239-.148-.781-.342-.374-.459l-.111-.382c-.085-.294.146-.377.476-.226l.085.039a.247.247,0,0,0,.264-.132l-.037-.039-.16-.173c-.2-.175-.147-.377.115-.45l.023-.1c.037-.164.205-.432-.2-.54l-.143-.038c-.22-.216.31-.4,1.18-.41l.661.023a2.007,2.007,0,0,1,1.308.608l.148.134c.13.172.495.132.81-.089l.014-.141.066-.646a1.981,1.981,0,0,1,1.386-.171c.171.139.458.526.322.6s.224.445.56.358,1.232-.379,1.054-.4-.539-.314-.509-.6l.106-.26.068-.166c-.09-.3-.019-.427.155-.278l.064.162.066.165c-.028.246.1.46.278.477s.632.171.591.305-.048.579.13.507l.067-.05c.231-.168.366-.029.567.065l.305.143c.135-.248.371-.235.527.03a2.332,2.332,0,0,0,1.477.648l-.358-.334-.079-.074a.294.294,0,0,1,.289-.269c.133.013.451.118.411.2s.051.325.355.218l.256-.038.249-.037c.3-.024.144-.182-.35-.35l-.371-.272c-.332-.245-.355-.2.01-.456l.144-.1c.135-.224.263-.27.284-.1s.226.582.414.6.738-.6.9-.52l.138.073c.161.084.419.15.458.263.1.275-.273.182-.416.275a.266.266,0,0,0-.089.283.408.408,0,0,0,.328.108l.474-.129c.573-.189,1-.246.952-.126s.26.341.781.268l.178-.454a.467.467,0,0,1,.771-.059c.211.319.846.493.567,1l-.047.085c.044.225.188.29.322.143s.559-.244.717.036l.365-.218.254-.152c.345-.215.407-.391.14-.391s-.481-.354.15-.787l.824.038a.828.828,0,0,0,.285-.054l.3-.1c.422-.155.5-.111.168.1s-.581,1.015-.35.94l.165-.066a5.817,5.817,0,0,1,1.238-.472l.229-.035c.349.244.526.163.393-.179l-.442-.066-.042-.007a.417.417,0,0,1,.286-.415l.065.045.3.21c.247.211.524.22.617.019s.76.135.688.352l.346.041c.286.034.675-.088.6.352a.606.606,0,0,1-.667.532,1.861,1.861,0,0,0-.532.016l-.1.038c-.077.213.517.4,1.318.4l.663-.028a1.139,1.139,0,0,0,.55-.232c.235-.165.14-.344-.2-.415-.084-.018-.2.024-.264-.009-.093-.047-.207-.137-.209-.21a.288.288,0,0,1,.2-.214l.351-.023a.91.91,0,0,1,.825.462c.083.246.409.831.5.628l.053-.121a1.608,1.608,0,0,1,1-.3l.238.069c.259-.277.556-.438.661-.357s.555.269.7.184.662-.315.6-.175-.074.388.091.313.825-.074.956.163.564.877.667.877.444-.117.453-.259.154-.551.3-.609.664-.126.777,0,.377.259.378.062.659.068.782-.031a1.013,1.013,0,0,1,1.048-.419l.416.241c.342.2.473.132.776-.031a12.513,12.513,0,0,1,1.678-.678.406.406,0,0,1,.331.1c.045.067-.053.279-.065.278-.551-.057-.836.323-1.251.482l-.138.053c-.306-.025-.4.038-.213.139s.588.573.336.752a4.283,4.283,0,0,1-1.573.561l0,.136c.01.385-.476.272-.569.46l-.07.14a6.933,6.933,0,0,0,.558,1.035l.669-.16c.38-.092.711.458.571.853l0,.01c-.07,0-.2-.31-.278-.678l-.52.424a.624.624,0,0,1-.391-.122c-.011-.237-.143-.352-.4-.277-.094.028-.115.231-.162.356l-.036.095c-.062.205-.146.233-.187.061s-.092-.38-.047-.171-.686.374-.86.19l-.161-.165a.424.424,0,0,0-.66-.018c-.182.147-.438.148-.464-.109l-.01-.1c.25-.165.289-.408.088-.541l-.078-.192-.091-.219c.038-.342.277-.382.532-.088l.056-.02.542-.184c.617.038.855-.075.527-.25a3.8,3.8,0,0,0-1.93-.32l-.392.113c-.333.1-.52.518-.244.614.385.134.813.236.684.631l-.093.283c-.337.325-.741.473-.9.329a9.907,9.907,0,0,0-1.037-.788l-.4.01-.4.009a1.931,1.931,0,0,1-.985-.628,7.1,7.1,0,0,1,.167-1.949l.008-.052a.678.678,0,0,0-.015-.208c-.383.011-.92.447-.929.743a1.547,1.547,0,0,0,.674.785.8.8,0,0,0,.253,0c.047-.346.5-.387.678-.615l.087-.114c-.067-.223-.234-.405-.372-.405a12.4,12.4,0,0,0-1.159.92c-.287.194-.888.6-.97.536s-.213-.254-.127-.309l.076-.008c.412-.041.443-.241.191-.419l-.28-.2a1.146,1.146,0,0,0-1.13.069c-.193.208-.9.39-1.011-.208l-.845.065c-.2.016-.427-.2-.651-.29l-.335-.137c-.275.2-.426.392-.336.418s.353.169.18.2-.482.216-.444.355,0,.482-.2.352-.749-.315-.788-.116-.662.441-.82.4-.241-.119.1-.466.559-1.3-.164-1.242l.057.8.009.132c-.322.267-.525.281-.452.031s-.041-.828-.428-.7l-.264.006c-.265,0-.536-.15-.8-.143l-.338.011c.061.4.033.582-.063.414l-.089-.275c-.077-.234-.274-.192-.5-.085l-.472.224c.224.289.325.547.226.574s-.376.171-.06.171,1.487-.384,1.995-.482l-.05.581Zm16.1-.859c.169-.493.01-.9-.353-.9l-.048.1a4.577,4.577,0,0,0-.294,1.191l-.011.068a.535.535,0,0,0,.491.035l.04-.093Zm-32.949-.881c-.313,0-.368.344-.121.765l.407-.171.27-.113c.295-.264-.243-.481-.556-.481" transform="translate(-12.133 -18.336)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23527" data-name="Path 23527" d="M297.217,75.766a5.578,5.578,0,0,1,.794-.671c.213-.138.746-.562,1-.377s1.033.51,1.176.374-.257-.522-.084-.535.636-.168.756-.084a4.705,4.705,0,0,0,1.451.436l.206-.562a1.466,1.466,0,0,1,.275.035l.147.027c.205-.039.215-.173.023-.3s-.625-.557-.527-.677-.506-.414-.406-.514a2.461,2.461,0,0,1,.778-.45c.228-.046.59.407.464.474a.363.363,0,0,0,.117.633A5.174,5.174,0,0,0,305.13,74a1.559,1.559,0,0,0,.656-1.189l-.847.219-.536.14a.633.633,0,0,1-.216-.848l.438.237a2.265,2.265,0,0,0,1.634.057l.5-.118a1.914,1.914,0,0,1,.354.74l.093.1c.186.2.421.43.737.106.2-.209.392-.338.705-.091.04.031.495-.155.5-.246l.018-.524c.47.036.738-.088.6-.276l.058-.079.135-.183c.36-.232.649-.2.641.069l.017.133c.025.2-.477.372.005.591a.758.758,0,0,0,.931-.121l.111-.1a.475.475,0,0,1,.6.025c.15.148.432.626.329.77l-.1.124c-.146.188-.365.455-.574.468-.422.026-.456.153-.526.449l-.059.249c-.3.245-.613.4-.689.338a.241.241,0,0,1,.069-.394c.21-.082-.067-.481-.237-.3s-.864-.035-.767-.124.254-.382.059-.382-.656.152-.617.338.2.641-.009.668-.632-.257-.734-.091-.489.525-.472.17l-.045-.2-.022-.1a.4.4,0,0,0-.469.036l-.026.111-.039.169c.015.281-.183.333-.441.115l-.184-.127a.317.317,0,0,0-.248-.021l-.148.109a.48.48,0,0,1-.548.088l-.267.083-.8.252a5.653,5.653,0,0,0-.82-.768l-.1.019c-.347.068-.016.175-.021.263l-.009.183a2.346,2.346,0,0,0-.186.532c-.011.093-.148.384-.277.325s-.447-.141-.493-.082l-.027.063c-.066.155-.085.427-.187.448-.439.09-.322-.206-.361-.408l-.092-.481a2.35,2.35,0,0,0-1.229-.089,1.528,1.528,0,0,1-1.072.017,2.023,2.023,0,0,0-1.29.3c.042.041.118.185.076.231l-.037.006-.542.094a3.36,3.36,0,0,1-1.2.01l-.01-.062c-.011-.063.017-.179.06-.19Z" transform="translate(-37.264 -17.864)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23528" data-name="Path 23528" d="M205.7,78.1c.153.219.051.364-.227.322s-.82.068-.739.314l.414-.034a.822.822,0,0,1,.453.06l.3.194c.253.318.328.554.167.525l-.145-.032-.2-.044a11.241,11.241,0,0,0-1.231-.131c-.463-.027-1.768-.079-1.79.068l-.091.086c-.17.161-.342.458-.683.114l-.033-.033c-.275.12-.555.106-.624-.032l-.069-.123a.114.114,0,0,0-.089-.011c-.2.163-.426.333-.626.051-.151-.211.183-.828.522-.953.2-.074.381-.254.745-.052.245.136.742-.28,1.208-.192.051.009.2-.131.2-.2s-.1-.185-.194-.22a4.279,4.279,0,0,0-.708-.2.739.739,0,0,0-.362.025l-.6.214a1.956,1.956,0,0,1-1.068-.494c-.135-.193.174-.746.364-.643l.141-.025.737-.133c-.078.406-.036.635.094.51l.114-.392c.09-.311.438-.572.679-.852a.16.16,0,0,1,.127,0c.047.04.113.128.1.14-.786.663.4.782.531,1.2.08.256.828.275,1.538.224.221-.016.459.183.69.184.532,0,.162.311.269.451Z" transform="translate(-16.225 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23529" data-name="Path 23529" d="M210.386,47.953a1.492,1.492,0,0,1-1.009-.349h-.9c.066.244-.093.271-.352.058s-.8-.93-.44-.973l.189.047.941.235c.289-.408.662-.659.83-.559s.753.153.933-.1l-.2-.215c-.146-.155-.18-.243.1-.239.1,0,.2.1.284.157.023.015.009.07,0,.106-.094.505.38.456.672.364l.256-.08a1.262,1.262,0,0,0,.579.3,2.647,2.647,0,0,0,1.126.013c.154-.1.516-.49.772-.657l.233.025.706.08c.141.312.171.6.065.636a4.805,4.805,0,0,0-.73.42c-.2.147.4.591.521.36s.852-.1.742,0-.135.5-.515.648l-.358.029-.263.021a.828.828,0,0,1-.476-.839l-.524.389-.069.051c-.165-.024-.264-.1-.219-.159s.112-.277.045-.331a.522.522,0,0,0-.466-.044,1.258,1.258,0,0,1-.648.224l-.063-.041c-.1-.069-.177-.195-.289-.22l-.242-.053c-.282-.016-.5.052-.483.15s-.5.5-.742.553" transform="translate(-17.469)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23530" data-name="Path 23530" d="M153.436,74.748c.028-.3.193-.5.367-.442s.229-.106-.494-.551l-.5-.184a.749.749,0,0,1-.394-.47l-.031-.113a.641.641,0,0,1,.771.039c.265.184,1.294.534,1.619.315l.386-.194a9.644,9.644,0,0,1,1.129-.438l.066-.024c.1.028.363.117.579.2s-.109.531-.49.367l-.364-.094c-.163-.042-.474-.116-.523.171s.22.247.426.279l.037.006a2.507,2.507,0,0,1-.743.564l-.37.275a.863.863,0,0,1-.7.237c-.356-.05-.543.009-.583.381l-.025.243a1.165,1.165,0,0,1-1.268.088L152,75.208c-.036-.021-.088-.076-.092-.074-.2.129-.385.374-.636.113-.059-.061.253-.381.2-.42-.255-.2-.222-.32.031-.5l.141-.1c.126-.226-.041-.316-.373-.2l-.2-.023c-.443-.05-.3.281-.467.391-.186.123-.423.127-.46-.146l-.019-.136c.009-.17-.244-.173-.561-.006s-1.289-.049-1.289-.182.076-.525.17-.573l.068.01c.379.057.8-.148,1.152.139.072.059.3,0,.45-.015.335-.032.767-.193.984-.08l.55.288c.635.258.825.391.423.295l.381.483a.946.946,0,0,1,.122.289c.064.191.063.515.193.554.485.146.288-.33.514-.476Z" transform="translate(-8.624 -17.527)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23531" data-name="Path 23531" d="M140.194,72.658c-.038-.271.2-.24.53.071l.2-.44.134-.295a2.093,2.093,0,0,1,.921-.6l.214.048c.116.027.559.177.171.455-.063.046.045.349.056.348.48-.03.751.552,1.315.3.059-.026.366.182.355.2-.281.471.321.745.363,1.134.019.175-.055.489-.276.345-.471-.307-.956.308-1.369-.089-.031-.03-.261.044-.366.106l-.525.307a.649.649,0,0,1,.343-.984l.191.095.4.2c.474-.053.745-.267.6-.477l-.122-.157c-.122-.157-.5,0-.538-.358-.026-.24-.24-.225-.5.028a.783.783,0,0,1-.908.266l-.536-.105c-.349.291-.69.43-.757.31s-.158-.441-.057-.444l.071-.117Z" transform="translate(-7.258 -16.875)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23532" data-name="Path 23532" d="M215.5,46.94c-.076-.116.059-.221.3-.232s.685.453.929.295.987-.512,1.015-.374.249.446.433.388l.156-.07.3-.134a.743.743,0,0,1,.54-.982l-.016.665a.364.364,0,0,0,.183.222l.6-.167c.4.372.755.564.789.428s.221-.428.335-.34.446.259.481.181a.457.457,0,0,1,.57-.033l-.032.059-.179.341a1.408,1.408,0,0,1-1.486.331l-.519-.12-.438-.1a.5.5,0,0,1-.67.384l-.315-.068-.7-.153a3.265,3.265,0,0,1-.737.542c-.088.015-.266-.137-.2-.366l-.418-.034-.18-.015a.606.606,0,0,1-.22-.651l-.453.005Z" transform="translate(-18.54)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23533" data-name="Path 23533" d="M257.239,48.085c.035.1-.367.209-.891.238l-.111-.155a.256.256,0,0,1-.015-.2l.763-.176c.275-.555.571-.954.658-.888s.375-.069.415-.473l.579.407c.288.2.449.094.658-.071.391-.307.833-.1,1.233-.025.507.1.521.238.142.662l-.027.029a1.219,1.219,0,0,0-.173.384c-.057.185-.253.646-.658.608l-.172-.168-.317-.311c-.219.18-.433.172-.477-.018l-.127-.081c-.145-.092-.489-.023-.575-.122l-.4-.461a1.2,1.2,0,0,0-.509.824" transform="translate(-24.407)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23534" data-name="Path 23534" d="M317.81,72.5c-.29.017-.419.105-.288.195s1.036.225.866.4-.639.445-.63.168l-.475.1c-.444.091-.556-.327-.86-.419l-.265-.079c-.407.034-.5-.372-.211-.9l.669.109.415.068a2.719,2.719,0,0,0,1.129-.459l.22-.16c.428-.312.408-.4.492-.335.254.2.41.293.419-.113a.66.66,0,0,1,.416-.078c.191.121.481.24.35.512-.007.016-.191-.05-.272-.028l-.446.124c-.453.179-1.239.883-1.529.9" transform="translate(-37.264 -16.286)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23535" data-name="Path 23535" d="M243.732,81.224c-.1-.287-.144-.556-.091-.6a.859.859,0,0,1,.336-.151l.043.033a6.4,6.4,0,0,0,.579.458.816.816,0,0,0,1.1-.243l.1-.119c.162-.117.445.051.63.373l-.037.019-.633.316c.249.426.353.821.23.877l-.177.015-.565.046c-.616.167-1.242,0-1.391-.371l-.067-.368Z" transform="translate(-22.38 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23536" data-name="Path 23536" d="M145.58,74.291c-.139-.41-.325-.605-.413-.434s-.242.12-.158-.472l.02-.545,0-.071c.386-.078.541-.358.343-.624l.266-.3a4.056,4.056,0,0,1,.592-.668l.1-.074c.283.073.471.291.418.483h-.014l-.558-.07a.718.718,0,0,0,.317.856l.2.115c.088.05.206.2.18.23l-.476.56c.626.115.618.254-.016.307l-.437.381Z" transform="translate(-7.914 -16.713)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23537" data-name="Path 23537" d="M312.84,73.409c-.021-.145.017-.264.084-.264s.271-.08.287-.177l-.048-.051-.357-.381c.407-.129.739-.126.739.009s.17.468.379.48.932-.04,1.053.086.392.649.292.836.384.668.263.719-.581.105-.681-.022a4.806,4.806,0,0,0-1.136-.652l-.26.073-.286.081a2.792,2.792,0,0,1-.329-.737" transform="translate(-37.264 -17.108)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23538" data-name="Path 23538" d="M205.381,73.064c.128-.076.228.059.221.3l-.27.116c-.29.125-.669.15-.54.568l.126.409c.351-.063.589-.033.529.067s-.377.38-.514.3a5.9,5.9,0,0,0-.6-.294l-.052.028c-.28.15-.694.262-.8.472-.121.248-.193.424-.478.246-.111-.07-.068-.4.027-.562l.075-.131c.24-.084.336-.235.212-.336a.514.514,0,0,1,.061-.695l.385.025.57.038c.107-.382.258-.632.335-.555a1.111,1.111,0,0,0,.708,0" transform="translate(-16.417 -17.482)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23539" data-name="Path 23539" d="M227.46,79.626a.782.782,0,0,1,.439.451l-.3.126-.33.139a2.937,2.937,0,0,1-.889.457l-.147-.021-.2-.029c-.217-.065-.4-.22-.42-.342s-.36-.346-.733-.207-1.457.008-1.52-.238l.319.023.639.046c.207-.424.444-.683.526-.576s.383.3.5.208a1.556,1.556,0,0,1,.514-.289l.035.034c.108.105.185.231.295.333s.231.225.33.215l.334-.032c-.07-.217.422-.366.612-.3" transform="translate(-19.548 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23540" data-name="Path 23540" d="M173.888,47.132c-.113.021-.345-.276-.516-.66l-.254-.318-.266-.334c-.436.016-.651-.112-.478-.284l.194-.118c.085-.053.279.026.39-.015.836-.307.832-.311,1.267.292l.038.053c.113.094.205.031.205-.141s.138-.683.306-.482.47.676.407.743l-.076.031c-.883.356-.881.355-1.2,1.192Z" transform="translate(-11.946)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23541" data-name="Path 23541" d="M327.384,45.283c-.055.082-.244.046-.42-.079l-.1-.118c-.315-.383-.449-.432-.825-.225l-.232.128c-.371.067-.518-.041-.326-.24s.378-.848.514-.848.566.045.516.1.08.263.4.335l.314-.205c.215-.141.7-.307.773-.242.309.267.508-.013.747-.013.09,0,.259.113.254.164-.018.181.164.415-.271.5-.466.092-.164.141.047.218.112.04.257.234.222.3-.142.241-.233-.007-.35-.053-.146-.057-.42-.1-.426-.16-.05-.52-.464-.33-.758-.253-.6.159-.04.44-.075.662Z" transform="translate(-37.264)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23542" data-name="Path 23542" d="M224.439,80.926c.065.079.015.3-.111.482s-.6.762-.9.762h-.261c-.022,0-.847,0-.855,0-.241-.109-.442-.407-.781-.1-.024.022-.416-.117-.439-.213l-.1-.431a1.152,1.152,0,0,1-.724.145l-.024-.067c-.018-.052.051-.176.086-.178a3.718,3.718,0,0,1,.9.011l1.3.278c.1-.666.3-1.211.442-1.211s.337.21.125.466-.072,1.067.322.986l.183-.152c.146-.121.074-.4.16-.591l.081-.177a.488.488,0,0,1,.6-.015" transform="translate(-19.064 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23543" data-name="Path 23543" d="M211.469,80.232c-.1-.145-.123-.24-.064-.211l.613.285c.218.1.171.932.362.8l.1,0,.145-.005a.266.266,0,0,1,.136.394h-.082c-.685.013-1.351.559-2.07.03-.161-.117-.4,0-.415.257l-.006.077c-.236.107-.32-.056-.186-.361l.367-.238.16-.1a.524.524,0,0,1,.6-.145c.208.089.427-.635.333-.78" transform="translate(-17.454 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23544" data-name="Path 23544" d="M155.473,71.648a3.094,3.094,0,0,1,1.119-.119.429.429,0,0,0,.447.116l.179-.028c.058-.01.224.178.216.185l-.236.215a3.129,3.129,0,0,1-.842.505c-.188.053-.778.065-.721-.079s.109-.581-.033-.591-.548.064-.57.187-.3.3-.554.024a13.006,13.006,0,0,1-.85-.991,3.655,3.655,0,0,1,.91.433l.462.071Z" transform="translate(-9.243 -15.949)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23545" data-name="Path 23545" d="M324.009,44.694c.384.449.183.685-.448.524l-.477-.12a2.007,2.007,0,0,0-.441-.1l-.4.607c-.567-.276-.994-.75-.95-1.054l.474.344a.466.466,0,0,0,.352.054,6.257,6.257,0,0,1,1.931-.695c.115-.016.164-.281.294-.322.107-.033.3.087.439.156.247.12.262.36.042.412Z" transform="translate(-37.264)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23546" data-name="Path 23546" d="M201.273,75.2c.106-.269.107-.489,0-.489s-.472-.091-.414-.2l.043-.064c.1-.142.229-.412.292-.4l.7.112c0-.418.04-.533.1-.254l.451-.082c.033-.006.163.208.184.327a1.274,1.274,0,0,1-.476,1.034.6.6,0,0,1-.8.077Z" transform="translate(-16.056 -17.584)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23547" data-name="Path 23547" d="M137.651,72.623c.021.166-.092.215-.252.108s-.453-.691-.043-.9l.569.165c.38.111.787-.331.85-.765l.014-.1c.031-.071.2-.093.385-.05s.609.249.451.334-.362.36-.179.462.489.411.256.446l-.1-.072c-.835-.57-1.294.164-1.9.354Z" transform="translate(-4.421 -16.044)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23548" data-name="Path 23548" d="M99.4,54.977c-.46-.219-.7-.621-.525-.892l.406.238c.063.037.254-.045.368-.1.289-.136.525-.627.805-.415.38.288.527-.129.744-.027.112.053.251.247.213.3A2.617,2.617,0,0,1,99.765,55Z" transform="translate(0 -5.758)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23549" data-name="Path 23549" d="M138.254,72.947a.794.794,0,0,1,1.024.446l-.648-.027c-.088,0-.247-.017-.255,0l-.413,1.1c-1.062-.218-1.686-.67-1.386-1l.329.132c.463.187-.056-.767.624-.3.284.2-.114-.478.433-.4Z" transform="translate(-3.465 -17.059)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23550" data-name="Path 23550" d="M271.725,80.46c-.335.043-.419-.014-.187-.127s.386-.781.816-.752l.322-.068.275-.058c.291-.194.561-.241.6-.1l-.024.128-.023.13c-.1.146-.153.3-.12.335l.064.02c.213.065.672-.132.606.211l-.108.562a2.409,2.409,0,0,0-1.223-.656l-.5.187c-.076.028-.125.121-.2.134Z" transform="translate(-26.433 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23551" data-name="Path 23551" d="M275.621,80.315c-.175.216-.363.262-.418.1a2.184,2.184,0,0,1-.1-.96l.2-.125a.733.733,0,0,1,.6.059c.314.3.6-.363.859.013a5.259,5.259,0,0,1,.544.8l.083.187c-.037.358-.287.3-.555-.14l-.192-.284a.7.7,0,0,0-.694-.222c-.362.027-.188.262-.258.408Z" transform="translate(-26.934 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23552" data-name="Path 23552" d="M159.582,76.217c-.133-.054.059-.128.427-.167l-.119-.4a.681.681,0,0,1,.006-.538c.239-.345.175-.53-.293-.653-.113-.03-.272-.207-.247-.277.1-.269.21-.009.331.01l.33.054c.4.032.761.266.794.52l.085.2.1.246c.081.292.022.464-.132.383s-.7-.1-.7.1-.448.574-.581.521" transform="translate(-10.001 -18.02)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23553" data-name="Path 23553" d="M161.791,46.388a.442.442,0,0,1-.581-.007c-.144-.147-.69-.463-.735-.384s-.255.24-.344.152a.424.424,0,0,1,.134-.592l.214-.081c.409-.153.73-.141.823.309l.026.125a.268.268,0,0,0,.45-.054c.1-.181.187.389.013.532" transform="translate(-10.11)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23554" data-name="Path 23554" d="M298.312,46.667a.354.354,0,0,1-.461-.279c-.036-.214.7-.425.554-.466s-.442-.178-.438-.249l.035-.014a2.579,2.579,0,0,1,.674-.237l.179-.02c.216.081.359.214.319.295s-.055.343.078.359.51.14.51.24a.832.832,0,0,1-.618.451l-.168-.176c-.288-.3-.268-.288-.551-.014Z" transform="translate(-32.674)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23555" data-name="Path 23555" d="M191.6,79.055c.09.307-.132.269-.492-.085s-1.149-1.155-.762-1.258,1.4-.36,1.415-.345a.645.645,0,0,1-.281.22c-.177.091.031,1.161.12,1.468" transform="translate(-14.493 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23556" data-name="Path 23556" d="M181.482,46.061c0,.112-.054.2-.121.2l-.02-.014-.068-.048c-.069-.058-.194.062-.279.266s-1.3.586-1.3.432.1-.577.217-.588.484-.12.484-.213.158-.424.353-.433.734.292.734.4" transform="translate(-12.971)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23557" data-name="Path 23557" d="M235.44,47.477c.136.382-.016.371-.338-.024l-.71.112c-.094.015-.147-.154-.389-.075l-.38.124c-.477.01-.357-.052.266-.137l-.639-.622c-.006-.005.1-.122.144-.118a.687.687,0,0,1,.347.1c.427.363.415.363.835.01a.546.546,0,0,1,.328-.105c.1.088.223.281.181.32-.232.21-.333.262.13.367Z" transform="translate(-20.816)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23558" data-name="Path 23558" d="M177.429,45.673c.023-.266.3-.411.611-.321s1.019-.566.977-.25l.094.255c.186.509-.535.5-.675.863-.1.262-.845.015-.957-.374Z" transform="translate(-12.637)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23559" data-name="Path 23559" d="M324.735,71.924c-.356-.222-.6-.339-.548-.26a.222.222,0,0,1-.2.329c-.234,0-.769-.158-.657-.352l-.016-.172-.041-.434a4.745,4.745,0,0,1,1.7.257l.483.183c.041.015.065.156.028.194a.614.614,0,0,1-.288.151Z" transform="translate(-37.264 -15.708)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23560" data-name="Path 23560" d="M247.734,80.6c.226-.124.392-.068.367.122l-.1.086c-.241.2-.241.365.025.532l.309.193c0,.316-.212.488-.474.383l-.147.058-.209.082c-.173.233-.225.283-.117.111a1.037,1.037,0,0,0-.243-.962c-.223-.111.086-.666.249-.575l.15-.013Z" transform="translate(-22.748 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23561" data-name="Path 23561" d="M293.371,46.2c.123-.347.4-.48.617-.3l.1.2c.126.24.271.224.493.132l.09-.038a.213.213,0,0,1,.248.181l-.059.052c-.141.123-.35.191-.5.307l-.136.1c-.119.146-.977-.29-.854-.636" transform="translate(-29.518)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23562" data-name="Path 23562" d="M167.073,75.162c.2-.278.453-.28.56,0l.1.252.093.245c.131.353-.053.525-.408.383l-.254-.018L166.911,76c-.366.094-.039-.563.162-.841" transform="translate(-11.054 -18.058)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23563" data-name="Path 23563" d="M213.619,80.118c-.235-.324-.386-.622-.337-.662a1.789,1.789,0,0,1,.7-.137l.158.21.159.211c.284.005.494.12.466.256l.062.076.14.17a.451.451,0,0,1-.461.4l-.228-.022a.709.709,0,0,1-.414-.224Z" transform="translate(-17.86 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23564" data-name="Path 23564" d="M99.807,55.875c-.323-.312-.216-.482.238-.38l.253.036.165.023c.188-.011.269-.146.179-.3s.653-.2.922-.033-.2.909-.47.805l-.262-.041a5.079,5.079,0,0,1-.79-.026Z" transform="translate(0 -6.495)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23565" data-name="Path 23565" d="M201.4,48.054a1.649,1.649,0,0,1-.563.216c-.1,0-.248-.09-.111-.2s.387-.49.272-.616l.035-.1c.154-.414.349.071.376.026.266-.457.635-.041.943-.085l.12-.017c.242.3.218.652-.054.779l-.187-.046c-.224-.055-.367-.31-.662-.088Z" transform="translate(-16.04)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23566" data-name="Path 23566" d="M297.721,46.41a1.44,1.44,0,0,1,.173.466c0,.081-.152.195-.338.074s-.789-.28-.925-.083-.585.7-.772.612.042-.729.091-.956l.127-.166.1-.13a3.412,3.412,0,0,0,.709-.056c.127-.035.741.064.836.239" transform="translate(-29.935)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23567" data-name="Path 23567" d="M104.133,53.459a.981.981,0,0,1-.179.535c-.1.121-.508.273-.687.068l.017-.379a.521.521,0,0,0-.226-.432l-.232-.123c-.382-.077-.06-.148.716-.157l.494.408Z" transform="translate(0 -5.293)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23568" data-name="Path 23568" d="M199.428,77.584c.153,0,.346.242.429.537a1.5,1.5,0,0,1-.741,1.147c-.266.029-.379-.364-.327-.326s.243-.027.19-.312.3-1.046.449-1.046" transform="translate(-15.71 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23569" data-name="Path 23569" d="M99.868,62.908c-.506-.233-.635-.6-.286-.819l.223.373c.09.152.188.3.268.455.047.093.029.233.108.285.214.143.848-.156.665.371-.06.17-.468.259-.711.392l-.073.039c-.114.1-.238-.06-.277-.361l.027-.235Z" transform="translate(0 -10.811)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23570" data-name="Path 23570" d="M159.709,46.329c.078-.06.142,0,.142.14a.294.294,0,0,1-.4.25c-.221-.1-.6.212-.713-.052s-.415-.988-.2-.988.737.143.6.317l.021.127.022.138a.542.542,0,0,0,.531.068" transform="translate(-9.86)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23571" data-name="Path 23571" d="M105.036,52.585c.578-.072.5.229-.178.67l-.8-.366c-.09-.042-.187-.154-.182-.229a.3.3,0,0,1,.213-.2c.244.026.393-.35.756-.039Z" transform="translate(0 -4.873)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23572" data-name="Path 23572" d="M204.532,72.631a.186.186,0,0,1-.283.176c-.155-.065-1.463.091-1.744-.278l.751-.013c.416-.007-.1-.637.5-.359l.176.08a.493.493,0,0,1,.6.394" transform="translate(-16.312 -16.228)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23573" data-name="Path 23573" d="M186.685,46.623a1.047,1.047,0,0,1-.944-.482l.476-.261.09-.049c.051-.111.387-.092.746.043l.383-.013.1,0c.118.117-.066.29-.409.385l-.231.2Z" transform="translate(-13.855)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23574" data-name="Path 23574" d="M340.4,63.422a.9.9,0,0,1-.461-.057,1.461,1.461,0,0,1-.519-.5c-.08-.205.436-.572.572-.336l.156.183.178.208a4.24,4.24,0,0,1,1.064.342l-.389.265c-.285.193-.332.01-.5-.062Z" transform="translate(-37.264 -10.803)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23575" data-name="Path 23575" d="M186.728,70.867a.593.593,0,0,1,.331-.152l0,.01a3.012,3.012,0,0,1,.342,1.024c0,.2-.38.337-.741.307-.22-.018-.29-.04-.274-.227.006-.084-.139-.169-.162-.263l-.03-.117c.014-.138.138-.176.276-.085l.02-.015c.168-.121.665-.155.24-.478Z" transform="translate(-13.888 -15.681)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23576" data-name="Path 23576" d="M321.066,71.468c-.241-.3-.042-.486.442-.419l.326.133c.193.08.426.362.382.5a.64.64,0,0,1-.706.377c-.308-.023-.3-.146-.362-.337Z" transform="translate(-37.264 -15.736)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23577" data-name="Path 23577" d="M152.426,72.03c-.318-.192-.454-.383-.3-.423s.677-.067.693.066a.777.777,0,0,0,.7.5c.349-.044.587.518.465.354s-.941.1-1.268.069l-.165-.32Z" transform="translate(-8.948 -16.048)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23578" data-name="Path 23578" d="M304.765,45.915c.235.134.244.538.02.9l-.276-.1a3.367,3.367,0,0,1-.737-.385l-.111-.079a.349.349,0,0,1,.286-.393l.075.051c.229.159.392.242.677.056Z" transform="translate(-37.264)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23579" data-name="Path 23579" d="M203.45,47.683a2.1,2.1,0,0,1,.361-.073,6.444,6.444,0,0,0,.683-.107l.028.28c.029.288-.207.4-.612.3-.361-.088-.493,0-.462.295l.011.109a.551.551,0,0,1-.07.28c-.033.034-.134.1-.15.061a2.463,2.463,0,0,1-.109-.392l-.041-.131-.051-.162c-.071-.174.263-.423.412-.464" transform="translate(-16.354)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23580" data-name="Path 23580" d="M300.717,71.363a.487.487,0,0,0,.462-.246c.091-.163.36-.375.412-.135s-.741.835-1.064.935l-.226-.238c-.112-.118-.238-.355-.172-.433.168-.2.369-.063.537.075Z" transform="translate(-33.763 -15.651)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23581" data-name="Path 23581" d="M163.416,75.681c.162.18-.049.316-.468.305l-.3.032-.119.013a.206.206,0,0,0,.033.344l.115.074.058.037c.073.074.018.135-.123.135a.937.937,0,0,1-.663-.582l.148-.14a3.453,3.453,0,0,1,1.042-.545c.205-.083.274.024.278.21Z" transform="translate(-10.373 -18.351)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23582" data-name="Path 23582" d="M202.477,47.061c-.48-.264-.579-.413-.218-.332l.119-.4.029-.1a.661.661,0,0,1,.64.117l.111.172c.037.059-.14.258-.271.328Z" transform="translate(-16.187)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23583" data-name="Path 23583" d="M199.243,47.02c-.068-.22.183-.507.558-.639l.353-.084a1.246,1.246,0,0,1,.506.044c.044.01.081.119.077.181l0,.062a.161.161,0,0,1-.191.063c-.053-.031-.266.045-.343.247s-.888.346-.956.126" transform="translate(-15.802)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23584" data-name="Path 23584" d="M194.114,47.321c-.222-.139-.2-.388.057-.552l.357.158L194.7,47a1.414,1.414,0,0,1,.637-.133l-.01.024-.131.312c-.151.343-.861.254-1.083.114" transform="translate(-15.027)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23585" data-name="Path 23585" d="M291.228,81.052a.531.531,0,0,1-.734.163c-.255-.156.323-.762.147-.783s-.59-.141-.393-.207l.091-.037.112-.045c.125-.058.925.663.777.909" transform="translate(-28.999 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23586" data-name="Path 23586" d="M189.585,71.476c-.157-.195.2-.31.787-.256l.2.189.367.347c.3-.177.484-.206.414-.063l-.083.129a.62.62,0,0,1-.211.215.382.382,0,0,1-.24-.034c-.37-.148-.746-.29-1.1-.462Z" transform="translate(-14.409 -15.761)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23587" data-name="Path 23587" d="M178.9,79.091c.035.12-.24.305-.612.411l-.013-.47c0-.056-.166-.127-.27-.16l-.586-.191c.219-.231,1.446.29,1.481.41" transform="translate(-12.624 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23588" data-name="Path 23588" d="M233.786,81.748c-.32-.061-.458-.191-.3-.291l-.007-.073c-.037-.356.247-.31.516-.316.343-.008.324.181.308.362l-.05.542c.447-.1.557-.061.245.086l-.456-.2Z" transform="translate(-20.761 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23589" data-name="Path 23589" d="M182.917,70.582a.888.888,0,0,1-.632.379l-.258-.027a.294.294,0,0,1-.211-.2c0-.074.1-.171.193-.222.06-.034.179.009.263-.009l.433-.089c-.205-.288-.215-.523-.022-.523s.359.494.234.693" transform="translate(-13.247 -15.091)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23590" data-name="Path 23590" d="M95.248,68.184c0-.214.128-.173.286.091s.509.89.347.838a1.912,1.912,0,0,1-.633-.929" transform="translate(0 -14.022)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23591" data-name="Path 23591" d="M148.109,72.192c.426.219.331.456-.21.525l-.088.426c0,.009-.21.024-.244-.013-.073-.076-.163-.221-.122-.273.137-.176.3-.281.007-.5-.157-.115.127-.392.322-.309Z" transform="translate(-8.237 -16.356)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23592" data-name="Path 23592" d="M227.057,48.686c-.215-.275-.142-.461.164-.415s.958.114.735.5l-.43.16c-.073.027-.224.033-.255,0Z" transform="translate(-19.803)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23593" data-name="Path 23593" d="M344.072,62.36c-.132-.122.089-.212.493-.2l.3-.027.218-.02c.4-.115.447.07.114.412l-.248.179c-.3.212-.56.111-.824-.265Z" transform="translate(-37.264 -10.468)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23594" data-name="Path 23594" d="M287.351,81.3c-.3-.15-.433-.4-.3-.56a.55.55,0,0,1,.809.041l.171.3a.2.2,0,0,1-.047.219.561.561,0,0,1-.364.085Z" transform="translate(-28.533 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23595" data-name="Path 23595" d="M197.26,77.861c.01.032-.073.116-.185.187a1.936,1.936,0,0,0-.386.3,1.317,1.317,0,0,0,.572-.015l.268-.035a.306.306,0,0,1,.228.075l.033.045a1.061,1.061,0,0,1-.126.227h-.032l-.356.006a1.276,1.276,0,0,1-.872-.238c-.079-.129-.168-.586.052-.6a3.242,3.242,0,0,1,.8.052" transform="translate(-15.376 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23596" data-name="Path 23596" d="M186.331,75.1c.1-.211.362-.2.578.02l.153.227a1.155,1.155,0,0,1,.143.49.2.2,0,0,1-.127.161c-.12,0-.342-.032-.346-.065l-.033-.319a4.668,4.668,0,0,1-1.35-.435l.866-.07Z" transform="translate(-13.799 -18.015)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23597" data-name="Path 23597" d="M292.173,47.172a1.99,1.99,0,0,1-1.131-.149c-.22-.14-.286-.636.005-.564l.214.049c.12.028.288.018.354.081l.165.157a.452.452,0,0,1,.424-.083l0,.044Z" transform="translate(-29.128)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23598" data-name="Path 23598" d="M268.8,81.177c.116-.33.328-.5.471-.388s.4.444.261.466-.529.225-.555.407-.293-.156-.177-.485" transform="translate(-25.859 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23599" data-name="Path 23599" d="M187.969,78.648c.329.467.489.849.358.849s-.527-.176-.548-.39l-.105-.177c-.092-.155-.328-.25-.448-.4-.047-.057.014-.226.093-.278a.428.428,0,0,1,.342.006Z" transform="translate(-14.032 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23600" data-name="Path 23600" d="M204.954,72.721a.535.535,0,0,1,.713-.274c.327.1.9.692.682.643a2.589,2.589,0,0,1-.874-.375h-.067Z" transform="translate(-16.632 -16.389)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23601" data-name="Path 23601" d="M163.429,45.961c-.166.383-.318.4-.339.043l.054-.235a.491.491,0,0,1,.341-.3l.2.009a.643.643,0,0,1,.514.114v.085c0,.159.1.446-.258.381Z" transform="translate(-10.523)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23602" data-name="Path 23602" d="M176.2,46.147c.319.436.447.573.284.3s-.348-.993.017-.9l.289.086c.044.013.089.138.078.143Z" transform="translate(-12.408)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23603" data-name="Path 23603" d="M283.067,46.53c.276.307.347.592.156.635s-.728.089-.765.006l.018-.094c.034-.181.123-.355.163-.535l.015-.072c-.042-.088.022-.18.142-.206l.031.03Z" transform="translate(-27.854)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23604" data-name="Path 23604" d="M138.423,47.121c-.377.3-.728.334-.777.078s-.432-.694.172-.817l.326.4Z" transform="translate(-3.512)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23605" data-name="Path 23605" d="M345.7,49.647c-.42.042-.726-.037-.679-.175a1.421,1.421,0,0,1,.37-.533l.008,0,.315.214c.342.238.491.536.33.662L346,49.8Z" transform="translate(-37.264)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23606" data-name="Path 23606" d="M245.955,83.3c-.111-.133.041-.292.338-.354s.855.488.7.553a1.878,1.878,0,0,1-1.039-.2" transform="translate(-22.566 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23607" data-name="Path 23607" d="M227.5,82.757c.494.439.389.689-.234.556l-.494-.12c-.037-.009-.058-.128-.044-.19s.074-.157.128-.163Z" transform="translate(-19.774 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23608" data-name="Path 23608" d="M186.081,75.475c.4.735.019,1.132-1.031,1.142l1.031-1.142" transform="translate(-13.72 -18.365)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23609" data-name="Path 23609" d="M201.233,81.049c-.1-.329-.012-.6.2-.6a2.192,2.192,0,0,1,.992.246l.071.155a1.017,1.017,0,0,1,.076.372.356.356,0,0,1-.216.061,2.552,2.552,0,0,1-.444-.393l-.033-.039c.068-.1-.01-.2-.174-.225l-.057.049Z" transform="translate(-16.08 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23610" data-name="Path 23610" d="M194.4,80.978c.163.132.217.273.121.312s-.4,0-.408-.19-.587.136-.656.086a.258.258,0,0,1-.009-.356,1.383,1.383,0,0,1,.952.148" transform="translate(-14.932 -22.373)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23611" data-name="Path 23611" d="M277.071,74.605a.438.438,0,0,0-.669.1l-.141-.423a.47.47,0,0,1,.167-.459,1.852,1.852,0,0,1,.71-.182l.146-.018c.173.041.259.181.192.311l-.1.09c-.075.067-.306.09-.306.133Z" transform="translate(-26.992 -17.26)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23612" data-name="Path 23612" d="M101.741,70.436c.351-.448.676-.568.723-.267l-.438.214a2.591,2.591,0,0,1-1.009.1c-.027,0-.107-.172-.121-.267-.006-.044.124-.145.132-.142Z" transform="translate(0 -14.93)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23613" data-name="Path 23613" d="M282.552,72.94c.064-.347.572-.7,1.128-.782l.3.356.066.077c.022.114-.126.267-.332.34l-.05-.042c-.264-.22-.433-.131-.76-.044Z" transform="translate(-27.936 -16.285)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23614" data-name="Path 23614" d="M241.335,73.732a1.494,1.494,0,0,1-.438.351l-.214.144c-.191.129-.373.407-.629.151-.081-.081.1-.363.205-.534a1.227,1.227,0,0,1,.981-.439h.031a1.566,1.566,0,0,1,.064.327" transform="translate(-21.727 -17.133)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23615" data-name="Path 23615" d="M254.944,77.372c-.208-.024-.3-.164-.2-.311s.218-.655.031-.782l-.2-.042c-.327-.069-.342-.244-.186-.383.386-.344.24-.453-.239-.556-.134-.029-.225-.277-.282-.437a.648.648,0,0,1,.027-.37.405.405,0,0,1,.238-.02,1.459,1.459,0,0,1,.181.359l.025.065c0,.079.24.193.529.254s.848.365.61.539-.065,1.056-.273,1.369l-.225.264Z" transform="translate(-23.775 -18.632)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23616" data-name="Path 23616" d="M257.148,74.861a1.713,1.713,0,0,1,1.148-.186l-.349.23c-.115.076-.341.12-.358.2-.058.28.227.219.437.245l.381.046c.142.324.159.554.037.509l-.085-.029-.114-.039a.27.27,0,0,0-.373.213,3.479,3.479,0,0,1-.125.622.307.307,0,0,1-.134-.2c-.025-.11-.3-.476-.528-.476s-.809-.2-.58-.438l-.009-.214c-.009-.2-.113-.42.34-.458Z" transform="translate(-24.189 -18.303)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23617" data-name="Path 23617" d="M256.444,71.425a1.1,1.1,0,0,1,.142.7.664.664,0,0,1-.689.148c-.242-.138-.923-.352-.871-.509a1.288,1.288,0,0,1,.915-.611l.26.14Z" transform="translate(-23.935 -15.865)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23618" data-name="Path 23618" d="M256.855,73.688c.12.595-.117,1.146-.526,1.226s-1.083-.658-.653-1.011l.686.106a.381.381,0,0,0,.115-.269c-.041-.126-.2-.226-.244-.352-.021-.064.09-.212.171-.23.1-.021.319.039.333.092Z" transform="translate(-23.988 -17.297)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23619" data-name="Path 23619" d="M247.2,73.4a1.207,1.207,0,0,1-.778.047c-.178-.074-.767-.2-.853-.084s-.285.294-.239.127-.69-.6-.947-.92l-.189-.3-.108-.173a.367.367,0,0,1,.378-.452c.257,0,.764.16.573.356l.346.151c.273.119.268.334.29.561.047.493.318-.13.481.051l.148.166c.263.185.541.249.617.141s.531.232.281.333" transform="translate(-22.483 -16.47)" fill="#36c9f4"/> <path '.$svgColor.' id="Path_23620" data-name="Path 23620" d="M242.346,72.064c-.411-.2-.607-.4-.435-.446s.812.071.936.374l.1.3c.016.047-.065.162-.112.167-.117.012-.33,0-.348-.043Z" transform="translate(-21.975 -16.001)" fill="#36c9f4"/> </g> </svg>';

if ( !empty( $title )  ) : //&& !empty( $subtitle ) ?>
<div class="<?php echo esc_attr( $css_class ) . vc_shortcode_custom_css_class($css, ' '); ?>">
	<?php if ( !empty( $subtitle ) ) : ?>
        <span class="section-subtitle" <?php studiare_inline_style( $subtitle_color_style ); ?>><?php echo esc_html( $subtitle ); ?></span>
	<?php endif; ?>
	<?php if ( !empty( $title ) ) : ?>
		<h2 class="section-title" <?php studiare_inline_style( $title_color_style ); ?>>
		    <?php if($sc_studi_heading_style=="sc_head_style4"){echo $svg_head4;} ?>
		    <i class="<?php echo $icon;?>"></i><span><?php echo esc_html( $title ); ?></span></h2>
	<?php endif; ?>
</div>
<?php endif; ?>