<?php
/**
 * Template for rendering lesson sections
 *
 * @package Studiare
 */

/**
 * Render a single lesson section
 */
function render_lesson_section($section_data) {
    $output = '';
    $css_class = 'course-section';
    $rand_id = rand();
    $openclass = ($section_data['list_open_situ'] === 'on') ? ' active_tab_by_suncode' : '';

    $output .= '<div class="' . esc_attr($css_class) . '">';
    if (!empty($section_data['title'])) {
        $output .= '<div data-id="' . $rand_id . '" class="sc-course-lesson-toggle-wrapper">';
        $output .= '<h5 class="course-section-title">';
        if ($section_data['list_has_section_num'] === 'on') {
            $output .= '<span class="chapterholder">';
            if (!empty($section_data['section_num_title'])) {
                $output .= '<span class="scchapturetitle">' . esc_html($section_data['section_num_title']) . '</span>';
            }
            if (!empty($section_data['section_number'])) {
                $output .= '<span class="scchapturenumber">' . esc_html($section_data['section_number']) . '</span>';
            }
            $output .= '</span>';
        }
        if ($section_data['showicon'] === 'on') {
            $output .= '<i class="fal fa-ellipsis-h-alt"></i>';
        }
        $output .= ' ' . esc_html($section_data['title']);
        $output .= '</h5>';
        $output .= '<div class="sc-course-lesson-toggle"><i class="fad fa-chevron-down"></i></div>';
        $output .= '</div>';
    }

    $output .= '<div class="panel-group" style="display:none;">';
    if (is_array($section_data['lessons']) && !empty($section_data['lessons'])) {
        foreach ($section_data['lessons'] as $section_data['lesson']) {
            $access = restrict_content_access($section_data['user_id'], get_the_ID(), $section_data['lesson'], $section_data['quiz_settings'], $section_data);

            if (!$access['access']) {
                $output .= render_locked_content($section_data['lesson'], $access['message']);
                $section_data['global_index']++;
                $section_data['section_index']++;
                continue;
            }

            $post_type = get_post_type($section_data['lesson']);
            if ($post_type === 'sc-quiz') {
                $output .= render_quiz_content($section_data['lesson'], $section_data);
            } else {
                $output .= render_lesson_content($section_data['lesson'], $section_data);
            }

            $section_data['global_index']++;
            $section_data['section_index']++;
        }
    }
    $output .= '</div>';
    $output .= '</div>';

    // Inline JavaScript (kept as per request)
    $output .= '<script>';
    $output .= 'jQuery(".sc-course-lesson-toggle-wrapper").off("click").click(function(el) {';
    $output .= 'var id = jQuery(this).data("id");';
    $output .= 'var query = "[data-id=\'" + id + "\']";';
    $output .= 'var item = jQuery(query);';
    $output .= 'item.toggleClass("active_tab_by_suncode");';
    $output .= 'item.next(".panel-group").slideToggle();';
    $output .= '});';
    if ($section_data['list_open_situ'] === 'on') {
        $output .= 'jQuery(document).ready(function() {';
        $output .= 'var query = "[data-id=\'" + ' . $rand_id . ' + "\']";';
        $output .= 'var item = jQuery(query);';
        $output .= 'item.toggleClass("active_tab_by_suncode");';
        $output .= 'item.next(".panel-group").slideToggle();';
        $output .= '});';
    }
    $output .= '</script>';

    return $output;
}

/**
 * Render locked content
 */
function render_locked_content($lesson, $message) {
    $post_type = get_post_type($lesson);
    $output = '<div class="course-panel-heading">';
    $output .= '<div class="panel-heading-left">';
    $output .= '<div class="course-lesson-icon"><i class="fas fa-lock"></i></div>';
    $output .= '<div class="title"><h4>';
    if ($post_type === 'sc-quiz') {
        $post = get_post($lesson);
        $quiz_title = !empty($post->post_title) ? $post->post_title : __('Quiz', 'studiare');
        $output .= esc_html($quiz_title);
        $output .= '<span class="badge-item quiz">' . __('Quiz', 'studiare') . '</span>';
    } else {
        $item = get_post_meta($lesson, 'lesson_data', true);
        $title = isset($item[0]['lesson_title']) ? $item[0]['lesson_title'] : '';
        $output .= esc_html($title);
    }
    $output .= '</h4></div>';
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="panel-content">';
    $output .= '<div class="panel-content-inner">';
    $output .= '<div class="lessonaccessdenied">';
    $output .= '<span class="icon"><i class="fas fa-exclamation-triangle"></i></span>';
    $output .= esc_html($message);
    $output .= '</div>';
    $output .= '</div>';
    $output .= '</div>';

    return $output;
}

/**
 * Render quiz content
 */
function render_quiz_content($lesson, $section_data) {
    $post = get_post($lesson);
    $quiz_title = !empty($post->post_title) ? $post->post_title : __('Quiz', 'studiare');
    $restrict_to_members = get_post_meta($lesson, '_quiz_restrict_to_members', true);
    $restrict_to_products = get_post_meta($lesson, '_quiz_restrict_to_products', true);
    $widget_description = get_post_meta($lesson, '_quiz_widget_description', true);
    $current_product_id = get_the_ID();

    $output = '<div class="course-panel-heading scquiz">';
    $output .= '<div class="panel-heading-left">';
    $output .= '<div class="course-lesson-icon"><i class="fal fa-question-circle"></i></div>';
    $output .= '<div class="title">';
    $output .= '<h4>' . esc_html($quiz_title);
    $output .= '<span class="badge-item quiz">' . __('Quiz', 'studiare') . '</span>';
    $output .= '</h4>';
    if (!empty($widget_description)) {
        $output .= '<p class="subtitle">' . esc_html($widget_description) . '</p>';
    }
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="panel-heading-right">';
    if ($restrict_to_members === 'yes') {
        $output .= '<div class="private-lesson"><i class="fa fa-user-lock"></i><span>' . esc_html__('for Users', 'studiare') . '</span></div>';
    }
    if (is_array($restrict_to_products) && !empty($restrict_to_products)) {
        $output .= '<div class="private-lesson"><i class="fa fa-lock"></i><span>' . esc_html__('Private', 'studiare') . '</span></div>';
    }
    $output .= '</div>';
    $output .= '</div>';
    $output .= '<div class="panel-content scquiz">';
    $output .= '<div class="panel-content-inner">';
    $quiz_shortcode_output = do_shortcode('[studiare_quiz pid="' . esc_attr($current_product_id) . '" id="' . esc_attr($lesson) . '"]');
    $output .= $quiz_shortcode_output ?: '<p>' . esc_html__('Quiz content not available.', 'studiare') . '</p>';
    $output .= '</div>';
    $output .= '</div>';

    return $output;
}

/**
 * Render lesson content
 */
function render_lesson_content($lesson, $section_data) {
    $item = get_post_meta($lesson, 'lesson_data', true);
    if (!is_array($item) || empty($item)) {
        return '';
    }

    $icon = isset($item[0]['icon']) ? sanitize_text_field($item[0]['icon']) : null;
    $title = isset($item[0]['lesson_title']) ? sanitize_text_field($item[0]['lesson_title']) : null;
    $subtitle = isset($item[0]['lesson_subtitle']) ? sanitize_text_field($item[0]['lesson_subtitle']) : null;
    $badge = isset($item[0]['badge']) ? sanitize_text_field($item[0]['badge']) : null;
    $preview_video = isset($item[0]['preview_video']) ? esc_url($item[0]['preview_video']) : '';
    $private_lesson = isset($item[0]['private_lesson']) ? $item[0]['private_lesson'] : null;
    if ($private_lesson === 'on') {
        $private_lesson = 'lesson_protected';
    }
    $sc_pls = isset($item[0]['sc_pls']) ? $item[0]['sc_pls'] : null;
    $content = wpautop(get_post_field('post_content', $lesson));
    $atts = [
        'sc_download_file' => isset($item[0]['sc_download_file']) ? $item[0]['sc_download_file'] : '',
        'sc_download_access' => isset($item[0]['sc_download_access']) ? $item[0]['sc_download_access'] : '',
    ];
    $lesson_video = isset($item[0]['lesson_video']) ? esc_url($item[0]['lesson_video']) : null;
    $lesson_audio = isset($item[0]['lesson_audio']) ? esc_url($item[0]['lesson_audio']) : null;
    $lesson_number_auto = codebean_option('sc_lesson_number_auto') ?? false;
    $login_toast_title = codebean_option('login_toast_title');
    $login_toast_message = codebean_option('login_toast_message');
    $bought_toast_title = codebean_option('bought_toast_title');
    $bought_toast_message = codebean_option('bought_toast_message');
    $login_placeholder = codebean_option('login_lesson_message');

    $output = '<div class="course-panel-heading">';
    $output .= '<div class="panel-heading-left">';
    if ($lesson_number_auto || (!empty($icon) && !$lesson_number_auto)) {
        $output .= '<div class="course-lesson-icon">';
        if ($lesson_number_auto) {
            $output .= '<span class="lesson-number">' . esc_html($section_data['lesson_number']) . '</span>';
        } else {
            $icon = substr_replace($icon, ' ', 3, -strlen($icon));
            $output .= "<i class='" . esc_attr($icon) . "'></i>";
        }
        $output .= '</div>';
    }
    if (!empty($title) || !empty($subtitle)) {
        $output .= '<div class="title">';
        $output .= '<h4>' . esc_html($title);
        if (!empty($badge) && $badge !== 'no_badge') {
            $output .= '<span class="badge-item ' . esc_attr($badge) . '">' . esc_html(add_class_value_in_any_lang($badge)) . '</span>';
        }
        $output .= '</h4>';
        if (!empty($subtitle)) {
            $output .= '<p class="subtitle">' . esc_html($subtitle) . '</p>';
        }
        $output .= '</div>';
    }
    $output .= '</div>';

    $section_data['lesson_number']++;

    if (!empty($preview_video) || !empty($private_lesson) || !empty($sc_pls)) {
        if (str_contains($preview_video, '.aparat.com/v')) {
            $course_video_aparat = substr($preview_video, strrpos($preview_video, '/') + 1);
            $preview_video = studi_get_aparat_file_link($course_video_aparat);
        }

        $output .= '<div class="panel-heading-right">';
        if (!empty($preview_video)) {
            $output .= '<a class="video-lesson-preview preview-button" href="' . esc_url($preview_video) . '"><i class="fa fa-play-circle"></i>' . esc_html__('Preview', 'studiare') . '</a>';
        }
        if ($private_lesson === 'lesson_protected') {
            $output .= '<div class="private-lesson"><i class="fa fa-lock"></i><span>' . esc_html__('Private', 'studiare') . '</span></div>';
        } elseif ($private_lesson === 'lesson_free_users') {
            $output .= '<div class="private-lesson"><i class="fa fa-user-lock"></i><span>' . esc_html($login_placeholder ?: __('for Users', 'studiare')) . '</span></div>';
        }
        $sc_protect_link_status = ($sc_pls === 'on') ? 'true' : 'false';
        if ($atts['sc_download_file'] !== 'none') {
            $output .= generate_dl_section($atts, get_the_ID(), $private_lesson, $section_data['bought_course'], $login_toast_title, $login_toast_message, $bought_toast_title, $bought_toast_message, $sc_protect_link_status);
        }
        $output .= '</div>';
    }
    $output .= '</div>';

    $output .= '<div class="panel-content">';
    $output .= '<div class="panel-content-inner">';
    if ($private_lesson === 'lesson_protected' && !$section_data['bought_course']) {
        $output .= '<div class="lessonaccessdenied">';
        $output .= '<span class="icon"><i class="fas fa-exclamation-triangle"></i></span>';
        $output .= wp_kses_post(codebean_option('private_lesson_message') ?: __('This lesson is private, for full access you need to buy this course.', 'studiare'));
        $output .= '</div>';
    } elseif ($private_lesson === 'lesson_free_users' && !is_user_logged_in()) {
        $output .= '<div class="lessonaccessdenied">';
        $output .= '<span class="icon"><i class="fas fa-user-lock"></i></span>';
        $output .= esc_html__('This lesson is private. Please log in to access.', 'studiare');
        $output .= '</div>';
    } else {
        $output .= do_shortcode($content);
        if (!empty($lesson_video) || !empty($lesson_audio)) {
            $output .= '<div class="sc_le_vi_au">';
            if (!empty($lesson_video)) {
                $output .= '<video preload="none" style="width:100%" controls controlsList="nodownload" oncontextmenu="return false;"><source src="' . esc_url($lesson_video) . '"></video>';
            }
            if (!empty($lesson_audio)) {
                $output .= '<audio preload="none" style="width:100%" controls controlsList="nodownload" oncontextmenu="return false;"><source src="' . esc_url($lesson_audio) . '"></audio>';
            }
            $output .= '</div>';
        }
    }
    $output .= '</div>';
    $output .= '</div>';

    return $output;
}