<?php
/**
 * Plugin Name: Studiare Importer
 * Plugin URI: http://studiaretheme.ir/
 * Description: Import Studiare demo content, widgets and theme settings with one click.
 * Version: 11.0
 * Requires at least: 6.1
 * Requires PHP:   5.6
 * Author: Suncode
 * Author URI: http://studiaretheme.ir/
 * @package   studiare-importer
 * @copyright (c) 2021, Suncode
 */
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'STUDIARE_IMPORTER' ) ) {

	define( 'STUDIARE_IMPORT_VERSION', '13.1' );

	class STUDIARE_IMPORTER {

		private static $instance = null;

		public static function get_instance() {
			if ( ! self::$instance ) {
				self::$instance = new self;
			}

			return self::$instance;
		}

		public function __construct() {
			self::$instance = $this;
			require_once plugin_dir_path( __FILE__ ) . 'importer/studiare-importer.php';
			require_once plugin_dir_path( __FILE__ ) . 'init.php';
			require_once plugin_dir_path( __FILE__ ) . 'render.php';
			require_once plugin_dir_path( __FILE__ ) . 'hook.php';


			add_action( 'admin_menu', array( $this, 'add_admin' ), 99 );
			
			STUDI_PROCESS_IMPORTER::get_instance();
		}

		/** add admin */
		public function add_admin() {
			$page = add_submenu_page( 'studiare_panel', esc_html__("Import Studiare Demos","studiare"),esc_html__("Import Demos","studiare"),  'switch_themes', 'studiare-importer', array(
				$this,
				'render_panel'
			) );
			add_action( 'load-' . $page, array( $this, 'load' ) );
		}

		public function load() {
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue' ) );
		}

		/** load scripts */
		public function enqueue() {
			wp_enqueue_script( 'rb-importer-js', get_template_directory_uri() . '/inc/studi_panel/studiare-demo-importer/assets/importer.js', array( 'jquery' ), STUDIARE_IMPORT_VERSION, true );
			wp_enqueue_style( 'rb-importer-style', get_template_directory_uri() . '/inc/studi_panel/studiare-demo-importer/assets/importer.css', STUDIARE_IMPORT_VERSION, true );
			wp_localize_script( 'rb-importer-js', 'RBImporter', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ) ) );
		}

		

		/** render panel */
		public function render_panel() {
			STUDI_RENDER_IMPORTER::get_instance();
		}
	}
}

/** load plugin */
STUDIARE_IMPORTER::get_instance();