<?php

 /**
 * This file will generate studiare panel
 * created date: 18-02-2022 | 1400-11-28
 */

 /**
 * Register Studiare Panel Page.
 */
include "studiare-demo-importer/studiare-importer.php"; 
function studi_add_panel_link() {
    add_menu_page(
        __( 'Studiare Panel', 'studiare' ),
        __( 'Studiare Panel', 'studiare' ),
        'manage_options',
        'studiare_panel',
        'studiare_panel_callback',
        get_template_directory_uri() . '/assets/images/icons/studiare_panel.png',
        3
    );
}
add_action( 'admin_menu', 'studi_add_panel_link', 8 );

function studi_add_panel_link_topbar($wp_admin_bar) {
    
    // Add required CSS for the menu styling
    $parent_theme = wp_get_theme(get_template()); // Gets the parent theme
    $t_version = $parent_theme->get('Version');
    
    $args = array(
        'id' => 'studiare-panel',
        'title' => __('Studiare Panel', 'studiare') . "<span class='version-tag'>v{$t_version}</span>",
        'href' => get_admin_url() . 'admin.php?page=studiare_panel',
    );
    $wp_admin_bar->add_node($args);
    
    // Array of menu items with their icons and subtitles
    $menu_items = [
        [
            'id' => 'studiare_panel',
            'title' => 'Studiare Panel',
            'href' => 'admin.php?page=studiare_panel',
            'icon' => '<svg width="40" height="40" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M8.4 3H4.6A1.6 1.6 0 0 0 3 4.6v3.8A1.6 1.6 0 0 0 4.6 10h3.8A1.6 1.6 0 0 0 10 8.4V4.6A1.6 1.6 0 0 0 8.4 3Z" fill="#3D84FC" fill-opacity=".16" stroke="#3D84FC" stroke-width="1.5" stroke-miterlimit="10"></path><path d="M19.4 3h-3.8A1.6 1.6 0 0 0 14 4.6v3.8a1.6 1.6 0 0 0 1.6 1.6h3.8A1.6 1.6 0 0 0 21 8.4V4.6A1.6 1.6 0 0 0 19.4 3ZM8.4 14H4.6A1.6 1.6 0 0 0 3 15.6v3.8A1.6 1.6 0 0 0 4.6 21h3.8a1.6 1.6 0 0 0 1.6-1.6v-3.8A1.6 1.6 0 0 0 8.4 14Z" fill="#ffffff" stroke="#3D84FC" stroke-width="1.5" stroke-miterlimit="10"></path><path d="M19.4 14h-3.8a1.6 1.6 0 0 0-1.6 1.6v3.8a1.6 1.6 0 0 0 1.6 1.6h3.8a1.6 1.6 0 0 0 1.6-1.6v-3.8a1.6 1.6 0 0 0-1.6-1.6Z" fill="#3D84FC" fill-opacity=".16" stroke="#3D84FC" stroke-width="1.5" stroke-miterlimit="10"></path></g></svg>'
        ],
        [
            'id' => 'studiare-theme-settings',
            'title' => 'Theme Settings',
            'href' => 'admin.php?page=theme-options',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492zM5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0z"/><path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52l-.094-.319z"/></svg>'
        ],
        [
            'id' => 'studiare-header',
            'title' => 'Header',
            'href' => 'edit.php?post_type=studi_header',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z"/><path d="M3 3.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5z"/></svg>'
        ],
        [
            'id' => 'studiare-footer',
            'title' => 'Footer',
            'href' => 'edit.php?post_type=studi_footer',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z"/><path d="M3 12.5a.5.5 0 0 1 .5-.5h9a.5.5 0 0 1 0 1h-9a.5.5 0 0 1-.5-.5z"/></svg>'
        ],
        [
            'id' => 'studiare-megamenu',
            'title' => 'Megamenu',
            'href' => 'edit.php?post_type=sc_megamenu',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M1 2.5A1.5 1.5 0 0 1 2.5 1h3A1.5 1.5 0 0 1 7 2.5v3A1.5 1.5 0 0 1 5.5 7h-3A1.5 1.5 0 0 1 1 5.5v-3zm8 0A1.5 1.5 0 0 1 10.5 1h3A1.5 1.5 0 0 1 15 2.5v3A1.5 1.5 0 0 1 13.5 7h-3A1.5 1.5 0 0 1 9 5.5v-3zm-8 8A1.5 1.5 0 0 1 2.5 9h3A1.5 1.5 0 0 1 7 10.5v3A1.5 1.5 0 0 1 5.5 15h-3A1.5 1.5 0 0 1 1 13.5v-3zm8 0A1.5 1.5 0 0 1 10.5 9h3a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1-1.5 1.5h-3A1.5 1.5 0 0 1 9 13.5v-3z"/></svg>'
        ],
        [
            'id' => 'studiare-download',
            'title' => 'Downloads',
            'href' => 'edit.php?post_type=cdownload',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M.5 9.9a.5.5 0 0 1 .5.5v2.5a1 1 0 0 0 1 1h12a1 1 0 0 0 1-1v-2.5a.5.5 0 0 1 1 0v2.5a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2v-2.5a.5.5 0 0 1 .5-.5z"/><path d="M7.646 11.854a.5.5 0 0 0 .708 0l3-3a.5.5 0 0 0-.708-.708L8.5 10.293V1.5a.5.5 0 0 0-1 0v8.793L5.354 8.146a.5.5 0 1 0-.708.708l3 3z"/></svg>'
        ],
        [
            'id' => 'studiare-lessons',
            'title' => 'Lessons',
            'href' => 'edit.php?post_type=studi_lesson',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M1 2.828c.885-.37 2.154-.769 3.388-.893 1.33-.134 2.458.063 3.112.752v9.746c-.935-.53-2.12-.603-3.213-.493-1.18.12-2.37.461-3.287.811V2.828zm7.5-.141c.654-.689 1.782-.886 3.112-.752 1.234.124 2.503.523 3.388.893v9.923c-.918-.35-2.107-.692-3.287-.81-1.094-.111-2.278-.039-3.213.492V2.687zM8 1.783C7.015.936 5.587.81 4.287.94c-1.514.153-3.042.672-3.994 1.105A.5.5 0 0 0 0 2.5v11a.5.5 0 0 0 .707.455c.882-.4 2.303-.881 3.68-1.02 1.409-.142 2.59.087 3.223.877a.5.5 0 0 0 .78 0c.633-.79 1.814-1.019 3.222-.877 1.378.139 2.8.62 3.681 1.02A.5.5 0 0 0 16 13.5v-11a.5.5 0 0 0-.293-.455c-.952-.433-2.48-.952-3.994-1.105C10.413.809 8.985.936 8 1.783z"/></svg>'
        ],
        [
            'id' => 'studiare-notifications',
            'title' => 'Notifications',
            'href' => 'edit.php?post_type=sc_notification',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M8 16a2 2 0 0 0 2-2H6a2 2 0 0 0 2 2zm.995-14.901a1 1 0 1 0-1.99 0A5.002 5.002 0 0 0 3 6c0 1.098-.5 6-2 7h14c-1.5-1-2-5.902-2-7 0-2.42-1.72-4.44-4.005-4.901z"/></svg>'
        ],
        [
            'id' => 'studiare-teacher',
            'title' => 'Teachers',
            'href' => 'edit.php?post_type=teacher',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M7 14s-1 0-1-1 1-4 5-4 5 3 5 4-1 1-1 1H7zm4-6a3 3 0 1 0 0-6 3 3 0 0 0 0 6z"/><path fill-rule="evenodd" d="M5.216 14A2.238 2.238 0 0 1 5 13c0-1.355.68-2.75 1.936-3.72A6.325 6.325 0 0 0 5 9c-4 0-5 3-5 4s1 1 1 1h4.216z"/><path d="M4.5 8a2.5 2.5 0 1 0 0-5 2.5 2.5 0 0 0 0 5z"/></svg>'
        ],
        [
            'id' => 'studiare-iplugins',
            'title' => 'Install Plugins',
            'href' => 'admin.php?page=tgmpa-install-plugins',
            'icon' => '<svg width="20" height="20" fill="currentColor" viewBox="0 0 16 16"><path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4z"/></svg>'
        ]
    ];
    
    // Add submenu items with icons and subtitles
    foreach ($menu_items as $item) {
        $args = array(
            'id' => $item['id'],
            'title' => '<span class="menu-icon">' . $item['icon'] . '</span>' . 
                      '<span class="menu-text">' .
                        '<span class="menu-title">' . __($item['title'], 'studiare') . '</span>' .
                      '</span>',
            'href' => get_admin_url() . $item['href'],
            'parent' => 'studiare-panel'
        );
        $wp_admin_bar->add_node($args);
    }
}

add_action('admin_bar_menu', 'studi_add_panel_link_topbar', 62);

function studiare_panel_callback(){
    
    ?>
    <style>
        .studiare_panel_holder { margin: 20px auto;}
        .studiare_panel_holder:not(:first-child) { padding-top: 3.5rem;}
        .studipnl_header,.studipnl_footer { background: #fff; padding: 20px; border-radius: 7px; box-shadow: 0 0 20px #eceff1; color: #90a4ae;display: flex; justify-content: space-between; }
        .studipnl_header h2 { color: #90a4ae; font-size: 14px; margin: 0; font-weight: 100; }
        .studipnl_content { background: #fff; padding: 20px; border-radius: 7px; box-shadow: 0 0 20px #eceff1; margin: 20px 0;display: flow-root; position: relative;background: repeating-linear-gradient(45deg, white, #fcfdfe 40px); }
        
        
        .studipnl_icon { font-size: 47px; margin-bottom: 15px; color: #eeeeee; position: absolute; transform: rotate(-25deg); bottom: -20px; right: -20px; }
        .studipnl_box a { color: gray; text-decoration: none; font-size: 14px; padding: 0; display: flex; min-height: 100px; align-items: center; justify-content: center; width: 100%;font-variation-settings: "wght" 650; }
        .studipnl_box:hover a, .studipnl_box:hover .studipnl_icon { color: #fff; }
        .studipnl_box:hover { background: #03a9f4;border-radius:10px; }
        .studipnl_box:before { content: ""; width: 50px; height: 50px; background: #03a9f4; position: absolute; left: -25px; top: -25px; border-radius: 0 0 100px;transition: .4s; }
        .studipnl_box:hover:before { transform: scale(2) translate(21px, -6px); z-index: 2; background: #03a9f4; }
        
        .studipnl_boxes { display: block; width: 50%; float: right;}
        .studipnl_box { background:#fff;box-shadow: 0 0 10px #ede7f6; border-radius: 4px; text-align: center; width: calc(33.33% - 30px); margin: 10px; transition: .3s; overflow: hidden; position: relative; min-height: 100px; align-items: center; justify-content: center; display: inline-block; }
        .studipnl_header h2 small { background: #03a9f4; border-radius: 3px; position: relative; top: -2px; right: revert; padding: 0 5px; color: #ffffff; margin: 0 5px; box-shadow: 0 0 5px #03a9f4; }
        .spicons_description { min-height: 50px; }
        a.sun_rtl_link {color:#80808b; text-decoration: none;  }
        .spicons_cone{width:70%;}
        .spicons_ctwo{width:30%;}
        .studiare-nav { position: relative; display: flex}
        .studiare-nav-inner { margin: 0; width: 15rem; min-width: 15rem; border-left: 1px solid rgba(209, 218, 232, 0.5); padding-left: 1.25rem; padding-top: 1.25rem; }
        .studiare-nav > a:not(.selected), .studiare-nav .studiare-nav-inner a:not(.selected) { opacity: 0.75; }
        .studiare-nav > a, .studiare-nav .studiare-nav-inner a { padding: 0 0.5rem; display: block; height: 2.5rem; color: inherit; gap: 0.4rem; position: relative; border-radius: .75rem; display: flex ; align-items: center; transition: .45s; font-variation-settings: "wght" 600;}
        .studiare-nav > a.selected, .studiare-nav .studiare-nav-inner a.selected { background-color: #3d84fc; color: #fff; }
        .studiare-nav-inner li { margin-bottom: 0;}
        .studiare-nav-inner li a { text-decoration: none;}
        .studiare-nav .docs > svg { display: inline-block; vertical-align: middle; margin: -2px 5px 0 0; }
        .rtl .studiare-nav .docs > svg { margin: -2px 0 0 5px; }
        .o-notice.warning { border-right: 5px solid #d67337; background-color: #fff5ef; color: #d67337; border-left: navajowhite; }        a:focus { box-shadow: none; outline: none; }
        .studiare_panel_holder .notice { margin: 10px 0; }
        mark { background: transparent; }
        .studiare-hub-intro .studiare-hub-container { -webkit-box-pack: justify; -webkit-justify-content: space-between; -ms-flex-pack: justify; justify-content: space-between; display: -webkit-box; display: -webkit-flex; display: -ms-flexbox; display: flex; -webkit-box-align: center; -ms-flex-align: center; -webkit-align-items: center; align-items: center; }
        .studiare-hub-intro .details { line-height: 1.5; font-size: inherit; display: -webkit-inline-box; display: -webkit-inline-flex; display: -ms-inline-flexbox; display: inline-flex; -webkit-box-align: center; -ms-flex-align: center; -webkit-align-items: center; align-items: center; }
        .studiare-hub-intro .details-icon { background-image: url(../wp-content/themes/studiare/assets/images/icons/favicon.png); background-size: contain; background-repeat: no-repeat; height: 40px; width: 40px; }
        .studiare-hub-intro { background-color: rgba(252, 252, 252, 0.9); padding: 10px 20px; min-height: 42px; position: fixed; z-index: 10; left: 160px; right: 0; top: 32px; box-shadow: 0 0 20px #d6d6d6; }
        .rtl .studiare-hub-intro { right: 160px; left: 0; }
        .studiare-nav-inner a i { padding: 0.25rem; display: inline-flex ; vertical-align: middle; align-items: center; border-radius: .5rem; }
        .studiare-nav-inner a.selected i { background-color: #fff; }
        .studiare-nav > a.selected i, .studiare-nav .studiare-nav-inner a.selected i { color: #3d84fc; }
        .sce-page-container { flex-grow: 2; padding: 1.25rem; }
        @media screen and (max-width: 782px) { .studiare-nav {flex-direction: column; } .studiare-hub-intro, .rtl .studiare-hub-intro { right: 0; left: 0; } .studiare-hub-container { margin-left: 0 !important; } .studiare-nav-inner, .sce-page-container{padding-left: 0; padding-right: 0} }
        @media screen and (max-width: 600px) { .studiare-hub-intro { top: 46px;padding: 10px;} .studiare-nav-inner{border: none;} }
        @media screen and (max-width: 960px) and (min-width: 783px) { .studiare-hub-intro { right: 0; left: 36px; }  .rtl .studiare-hub-intro { right: 36px ; left: 0; } }
        .studiare-hub-intro .details h1 { font-size: 1.2em; margin-left: 10px; }
        .rtl .studiare-hub-intro .details h1 { margin-right: 10px; margin-left: 0; }
        .tablenav p { display: none !important; }
       .rtl td.version.column-version span { text-align: left !important; float: left !important; }
       .o-notice.gray { border-right: 5px solid #9E9E9E; background-color: #E0E0E0; border-left: none; }
       .o-notice.gray a.btn { background-color: #9e9e9e; border: 1px solid #9e9e9e}
       @media screen and (max-width: 600px) { .studiare-nav-inner { flex-wrap: wrap; } }
    </style>
    <script>
        jQuery(document).ready(function($){
            function switchTab(tabId) {
                $('.studiare_panel_holder #tabs > ul a').removeClass('selected');
                $('.studiare_panel_holder #tabs > ul a[href="' + tabId + '"]').addClass('selected');
                $('.studiare_panel_holder #tabs .tab-item').hide();
                $(tabId).show();
            }
        
            $('.studiare_panel_holder #tabs > ul a:not(.docs)').on('click', function(e) {
                e.preventDefault();
                switchTab($(this).attr('href'));
            });
        
            var hash = window.location.hash;
            if (hash) {
                switchTab(hash);
            }
        
            if ($('#tabs-2 mark.no').length) {
                $('.wp-header-end').after('<div class="notice o-notice warning"><div class="holder scinlinelink"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-exclamation-triangle" viewBox="0 0 16 16"><path d="M7.938 2.016A.13.13 0 0 1 8.002 2a.13.13 0 0 1 .063.016.146.146 0 0 1 .054.057l6.857 11.667c.036.06.035.124.002.183a.163.163 0 0 1-.054.06.116.116 0 0 1-.066.017H1.146a.115.115 0 0 1-.066-.017.163.163 0 0 1-.054-.06.176.176 0 0 1 .002-.183L7.884 2.073a.147.147 0 0 1 .054-.057zm1.044-.45a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566z"/><path d="M7.002 12a1 1 0 1 1 2 0 1 1 0 0 1-2 0zM7.1 5.995a.905.905 0 1 1 1.8 0l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995z"/></svg> وضعیت سیستم خود را بررسی کنید تا مطمئن شوید که سرور شما به درستی پیکربندی شده است. <a href="#tabs-2" class="btn wrning"> مشاهده وضعیت </a></div></div>');
                
                $('.o-notice.warning a[href="#tabs-2"]').on('click', function(e) {
                    e.preventDefault();
                    switchTab('#tabs-2');
                });
            }
        });
    </script>
    <div class="studiare-hub-intro">
		<div class="studiare-hub-container">
			<div class="details">
				<i class="details-icon"></i>
				<h1><?php _e( 'Studiare Panel', 'studiare' ); ?></h1>
			</div>
			<div class="mode-switcher">
				<a href="admin.php?page=studiare_panel" class="btn btn-flat"><?php _e( 'Studiare Panel', 'studiare' ); ?></a>
				<a href="admin.php?page=theme-options" class="btn btn-outline"><?php _e( 'Theme Settings', 'studiare' ); ?></a>
			</div>
		</div>
	</div>
    <div class="studiare_panel_holder">
        <div class="wp-header-end"></div>
        <div id="tabs" class="studiare-nav">
				<ul class="studiare-nav-inner">
					<li><a href="#tabs-1" class="selected"><i><svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" stroke="#000000"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"><path d="M8.4 3H4.6A1.6 1.6 0 0 0 3 4.6v3.8A1.6 1.6 0 0 0 4.6 10h3.8A1.6 1.6 0 0 0 10 8.4V4.6A1.6 1.6 0 0 0 8.4 3Z" fill="#3D84FC" fill-opacity=".16" stroke="#3D84FC" stroke-width="1.5" stroke-miterlimit="10"></path><path d="M19.4 3h-3.8A1.6 1.6 0 0 0 14 4.6v3.8a1.6 1.6 0 0 0 1.6 1.6h3.8A1.6 1.6 0 0 0 21 8.4V4.6A1.6 1.6 0 0 0 19.4 3ZM8.4 14H4.6A1.6 1.6 0 0 0 3 15.6v3.8A1.6 1.6 0 0 0 4.6 21h3.8a1.6 1.6 0 0 0 1.6-1.6v-3.8A1.6 1.6 0 0 0 8.4 14Z" fill="#ffffff" stroke="#3D84FC" stroke-width="1.5" stroke-miterlimit="10"></path><path d="M19.4 14h-3.8a1.6 1.6 0 0 0-1.6 1.6v3.8a1.6 1.6 0 0 0 1.6 1.6h3.8a1.6 1.6 0 0 0 1.6-1.6v-3.8a1.6 1.6 0 0 0-1.6-1.6Z" fill="#3D84FC" fill-opacity=".16" stroke="#3D84FC" stroke-width="1.5" stroke-miterlimit="10"></path></g></svg></i><?php _e( 'Studiare Panel', 'studiare' ); ?></a></li>
					<li><a href="#tabs-7"><i><svg width="20px" height="20px" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg" fill="currentcolor"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <rect x="0" fill="none" width="20" height="20"></rect> <g> <path d="M13.11 4.36L9.87 7.6 8 5.73l3.24-3.24c.35-.34 1.05-.2 1.56.32.52.51.66 1.21.31 1.55zm-8 1.77l.91-1.12 9.01 9.01-1.19.84c-.71.71-2.63 1.16-3.82 1.16H6.14L4.9 17.26c-.59.59-1.54.59-2.12 0-.59-.58-.59-1.53 0-2.12l1.24-1.24v-3.88c0-1.13.4-3.19 1.09-3.89zm7.26 3.97l3.24-3.24c.34-.35 1.04-.21 1.55.31.52.51.66 1.21.31 1.55l-3.24 3.25z"></path> </g> </g></svg></i><?php _e( 'Plugins', 'studiare' ); ?></a></li>
					<!-- <li><a href="#tabs-8"><i><svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M16.8 9H12.75V13.44L14.82 11.37C14.97 11.22 15.16 11.15 15.35 11.15C15.54 11.15 15.73 11.22 15.88 11.37C16.17 11.66 16.17 12.14 15.88 12.43L12.53 15.78C12.24 16.07 11.76 16.07 11.47 15.78L8.12 12.43C7.83 12.14 7.83 11.66 8.12 11.37C8.41 11.08 8.89 11.08 9.18 11.37L11.25 13.44V9H7.2C4 9 2 11 2 14.2V16.79C2 20 4 22 7.2 22H16.79C19.99 22 21.99 20 21.99 16.8V14.2C22 11 20 9 16.8 9Z" fill="currentcolor"></path> <path d="M12.75 2.75C12.75 2.34 12.41 2 12 2C11.59 2 11.25 2.34 11.25 2.75V9H12.75V2.75Z" fill="currentcolor"></path> </g></svg></i><?php // _e( 'Demo Importer', 'studiare' ); ?></a></li>--> 
					<li><a href="#tabs-2"><i>
							<svg xmlns="http://www.w3.org/2000/svg" height="20px" viewBox="0 -960 960 960" width="20px"><path d="m97-144 245-336h193l281-340v676H97Zm76-225-58-42 155-213h193l168-203 55 46-189 229H306L173-369Zm66 153h505v-404L569-408H378L239-216Zm505 0Z" fill-opacity="0.85" fill="currentcolor"></path></svg>
						</i><?php _e( 'System Status', 'studiare' ); ?></a></li>
					<li><a href="#tabs-3"><i>
							<svg xmlns="http://www.w3.org/2000/svg" height="20px" viewBox="0 -960 960 960" width="20px"><path d="M480-492Zm-.21 396Q450-96 429-117.15T408-168h144q0 30-21.21 51t-51 21ZM732-432v-111H624v-66h108v-111h72v111h108v66H804v111h-72ZM192-216v-72h48v-240q0-87 53.5-153T432-763v-53q0-20 14-34t34-14q20 0 34 14t14 34v53q23 5 44.5 13.5T614-728q-12.81 12.73-23.06 27.73-10.25 15-17.94 32.27-20-13-43.5-20.5T480-696q-70 0-119 49t-49 119v240h336v-108q17 11 34.5 18.5T720-365v77h48v72H192Z" fill="currentcolor"></path></svg>
						</i><?php _e( 'What’s New', 'studiare' ); ?></a></li>
					<li><a href="#tabs-4"><i><svg xmlns="http://www.w3.org/2000/svg" height="20px" viewBox="0 -960 960 960" width="20px"><path d="M480-240q20 0 34-14t14-34q0-20-14-34t-34-14q-20 0-34 14t-14 34q0 20 14 34t34 14Zm-36-153h73q0-37 6.5-52.5T555-485q35-34 48.5-58t13.5-53q0-55-37.5-89.5T484-720q-51 0-88.5 27T343-620l65 27q9-28 28.5-43.5T482-652q28 0 46 16t18 42q0 23-15.5 41T496-518q-35 32-43.5 52.5T444-393Zm36 297q-79 0-149-30t-122.5-82.5Q156-261 126-331T96-480q0-80 30-149.5t82.5-122Q261-804 331-834t149-30q80 0 149.5 30t122 82.5Q804-699 834-629.5T864-480q0 79-30 149t-82.5 122.5Q699-156 629.5-126T480-96Zm0-72q130 0 221-91t91-221q0-130-91-221t-221-91q-130 0-221 91t-91 221q0 130 91 221t221 91Zm0-312Z" fill-opacity="0.85" fill="currentcolor"></path></svg></i><?php _e( 'Help Center', 'studiare' ); ?></a></li>
					<li><a href="#tabs-5"><i><svg fill="currentcolor" width="20px" height="20px" viewBox="0 0 96 96" xmlns="http://www.w3.org/2000/svg" stroke="currentcolor" stroke-width="1.056"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <title></title> <g id="FAQ"> <path d="M74.05,45H47a6,6,0,0,0-6,6v14.1a6,6,0,0,0,6,6H71.22l7.93,7.85a.47.47,0,0,0,.35.15.43.43,0,0,0,.19,0A.5.5,0,0,0,80,78.5V51A6,6,0,0,0,74.05,45Zm5,32.3-7.22-7.15a.47.47,0,0,0-.35-.15H47a5,5,0,0,1-5-5V51a5,5,0,0,1,5-5h27.1a5,5,0,0,1,5,5Z"></path> <path d="M55,36.05V22a6,6,0,0,0-6-5.95H22A6,6,0,0,0,16,22V49.5a.5.5,0,0,0,.31.46.43.43,0,0,0,.19,0,.47.47,0,0,0,.35-.15L24.78,42H49.05A6,6,0,0,0,55,36.05ZM24.57,41a.47.47,0,0,0-.35.15L17,48.3V22A5,5,0,0,1,22,17h27.1A5,5,0,0,1,54,22v14.1a5,5,0,0,1-5,5Z"></path> <path d="M35.5,34.5a2,2,0,1,0,2,2A2,2,0,0,0,35.5,34.5Zm0,3a1,1,0,1,1,1-1A1,1,0,0,1,35.5,37.5Z"></path> <path d="M52,54.5A3.5,3.5,0,1,0,55.5,58,3.5,3.5,0,0,0,52,54.5Zm0,6A2.5,2.5,0,1,1,54.5,58,2.5,2.5,0,0,1,52,60.5Z"></path> <path d="M70,54.5A3.5,3.5,0,1,0,73.5,58,3.5,3.5,0,0,0,70,54.5Zm0,6A2.5,2.5,0,1,1,72.5,58,2.5,2.5,0,0,1,70,60.5Z"></path> <path d="M61,54.5A3.5,3.5,0,1,0,64.5,58,3.5,3.5,0,0,0,61,54.5Zm0,6A2.5,2.5,0,1,1,63.5,58,2.5,2.5,0,0,1,61,60.5Z"></path> <path d="M36.79,19.13a6,6,0,0,0-6.88,3.7,1.88,1.88,0,0,0,.21,1.79,2,2,0,0,0,3.54-.4,2,2,0,0,1,2.44-1.13,2,2,0,0,1,1.32,1.35,2,2,0,0,1-3.12,2.15.49.49,0,0,0-.52-.05.51.51,0,0,0-.28.45v5a2,2,0,0,0,4,0V30.65a6,6,0,0,0-.71-11.52Zm.07,10.68a.5.5,0,0,0-.36.48V32a1,1,0,0,1-2,0V27.82a3,3,0,0,0,3.89-3.64,3,3,0,0,0-5.65-.35,1.05,1.05,0,0,1-1,.67,1,1,0,0,1-.84-.45.91.91,0,0,1-.11-.86,5,5,0,0,1,5.74-3.08,5,5,0,0,1,.28,9.7Z"></path> </g> </g></svg></i><?php _e( 'FAQs', 'studiare' ); ?></a></li>
					<li><a href="#tabs-6"><i><svg fill="currentcolor" height="20px" width="20px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <g> <g> <path d="M255.997,159.418c36.473,0,66.145-29.673,66.145-66.145s-29.673-66.145-66.145-66.145 c-36.473,0-66.145,29.673-66.145,66.145S219.524,159.418,255.997,159.418z"></path> <path d="M149.327,318.736h213.341c8.818,0,15.967-7.149,15.967-15.967c0-67.623-55.015-122.637-122.637-122.637 S133.36,235.146,133.36,302.769C133.36,311.587,140.509,318.736,149.327,318.736z"></path> <path d="M320.438,380.025l-34.632-5.033l-15.488-31.381c-5.848-11.851-22.791-11.843-28.636,0l-15.488,31.381l-34.632,5.033 c-13.077,1.9-18.306,18.016-8.849,27.234l25.059,24.427l-5.916,34.492c-2.234,13.025,11.477,22.977,23.167,16.832l30.976-16.284 l30.976,16.284c11.595,6.096,25.418-3.71,23.167-16.832l-5.916-34.492l25.059-24.427 C338.749,398.034,333.507,381.924,320.438,380.025z"></path> <path d="M142.55,380.025l-34.632-5.033L92.43,343.611c-5.848-11.849-22.791-11.843-28.636,0l-15.487,31.381l-34.632,5.033 c-13.077,1.9-18.305,18.016-8.849,27.234l25.059,24.427l-5.916,34.492c-2.234,13.025,11.477,22.977,23.167,16.832l30.976-16.285 l30.976,16.285c11.595,6.096,25.418-3.71,23.167-16.832l-5.916-34.492l25.06-24.427 C160.862,398.034,155.619,381.924,142.55,380.025z"></path> <path d="M498.324,380.025l-34.632-5.033l-15.487-31.381c-4.797-9.721-15.384-8.901-14.318-8.901 c-6.077,0-11.628,3.451-14.318,8.901l-15.488,31.381l-34.632,5.033c-13.077,1.9-18.305,18.016-8.849,27.234l25.061,24.427 l-5.916,34.492c-2.234,13.025,11.476,22.977,23.167,16.832l30.976-16.285l30.976,16.285c11.595,6.096,25.418-3.71,23.167-16.832 l-5.916-34.492l25.06-24.427C516.635,398.036,511.395,381.924,498.324,380.025z"></path> </g> </g> </g> </g></svg></i><?php _e( 'Feedback', 'studiare' ); ?></a></li>
					<li><a class="docs" target="_blank" href="https://docs.studiaretheme.ir/"><i><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-question-circle" viewBox="0 0 16 16"><path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"/><path d="M5.255 5.786a.237.237 0 0 0 .241.247h.825c.138 0 .248-.113.266-.25.09-.656.54-1.134 1.342-1.134.686 0 1.314.343 1.314 1.168 0 .635-.374.927-.965 1.371-.673.489-1.206 1.06-1.168 1.987l.003.217a.25.25 0 0 0 .25.246h.811a.25.25 0 0 0 .25-.25v-.105c0-.718.273-.927 1.01-1.486.609-.463 1.244-.977 1.244-2.056 0-1.511-1.276-2.241-2.673-2.241-1.267 0-2.655.59-2.75 2.286zm1.557 5.763c0 .533.425.927 1.01.927.609 0 1.028-.394 1.028-.927 0-.552-.42-.94-1.029-.94-.584 0-1.009.388-1.009.94z"/></svg></i><?php _e( 'Docs', 'studiare' ); ?></a>
</li>
				</ul>
				
				<div class="sce-hub-container sce-page-container">

				<!-- Registration container -->
				<div class="tab-item" id="tabs-1">
					<?php include 'studiare-panel-welcome.php'; ?>
				</div>

				<!-- System status container -->
				<div class="tab-item" id="tabs-2" style="display: none;">
					<?php include 'system-status-section.php'; ?>
				</div>
				
				<!-- What’s new container -->
				<div class="tab-item" id="tabs-3" style="display: none;">
					<?php include 'whats-new-section.php'; ?>
				</div>

				<!-- Help container -->
				<div class="tab-item" id="tabs-4" style="display: none;">
					<?php include 'help-section.php'; ?>
				</div>

				<!-- Help container -->
				<div class="tab-item" id="tabs-5" style="display: none;">
					<?php include 'faq-section.php'; ?>
				</div>
				
				<!-- Help container -->
				<div class="tab-item" id="tabs-6" style="display: none;">
					<?php include 'feedback-section.php'; ?>
				</div>
				
				<!-- Plugins container -->
				<div class="tab-item" id="tabs-7" style="display: none;">
					<?php include 'plugins-section.php'; ?>
				</div>
				
				<!-- Demo Importer container -->
				<!-- <div class="tab-item" id="tabs-8" style="display: none;">  -->
				<!--	<?php //include 'demo-importer.php'; ?>  -->
				<!-- </div> -->
                
			</div>
        
        
        
            
            
            
        </div>
        <div class="studipnl_footer">
            <a class="sun_rtl_link" target="_blank" href="https://www.rtl-theme.com/author/bagherpebs/products/"><?php echo __('View Suncode Products','studiare'); ?></a>
            <small><?php echo __('All Rights Reserved By Suncode','studiare'); ?> <i class="fal fa-sun"></i></small>
        </div>    
        
    </div>
    <script>
        jQuery(document).ready(function(){
            jQuery(".studipnl_box").hover(function(){
                var des = jQuery(this).attr("data-spicon_desc");
                jQuery(".spicons_description").html(des);
            },function(){
                jQuery(".spicons_description").html("");
            });
        });
    </script>
    <?php
    //include 'system-status-section.php';
}
 