<?php
/**
 * Demo Importer for Studiare Theme
 *
 * This file generates the demo importer content to be included in an existing admin panel tab.
 * It displays demos in a responsive 3-column layout with a search box,
 * preview and import buttons on hover.
 *
 * @package Studiare
 */

/**
 * Define demo data
 * Each demo includes a name, image, preview URL, and import file URL.
 */
$demos = array(
    array(
        'name' => 'آکادمی زبان',
        'image' => 'https://studiaretheme.ir/wp-content/uploads/2024/11/language-academy.webp',
        'preview_url' => 'https://demo.studiaretheme.ir/language-academy/',
        'import_file' => 'https://studiaretheme.ir/api/importer/language-academy.xml',
    ),
    array(
        'name' => 'آکادمی 1',
        'image' => 'https://studiaretheme.ir/wp-content/uploads/2024/03/el-home-01.webp',
        'preview_url' => 'https://studiaretheme.ir/el-home-01/',
        'import_file' => 'https://studiaretheme.ir/api/importer/el-home-01.xml',
    ),
    array(
        'name' => 'آکادمی 2',
        'image' => 'https://studiaretheme.ir/wp-content/uploads/2024/03/el-home-02.webp',
        'preview_url' => 'https://studiaretheme.ir/el-home-02/',
        'import_file' => 'https://studiaretheme.ir/api/importer/el-home-02.xml',
    ),
    array(
        'name' => 'آکادمی 3',
        'image' => 'https://studiaretheme.ir/wp-content/uploads/2024/03/el-home-03.webp',
        'preview_url' => 'https://studiaretheme.ir/el-home-03/',
        'import_file' => 'https://studiaretheme.ir/api/importer/el-home-03.xml',
    ),
    array(
        'name' => 'آکادمی 4',
        'image' => 'https://studiaretheme.ir/wp-content/uploads/2024/03/el-home-04.webp',
        'preview_url' => 'https://studiaretheme.ir/el-home-04/',
        'import_file' => 'https://studiaretheme.ir/api/importer/el-home-04.xml',
    ),
);
?>
<style>
    .demo-importer-wrap { padding: 20px; }
    .demo-grid {
        display: flex;
        flex-wrap: wrap;
        gap: 20px;
        margin-top: 20px;
    }
    .demo-item {
        width: calc(33.333% - 20px);
        position: relative;
        background: #fff;
        border: 1px solid #ddd;
        max-height: 200px;
        overflow: hidden;
    }
    .demo-item img {
        width: 100%;
        height: auto;
        display: block;
    }
    .demo-actions {
        position: absolute;
        bottom: 10px;
        left: 10px;
        right: 10px;
        display: none;
        justify-content: space-between;
    }
    .demo-item:hover .demo-actions {
        display: flex;
    }
    #demo-search {
        margin-bottom: 20px;
        width: 100%;
        max-width: 400px;
    }
    #import-modal {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: rgba(0,0,0,0.5);
        display: flex;
        align-items: center;
        justify-content: center;
    }
    .modal-content {
        background: #fff;
        padding: 20px;
        border-radius: 5px;
        text-align: center;
        min-width: 300px;
    }
    .loader {
        border: 16px solid #f3f3f3;
        border-top: 16px solid #3498db;
        border-radius: 50%;
        width: 60px;
        height: 60px;
        animation: spin 2s linear infinite;
        margin: 20px auto;
    }
    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
    @media (max-width: 768px) {
        .demo-item { width: calc(50% - 20px); }
    }
    @media (max-width: 480px) {
        .demo-item { width: 100%; }
    }
</style>

<div class="demo-importer-wrap">
    <h2><?php _e('Demo Importer', 'studiare'); ?></h2>
    <!-- Search box -->
    <input type="text" id="demo-search" placeholder="<?php _e('Search demos...', 'studiare'); ?>" class="regular-text" />
    <!-- Demo grid -->
    <div class="demo-grid">
        <?php foreach ($demos as $demo) : ?>
            <div class="demo-item" data-name="<?php echo esc_attr(strtolower($demo['name'])); ?>">
                <img src="<?php echo esc_url($demo['image']); ?>" alt="<?php echo esc_attr($demo['name']); ?>">
                <div class="demo-actions">
                    <a href="<?php echo esc_url($demo['preview_url']); ?>" target="_blank" class="button"><?php _e('Preview', 'studiare'); ?></a>
                    <button class="button import-demo" data-import-file="<?php echo esc_url($demo['import_file']); ?>"><?php _e('Import', 'studiare'); ?></button>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>
<!-- Import modal with preloader -->
<div id="import-modal" style="display:none;">
    <div class="modal-content">
        <h2><?php _e('Importing Demo', 'studiare'); ?></h2>
        <p><?php _e('Please do not close or refresh the page until the process is complete.', 'studiare'); ?></p>
        <div class="loader"></div>
    </div>
</div>

<script>
    jQuery(document).ready(function($) {
        // Define AJAX variables directly
        var studiare_ajax = {
            ajaxurl: '<?php echo admin_url('admin-ajax.php'); ?>',
            nonce: '<?php echo wp_create_nonce('studiare_import_demo'); ?>'
        };

        // Search functionality
        $('#demo-search').on('keyup', function() {
            var searchTerm = $(this).val().toLowerCase();
            if (searchTerm.length >= 3) {
                $('.demo-item').each(function() {
                    var demoName = $(this).data('name');
                    if (demoName.indexOf(searchTerm) > -1) {
                        $(this).show();
                    } else {
                        $(this).hide();
                    }
                });
            } else {
                $('.demo-item').show();
            }
        });

        // Import demo
        $('.import-demo').on('click', function() {
            var importFile = $(this).data('import-file');
            $('#import-modal').show();

            $.ajax({
                url: studiare_ajax.ajaxurl,
                type: 'POST',
                data: {
                    action: 'studiare_import_demo',
                    nonce: studiare_ajax.nonce,
                    import_file: importFile
                },
                dataType: 'json',
                success: function(response) {
                    $('#import-modal').hide();
                    if (response.success) {
                        alert(response.data);
                    } else {
                        alert(response.data);
                    }
                },
                error: function(xhr, status, error) {
                    $('#import-modal').hide();
                    var errorMessage = '<?php echo esc_js(__('An error occurred during import', 'studiare')); ?>';
                    if (xhr.responseJSON && xhr.responseJSON.data) {
                        errorMessage = xhr.responseJSON.data;
                    }
                    console.log(errorMessage);
                    alert(errorMessage);
                }
            });
        });
    });
</script>