<?php
// Enqueue assets for Suncode Player by Studiaretheme
function enqueue_scplayer_assets() {
    // Skip if in admin or during AJAX requests
    if (is_admin() || wp_doing_ajax()) {
        return;
    }

    global $wp_scripts, $wp_styles;

    // Default settings
    $enable_suncode_player = false;
    $disable_mejs = false;
    $enable_hls_support = true;
    $video_player_controls = array(
        'play', 'progress', 'current-time', 'mute', 'volume', 'fullscreen', 'captions',
        'pip', 'airplay', 'download', 'settings', 'quality', 'play-large', 'duration',
        'fast-forward', 'restart', 'rewind', 'loop'
    );
    $audio_player_controls = array(
        'play', 'progress', 'current-time', 'mute', 'volume', 'download', 'settings',
        'play-large', 'duration', 'fast-forward', 'restart', 'rewind', 'loop'
    );
    $enable_tooltips = true;
    $watermark_mode = 'disabled';
    $enable_video_cover = false;
    $video_cover_image = get_template_directory_uri() . '/assets/images/video-cover.webp';

    // New default values for watermark speed and content type
    $watermark_min_speed = 30; // Default minimum speed
    $watermark_max_speed = 60; // Default maximum speed
    $watermark_content_type = 'display_name'; // Initialize the variable here
    $watermark_count = 1; // Default number of watermarks (e.g., 1 for moving, 0 for static)

    $watermark_text = esc_html__('Guest', 'studiare'); // Default text for guests

    // Override defaults with Redux settings if available
    if (class_exists('Redux') && function_exists('codebean_option')) {
        $enable_suncode_player = in_array(codebean_option('enable_suncode_player'), ['1', 1, true], true);
        $disable_mejs = in_array(codebean_option('disable_mejs'), ['1', 1, true], true) && $enable_suncode_player;
        $enable_hls_support = in_array(codebean_option('enable_hls_support'), ['1', 1, true], true);
        $video_controls_option = codebean_option('suncode_video_player_controls');
        $audio_controls_option = codebean_option('suncode_audio_player_controls');
        $enable_tooltips = in_array(codebean_option('suncode_player_tooltips'), ['1', 1, true], true);
        $watermark_mode = codebean_option('suncode_player_watermark') ?: 'disabled';
        $enable_video_cover = in_array(codebean_option('enable_video_cover'), ['1', 1, true], true);
        $video_cover_option = codebean_option('video_cover_image');

        // Get watermark speed options from Redux
        $watermark_min_speed_option = codebean_option('watermark_min_speed');
        $watermark_max_speed_option = codebean_option('watermark_max_speed');
        $watermark_count_option = codebean_option('watermark_count'); // Read the new option

        if (is_numeric($watermark_min_speed_option)) {
            $watermark_min_speed = (int) $watermark_min_speed_option;
        }
        if (is_numeric($watermark_max_speed_option)) {
            $watermark_max_speed = (int) $watermark_max_speed_option;
        }
        if (is_numeric($watermark_count_option) && $watermark_count_option >= 0) {
            $watermark_count = (int) $watermark_count_option;
        }

        // Get watermark content type from Redux
        $redux_watermark_content_type = codebean_option('watermark_content_type');
        if (!empty($redux_watermark_content_type)) {
            $watermark_content_type = $redux_watermark_content_type;
        }

        if (!empty($video_controls_option['enabled']) && is_array($video_controls_option['enabled'])) {
            $video_player_controls = array_keys($video_controls_option['enabled']);
        } else {
             // Fallback to a sensible default if the option is empty or invalid
             $video_player_controls = ['play', 'progress', 'current-time', 'mute', 'volume', 'fullscreen'];
        }

        if (!empty($audio_controls_option['enabled']) && is_array($audio_controls_option['enabled'])) {
            $audio_player_controls = array_keys($audio_controls_option['enabled']);
        } else {
            // Fallback to a sensible default if the option is empty or invalid
            $audio_player_controls = ['play', 'progress', 'current-time', 'mute', 'volume'];
        }

        if (!empty($video_cover_option['url'])) {
            $video_cover_image = esc_url($video_cover_option['url']);
        }
    }

    // Determine watermark text based on user status and selected type
    if (is_user_logged_in()) {
        $current_user = wp_get_current_user();
        if ($watermark_content_type === 'display_name') {
            $user_display_name = $current_user->ID ? esc_html($current_user->first_name . ' ' . $current_user->last_name) : '';
            if (empty(trim($user_display_name))) {
                $user_display_name = $current_user->ID ? esc_html($current_user->display_name) : '';
            }
            if (empty(trim($user_display_name))) { // Fallback if display_name is also empty
                $user_display_name = $current_user->ID ? esc_html($current_user->user_login) : '';
            }
            $watermark_text = !empty(trim($user_display_name)) ? $user_display_name : esc_html__('Logged-in User', 'studiare');

        } elseif ($watermark_content_type === 'mobile_number') {
            global $wpdb;
            $user_id = $current_user->ID;
            $mobile_number = '';

            // 1. Try to get from sc_otp_tbl
            $sc_otp_mobile = $wpdb->get_var( $wpdb->prepare(
                "SELECT mobile_number FROM {$wpdb->prefix}sc_otp_tbl WHERE user_id = %d LIMIT 1",
                $user_id
            ) );
            if ( ! empty( $sc_otp_mobile ) ) {
                $mobile_number = $sc_otp_mobile;
            }

            // 2. If empty, try to get from Digits plugin user meta
            if ( empty( $mobile_number ) && function_exists( 'is_plugin_active' ) && is_plugin_active( 'digits/digits.php' ) ) {
                $digits_mobile = get_user_meta( $user_id, 'digits_phone', true );
                if ( ! empty( $digits_mobile ) ) {
                    $mobile_number = $digits_mobile;
                }
            }

            // 3. If empty, try to get from WooCommerce billing phone
            if ( empty( $mobile_number ) && class_exists( 'WooCommerce' ) ) {
                $woocommerce_mobile = get_user_meta( $user_id, 'billing_phone', true );
                if ( ! empty( $woocommerce_mobile ) ) {
                    $mobile_number = $woocommerce_mobile;
                }
            }

            $watermark_text = !empty($mobile_number) ? esc_html($mobile_number) : esc_html($current_user->first_name . ' ' . $current_user->last_name);

        } else {
            // Fallback for 'none' or unhandled types for logged-in users (e.g., default display name)
            $user_display_name = $current_user->ID ? esc_html($current_user->first_name . ' ' . $current_user->last_name) : '';
            if (empty(trim($user_display_name))) {
                $user_display_name = $current_user->ID ? esc_html($current_user->display_name) : '';
            }
            if (empty(trim($user_display_name))) {
                $user_display_name = $current_user->ID ? esc_html($current_user->user_login) : '';
            }
            $watermark_text = !empty(trim($user_display_name)) ? $user_display_name : esc_html__('Logged-in User', 'studiare');
        }
    } else {
        // Text for guest users
        $watermark_text = esc_html__('Guest', 'studiare');
    }
    // Disable MediaElement.js early
    if ($disable_mejs) {
        $mejs_handles = [
            'mediaelement',
            'wp-mediaelement',
            'mediaelement-vimeo',
            'mediaelement-core',
            'mediaelement-migrate',
            'mediaelement-vimeo-renderer',
            'mediaelement-youtube-renderer'
        ];
        foreach ($mejs_handles as $handle) {
            wp_dequeue_script($handle);
            wp_deregister_script($handle);
            wp_dequeue_style($handle);
            wp_deregister_style($handle);
        }
    }

    // Enqueue Suncode Player assets only if enabled
    if ($enable_suncode_player) {
        // Enqueue scplayer CSS
        wp_enqueue_style(
            'scplayer-css',
            get_template_directory_uri() . '/assets/css/suncode-player.css',
            [],
            '1.0.0'
        );

        // Add inline CSS for watermark
        $watermark_class = 'scwm_' . wp_generate_uuid4();
        wp_add_inline_style('scplayer-css', '
            .' . esc_attr($watermark_class) . ' {
                position: absolute;
                color: rgba(255, 255, 255, 0.7);
                font-size: 25px;
                font-weight: bold;
                text-shadow: 1px 1px 2px rgba(0, 0, 0, 0.5);
                pointer-events: none;
                z-index: 10;
                user-select: none;
                transition: transform 0.05s ease-in-out;
                white-space: nowrap;
            }
        
            @media (max-width: 767.98px) {
                .' . esc_attr($watermark_class) . ' {
                    font-size: 4vw;
                }
            }
        ');

        // Enqueue scplayer JS
        wp_enqueue_script(
            'scplayer-js',
            get_template_directory_uri() . '/assets/js/suncode-player.js',
            [],
            '1.0.0',
            true
        );

        // Enqueue hls.js if HLS support is enabled
        if ($enable_hls_support) {
            wp_enqueue_script(
                'hls-js',
                get_template_directory_uri() . '/assets/js/hls.min.js',
                [],
                '1.5.7',
                true
            );
        }

        // Localize script only if scplayer is enabled
        wp_localize_script('scplayer-js', 'scplayerConfig', array(
            'enableSuncodePlayer' => $enable_suncode_player,
            'videoControls'       => $video_player_controls,
            'audioControls'       => $audio_player_controls,
            'tooltips'            => $enable_tooltips,
            'watermarkClass'      => $watermark_class,
            'watermarkMode'       => $watermark_mode,
            'enableVideoCover'    => $enable_video_cover,
            'videoCoverImage'     => $video_cover_image,
            'enableHlsSupport'    => $enable_hls_support,
            'watermarkMinSpeed'   => $watermark_min_speed,
            'watermarkMaxSpeed'   => $watermark_max_speed,
            'watermarkText'       => $watermark_text,
            'watermarkCount'      => $watermark_count, // Pass the watermark count to JavaScript
            'i18n'                => array(
                'speed'             => esc_js(__('Speed', 'studiare')),
                'normal'            => esc_js(__('Normal', 'studiare')),
                'play'              => esc_js(__('Play', 'studiare')),
                'pause'             => esc_js(__('Pause', 'studiare')),
                'mute'              => esc_js(__('Mute', 'studiare')),
                'unmute'            => esc_js(__('Unmute', 'studiare')),
                'fullscreen'        => esc_js(__('Fullscreen', 'studiare')),
                'exitFullscreen'    => esc_js(__('Exit Fullscreen', 'studiare')),
                'pip'               => esc_js(__('Picture in Picture', 'studiare')),
                'settings'          => esc_js(__('Settings', 'studiare')),
                'restart'           => esc_js(__('Restart', 'studiare')),
                'rewind'            => esc_js(__('Rewind {seektime}s', 'studiare')),
                'fastForward'       => esc_js(__('Forward {seektime}s', 'studiare')),
                'seek'              => esc_js(__('Seek', 'studiare')),
                'seekLabel'         => esc_js(__('{currentTime} of {duration}', 'studiare')),
                'played'            => esc_js(__('Played', 'studiare')),
                'buffered'          => esc_js(__('Buffered', 'studiare')),
                'currentTime'       => esc_js(__('Current time', 'studiare')),
                'duration'          => esc_js(__('Duration', 'studiare')),
                'volume'            => esc_js(__('Volume', 'studiare')),
                'enableCaptions'    => esc_js(__('Enable captions', 'studiare')),
                'disableCaptions'   => esc_js(__('Disable captions', 'studiare')),
                'download'          => esc_js(__('Download', 'studiare')),
                'enterFullscreen'   => esc_js(__('Enter Fullscreen', 'studiare')),
                'frameTitle'        => esc_js(__('Player for {title}', 'studiare')),
                'captions'          => esc_js(__('Captions', 'studiare')),
                'menuBack'          => esc_js(__('Go back to previous menu', 'studiare')),
                'quality'           => esc_js(__('Quality', 'studiare')),
                'loop'              => esc_js(__('Loop', 'studiare')),
                'start'             => esc_js(__('Start', 'studiare')),
                'end'               => esc_js(__('End', 'studiare')),
                'all'               => esc_js(__('All', 'studiare')),
                'reset'             => esc_js(__('Reset', 'studiare')),
                'disabled'          => esc_js(__('Disabled', 'studiare')),
                'enabled'           => esc_js(__('Enabled', 'studiare')),
                'advertisement'     => esc_js(__('Ad', 'studiare')),
            ),
            'iconUrl'             => get_template_directory_uri() . '/assets/images/scplayer.svg',
        ));
    }
}

// Additional hook to ensure MediaElement.js is disabled
function disable_mejs_late() {
    $disable_mejs = true;
    if (class_exists('Redux') && function_exists('codebean_option')) {
        $disable_mejs = in_array(codebean_option('disable_mejs'), ['1', 1, true], true) ? true : false;
    }

    if ($disable_mejs) {
        $mejs_handles = [
            'mediaelement',
            'wp-mediaelement',
            'mediaelement-vimeo',
            'mediaelement-core',
            'mediaelement-migrate',
            'mediaelement-vimeo-renderer',
            'mediaelement-youtube-renderer'
        ];
        foreach ($mejs_handles as $handle) {
            wp_dequeue_script($handle);
            wp_deregister_script($handle);
            wp_dequeue_style($handle);
            wp_deregister_style($handle);
        }
    }
}
add_action('wp_enqueue_scripts', 'enqueue_scplayer_assets', 20); // Lower priority to run earlier
add_action('wp_enqueue_scripts', 'disable_mejs_late', 1000); // Run late to catch late enqueues