document.addEventListener("DOMContentLoaded", function () {
    const body = document.body;
    const settings = window.darkModeSettings || { alwaysDark: true, defaultType: 'dark' };
    let isDarkMode = localStorage.getItem("darkMode");
    const prefersDark = window.matchMedia("(prefers-color-scheme: dark)");

    // Function to update the dark mode icon based on the current mode
    function updateDarkModeIcon(isDark) {
        const lightIcons = document.querySelectorAll('.dark-mode-icon-light');
        const darkIcons = document.querySelectorAll('.dark-mode-icon-dark');
        lightIcons.forEach(icon => {
            icon.style.display = isDark ? 'none' : 'block';
        });
        darkIcons.forEach(icon => {
            icon.style.display = isDark ? 'block' : 'none';
        });
    }

    // Function to set dark mode and update the UI
    function setDarkMode(enable) {
        if (enable) {
            body.classList.add("scdarkcolors");
            localStorage.setItem("darkMode", "enabled");
        } else {
            body.classList.remove("scdarkcolors");
            localStorage.setItem("darkMode", "disabled");
        }
        updateDarkModeIcon(enable);
    }

    // Function to apply the initial dark mode setting
    function applyInitialMode() {
        if (settings.alwaysDark === "1" || settings.alwaysDark === true) {
            setDarkMode(true);
        } else {
            if (isDarkMode === null) {
                if (settings.defaultType === 'dark') {
                    setDarkMode(true);
                } else if (settings.defaultType === 'light') {
                    setDarkMode(false);
                } else if (settings.defaultType === 'system') {
                    setDarkMode(prefersDark.matches);
                }
            } else {
                setDarkMode(isDarkMode === "enabled");
            }
        }
    }

    // Apply initial mode on page load
    applyInitialMode();

    // Add click event to all dark mode toggle buttons
    document.querySelectorAll('.dark-mode-toggle').forEach(toggle => {
        toggle.addEventListener('click', function(e) {
            e.preventDefault();
            const isDark = !body.classList.contains('scdarkcolors');
            setDarkMode(isDark);
        });
    });

    // Listen for system color scheme changes if defaultType is 'system'
    if ((settings.alwaysDark === "0" || settings.alwaysDark === false) && settings.defaultType === 'system') {
        prefersDark.addEventListener("change", (e) => {
            if (localStorage.getItem("darkMode") === null) {
                setDarkMode(e.matches);
            }
        });
    }
});