<?php
/**
 * Main File for Teacher Archive
 */

get_header();

// Check if Redux exists and a prospects archive page is selected
if ( class_exists( 'Redux' ) && ! empty( codebean_option( 'teachers_archive_page' ) ) ) {
    $page_id = codebean_option( 'teachers_archive_page' );
    $page = get_post( $page_id );

    if ( $page ) {
        // Check if the page is built with Elementor
        if ( defined( 'ELEMENTOR_VERSION' ) && \Elementor\Plugin::$instance->db->is_built_with_elementor( $page_id ) ) {
            // Render the full Elementor page content with styles and scripts
            echo \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $page_id );
        } else {
            // For non-Elementor pages, display the content with standard WordPress filters
            echo apply_filters( 'the_content', $page->post_content );
        }
    } else {
        // Fallback to default listing if the selected page doesn't exist
        get_template_part( 'inc/templates/teacher-listing' );
    }
} else {
    // Default behavior: load the teacher listing template
    get_template_part( 'inc/templates/teacher-listing' );
}

get_footer();