<?php
/*
Plugin Name: Studiare Core
Plugin URI: http://www.suncode.ir
Description: افزونه مکمل قالب استادیار برای وردپرس | ارائه شده توسط سان کد.
Version: 13.2
Author: suncode
Author URI: https://www.rtl-theme.com/author/bagherpebs/
*/

// If this file is called directly, abort.
if ( !defined( 'WPINC' ) ) {
	die;
}


/**
 * adding required plugin in libs folder
 * since version 12.4
 * 
 * */
if (!function_exists('is_plugin_active')) {
    include_once(ABSPATH . 'wp-admin/includes/plugin.php');
} 
if( !is_plugin_active( 'wp-events-manager-woo-payment/wp-events-manager-woo-payment.php' ) ) {
    
    if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
        
        if ( in_array( 'wp-events-manager/wp-events-manager.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
            include_once 'libs/wp-events-manager-woo-payment/wp-events-manager-woo-payment.php';
        }
    }
}
if( !is_plugin_active( 'cmb2/init.php' ) ) {
    include_once 'libs/cmb2/init.php';
    include_once 'libs/cmb2select2/cmb-field-select2.php';//since version 12.8
}
if( !is_plugin_active( 'cmb2-tabs-master/cmb2-tabs.php' ) ) {
    include_once 'libs/cmb2-tabs-master/cmb2-tabs.php';
}
//if( !is_plugin_active( 'portfolio-post-type/portfolio-post-type.php' ) ) {
 //   include_once 'libs/portfolio-post-type/portfolio-post-type.php';
//}
if( !is_plugin_active( 'portfolio-post-type/portfolio-post-type.php' ) ) {
        
        $sc_portfolio=true;
        if ( class_exists('Redux')) {
            $sc_portfolio = get_option("codebean_option");
            //since version 12.9
            if (is_array($sc_portfolio) && array_key_exists('portfolio_status', $sc_portfolio)) {
                $sc_portfolio = $sc_portfolio['portfolio_status'];
            }
        } 
        
        if($sc_portfolio){
            include_once 'libs/portfolio-post-type/portfolio-post-type.php';
        }
}

if( !is_plugin_active( 'breadcrumb-navxt/breadcrumb-navxt.php' ) ) {
    include_once 'libs/breadcrumb-navxt/breadcrumb-navxt.php';
}

if( !is_plugin_active( 'studiare-quiz/studiare-quiz.php' ) ) {
    include_once 'libs/studiare-quiz/studiare-quiz.php';
}

if( !is_plugin_active( 'sunticket/sunticket_helper.php' ) ) {
        
        $swss_tickets=false;
        if ( class_exists('Redux')) {
            $swss_tickets = get_option("codebean_option");
            if($swss_tickets){
            $swss_tickets = $swss_tickets['tickets_status'];
            }
        } 
        
        if($swss_tickets){
            include_once 'libs/sunticket/sunticket_helper.php';
        }
}

//since version 13.1
if( !is_plugin_active( 'sc-story/sc-story.php' ) ) {
        
        $sc_story=false;
        if ( class_exists('Redux')) {
            $sc_story = get_option("codebean_option");
            $sc_story = $sc_story['story_status'];
        } 
        
        if($sc_story){
            include_once 'libs/sc-story/sc-story.php';
        }
}


//since version 13.2
if( !is_plugin_active( 'studiare-chat/plugin.php' ) ) {
        
        $chat_status=false;
        if ( class_exists('Redux')) {
            $chat_status = get_option("codebean_option");
            $chat_status = $chat_status['chat_status'];
        } 
        
        if($chat_status){
            include_once 'libs/studiare-chat/plugin.php';
        }
}


if( !is_plugin_active( 'suncode_otp_reg_login/suncode_otp_reg_login.php' ) ) {
        
        $otp=false;
        if ( class_exists('Redux')) {
            $otp = get_option("codebean_option");
            $otp = $otp['otp'];
        } 
        
        if($otp){
            include_once 'libs/suncode_otp_reg_login/suncode_otp_reg_login.php';
        }
}
if ( ! class_exists( 'Studiare_Core') ) {

	class Studiare_Core {

		/**
		 * PHP5 constructor method.
		 *
		 * @since  1.0
		 * @access public
		 */
		public function __construct() {

			/* Set the constants needed by the plugin. */
			add_action( 'plugins_loaded', array( $this, 'constants' ), 1 );

			/* Internationalize the text strings used. */
			add_action( 'plugins_loaded', array( $this, 'i18n' ), 99 );

			/* Load the functions files. */
			add_action( 'plugins_loaded', array( $this, 'includes' ), 3 );

		}

		/**
		 * Defines constants used by the plugin.
		 *
		 * @since  1.0
		 * @access public
		 */
		public function constants() {

			/* Set constant path to the plugin directory. */
			define( 'STUDIARE_CORE_DIR', trailingslashit( plugin_dir_path( __FILE__ ) ) );

			/* Set the constant path to the plugin directory URI. */
			define( 'STUDIARE_CORE_URI', trailingslashit( plugin_dir_url( __FILE__ ) ) );

			/* Set the constant path to the includes directory. */
			define( 'STUDIARE_CORE_INCLUDES', STUDIARE_CORE_DIR . trailingslashit( 'includes' ) );

		}

		/**
		 * Loads the initial files needed by the plugin.
		 *
		 * @since  1.0
		 * @access public
		 */
		public function includes() {

			/* Load the teacher custom post type. */
			require_once STUDIARE_CORE_INCLUDES . 'post-types/teacher/class-studiare-teacher.php';
			
			/* start course download files added by suncode */
			require_once STUDIARE_CORE_INCLUDES . 'post-types/cdownload/class-studiare-cdownload.php';
			/* end course download files added by suncode */
			
			/* start footer added by suncode */
			require_once STUDIARE_CORE_INCLUDES . 'post-types/footer/class-studiare-footer.php';
			/* end footer added by suncode */
			/* start header added by suncode */
			require_once STUDIARE_CORE_INCLUDES . 'post-types/header/class-studiare-header.php';
			/* end header added by suncode */
			
			/* start megamenu added by suncode */
			require_once STUDIARE_CORE_INCLUDES . 'post-types/megamenu/class-studiare-megamenu.php';
			/* end megamenu added by suncode */
			
			//since version 12.8
			/* start lessons added by suncode */
			require_once STUDIARE_CORE_INCLUDES . 'post-types/studi_lesson/class-studiare-studi-lesson.php';
			/* end lessons added by suncode */
			
			/* start notification added by suncode */
			require_once STUDIARE_CORE_INCLUDES . 'post-types/notification/class-studiare-notification.php';
			/* end notification added by suncode */
			require_once STUDIARE_CORE_INCLUDES . 'sc_localization.php';

		}

		/**
		 * Loads the translation files.
		 *
		 * @since  1.0
		 * @access public
		 */
		public function i18n() {

			/* Load the translation of the plugin. */
			load_plugin_textdomain( 'studiare-core', false, basename( dirname( __FILE__ ) ) . '/languages/' );
		}

	}

	new Studiare_Core();
}
