jQuery(document).ready(function()
{
	jQuery("#swss_predefiled_answer_loader").selectWoo(
			{
			   width: "100%",
			 ajax: {
				url: ajaxurl,
				dataType: 'json',
				delay: 250,
				tags: "true",
				multiple: true,
				data: function (params) {
				  return {
					search_string: params.term, // search term
					page: params.page || 1,
					action: 'swss_get_predefined_answers_list'
				  };
				},
				processResults: function (data, params) 
				{
				  //console.log(params);
				 jQuery("#swss_predefiled_answer_loader")
				   return {
					results: jQuery.map(data.results, function(obj) 
					{
						//console.log(obj);
						return { id: obj.id, text: obj.id+" - "+obj.title };
					}),
					pagination: {
								  'more': typeof data.pagination === 'undefined' ? false : data.pagination.more
								}
					};
				},
				cache: true
			  },
			  escapeMarkup: function (markup) { return markup; }, // let our custom formatter work
			  minimumInputLength: 0,
			  templateResult: swss_formatRepo,  //product-fields-configurator-misc.js
			  templateSelection:  swss_formatRepoSelection  //product-fields-configurator-misc.js
			});
	jQuery("#swss_predefiled_answer_loader").on("select2:select", swss_on_answer_selected);
});
function swss_on_answer_selected(event)
{
	//console.log(event.currentTarget.value);
	jQuery("#swss_predefiled_answer_loader").prop("disabled", true);
	jQuery("#swss_predefiled_answer_loader_status").fadeIn();
	
	var formData = new FormData();
	formData.append('action', 'swss_get_answer');
	formData.append('id', event.currentTarget.value);
	
	jQuery.ajax({
		url: ajaxurl,
		type: 'POST',
		data: formData,
		async: true,
		success: function (data) 
		{
			//UI
			jQuery("#swss_predefiled_answer_loader").prop("disabled", false);
			jQuery("#swss_predefiled_answer_loader_status").fadeOut();
			
			//console.log(tinymce.editors.reply_message);
			try {
				const content = data.replace(/(?:\r\n|\r|\n)/g, '<br>');
				tinymce.editors.reply_message.setContent(content);
			}
			catch(err) {}
			jQuery('#reply_message').val(data);
			
		},
		error: function (data) 
		{
			//console.log(data);
			//alert("Error: "+data);
		},
		cache: false,
		contentType: false,
		processData: false
	});
}
function swss_formatRepo (repo) 
{
	if (repo.loading) return repo.text;
	
	var markup = '<div class="clearfix">' +
			'<div class="col-sm-12">' + repo.text + '</div>';
    markup += '</div>'; 
	
    return markup;
}

function swss_formatRepoSelection (repo) 
{
  return repo.full_name || repo.text;
}