jQuery(document).ready(function()
{
	jQuery(document).on('click', '#swss_add_new_custom_status_button', swss_add_new_custom_status);
	jQuery(document).on('click', '.swss_delete_custom_status', swss_remove_custom_status);
});
function swss_remove_custom_status(event)
{
	event.preventDefault();
	event.stopImmediatePropagation();
	
	var id_to_remove = jQuery(event.currentTarget).data('id-to-delete');
	if(confirm(swss.remove_custom_status_text))
		jQuery("#"+id_to_remove).fadeOut('slow', function(){jQuery(this).remove()});
	
	return false;
}
function swss_add_new_custom_status(event)
{	
	event.preventDefault();
	event.stopImmediatePropagation();
	
	var random = Math.floor((Math.random() * 1000000) + 999);
	var formData = new FormData();
	formData.append('action', 'swss_load_new_custom_status_configuration_box'); 
	
	//UI
	swss_on_load_new_custom_status_configuration_box();
	
	jQuery.ajax({
		url: ajaxurl+"?nocache="+random,
		type: 'POST',
		data: formData,
		async: true,
		success: function (data) 
		{
			//UI
			jQuery('#swss_custom_statuses_container').append(data);
			swss_finished_loading_new_custom_status_configuration_box()
		},
		error: function (data) 
		{
			//console.log(data);
			//alert("Error: "+data);
		},
		cache: false,
		contentType: false,
		processData: false
	}); 
	
	return false;
}

function swss_on_load_new_custom_status_configuration_box()
{
	jQuery('#swss_add_new_custom_status_button, #swss_submit_button').fadeOut();
	jQuery('#swss_preloader_image').animate({ opacity: 1 });
}
function swss_finished_loading_new_custom_status_configuration_box()
{
	jQuery('#swss_add_new_custom_status_button, #swss_submit_button').fadeIn();
	jQuery('#swss_preloader_image').animate({ opacity: 0 });
	global_jsc.init();
}