<?php 
class SWSS_MyAccountPage
{
	public function __construct()
	{
		
		try{
			$wc_version = swss_get_woo_version_number();
		}catch(Exception $e){}
		
		if(!isset($wc_version) || version_compare($wc_version , 2.6, '<') )
			add_action( 'woocommerce_after_my_account', array( &$this, 'add_order_table_extra_buttons'));
		if(isset($wc_version) && version_compare($wc_version , 2.6, '>=') )
			add_action( 'woocommerce_account_content', array( &$this,'add_order_table_extra_buttons'),99 );
		
		add_filter('woocommerce_account_menu_items', array(&$this,'add_user_ticket_area_to_menu'));
		add_action( 'init', array(&$this,'add_custom_endpoints') );
		add_filter( 'query_vars', array(&$this,'add_end_point_to_query_vars'), 0 );
		
		//add_action( 'woocommerce_account_swss-user-tickets-area_endpoint', array(&$this,'render_user_ticket_area') ); //Old endpoint handler
		add_filter( 'the_title',  array(&$this,'render_user_ticket_area_title') );
		
		//Order table
		add_filter( 'woocommerce_account_orders_columns',  array(&$this,'add_ticket_number_column') );
		add_action('woocommerce_my_account_my_orders_column_swss-ticket-number', array(&$this,'add_ticket_number_column_content') );
		add_action('woocommerce_my_account_my_orders_column_swss-new-admin-messages-number', array(&$this,'add_new_admin_messages_number_column_content') );
		
		// Add this line to register your enqueue function
        add_action('wp_enqueue_scripts', array(&$this, 'enqueue_assets'));//since version 13.2
	}
	
	//since version 13.2
	// Add this new method to your class
public function enqueue_assets()
{
    global $swss_option_helper;
    global $swss_text_helper;
    
    // Only load on account pages
    if (!is_account_page()) return;
    
    // Styles
    wp_enqueue_style('swss-my-account', SWSS_PLUGIN_PATH.'/css/frontend-my-account.css');
    
    // Scripts - only if needed (you might want to add conditions)
    wp_register_script('swss-my-account-orders-table', SWSS_PLUGIN_PATH.'/js/frontend-my-account-orders-table.js', array('jquery'));
    
    // Localize script if needed
    if (wp_script_is('swss-my-account-orders-table', 'registered')) {
        $texts = $swss_text_helper->get_texts();
        $translation_array = array(
            'get_help_text' => $texts['get_help_button_text'],
            'view_order_url' => wc_get_endpoint_url('view-order', "swss_order_id_place_holder", wc_get_page_permalink('myaccount')),
            'wc_ver' => WC_VERSION
        );
        wp_localize_script('swss-my-account-orders-table', 'swss', $translation_array);
        wp_enqueue_script('swss-my-account-orders-table');
    }
}

	function add_ticket_number_column($columns)
	{
		global $swss_option_helper;
		$new_columns = array();
		foreach($columns as $key => $column)
		{
			$new_columns[$key] = $column;
			if($key == 'order-total')
			{
				if($swss_option_helper->get_all_options('display_ticket_number_column_on_my_accont_order_table') && $swss_option_helper->get_all_options('is_order_ticket_enabled'))
				{
					$new_columns['swss-ticket-number'] = __('Tickets', 'sunticket');
					$new_columns['swss-new-admin-messages-number'] = __('New messages', 'sunticket');
				}
			}
		}
		return $new_columns;
	}
	function add_ticket_number_column_content($order)
	{
		global $swss_ticket_model;
		echo $swss_ticket_model->get_order_ticket_number(SWSS_Order::get_id($order));
	}
	function add_new_admin_messages_number_column_content($order)
	{
		global $swss_ticket_model;
		$new_messages_counter = $swss_ticket_model->count_total_new_admin_messages_per_type(SWSS_Order::get_id($order), 'order');
		echo $new_messages_counter;
	}
	function add_order_table_extra_buttons()
	{
		global $wp, $swss_option_helper, $swss_text_helper;
		$can_render = false;
		if ( did_action( 'woocommerce_account_content' ) ) 
		{
			foreach ( $wp->query_vars as $key => $value ) 
			{
				if($key == get_option('woocommerce_myaccount_orders_endpoint')/* 'orders' */)
					$can_render = true;
			}
		}
		else
			$can_render = true;
		
		$can_render = $swss_option_helper->get_all_options('is_order_ticket_enabled', true) ? $can_render : false;
		$can_render = !$swss_option_helper->get_all_options('disable_get_help_button', false) ? $can_render : false;
		
		if(!$can_render)
			return false;
		
		if(!get_current_user_id()) //???
			return;
		
		
		/**
        $texts = $swss_text_helper->get_texts();
        wp_enqueue_style('swss-my-account', SWSS_PLUGIN_PATH.'/css/frontend-my-account.css');
		wp_register_script('swss-my-account-orders-table', SWSS_PLUGIN_PATH.'/js/frontend-my-account-orders-table.js', array('jquery'));
		//include SWSS_PLUGIN_ABS_PATH.'/templates/my_account_orders_table.php';
		
		$translation_array = array(
			'get_help_text' => $texts['get_help_button_text'],
			'view_order_url' => wc_get_endpoint_url( 'view-order', "swss_order_id_place_holder", wc_get_page_permalink( 'myaccount' ) ),
			'wc_ver' => WC_VERSION
		);
		wp_localize_script( 'swss-my-account-orders-table', 'swss', $translation_array );
		wp_enqueue_script( 'swss-my-account-orders-table' );
		**/
	}
		
	public function add_custom_endpoints() 
	{
		global $swss_option_helper;
		$user_ticket_area_endpoint =  $swss_option_helper->get_user_ticket_area_endpoint();
		add_rewrite_endpoint( $user_ticket_area_endpoint, EP_ROOT | EP_PAGES );
		//flush_rewrite_rules();
		
		//handler 
		add_action( 'woocommerce_account_'.$user_ticket_area_endpoint."_endpoint", array(&$this,'render_user_ticket_area') );
	}
	public function add_end_point_to_query_vars( $vars ) 
	{
		global $swss_option_helper;
		$user_ticket_area_endpoint =  $swss_option_helper->get_user_ticket_area_endpoint();
		$vars[] = $user_ticket_area_endpoint;

		return $vars;
	}
	function render_user_ticket_area_title( $title ) 
	{
		global $wp_query,$swss_text_helper, $swss_option_helper;
		
		$user_ticket_area_endpoint =  $swss_option_helper->get_user_ticket_area_endpoint();
		$is_endpoint = isset( $wp_query->query_vars[$user_ticket_area_endpoint ] );
		
		if ( $is_endpoint && ! is_admin() && is_main_query() && in_the_loop() && is_account_page() ) 
		{
			// New page title.
			$texts = $swss_text_helper->get_texts();
			$title = $texts['my_account_page_user_ticket_area_tab_label'];
			remove_filter( 'the_title',  array(&$this,'render_user_ticket_area_title') );
		}

		return $title;
	}
	public function add_user_ticket_area_to_menu($items)
	{
		global $swss_option_helper, $swss_text_helper, $swss_ticket_model;
			if($swss_option_helper->get_all_options('display_user_ticket_area_in_my_account_page') != 'yes')
				return $items;
		
		//wp_enqueue_style('swss-my-account', SWSS_PLUGIN_PATH.'/css/frontend-my-account.css');		
		//$new_items = array();
		$user_ticket_area_endpoint =  $swss_option_helper->get_user_ticket_area_endpoint();
		$logout = $items['customer-logout'];
		unset( $items['customer-logout'] );
		$texts = $swss_text_helper->get_texts();
		$items[$user_ticket_area_endpoint] = $texts['my_account_page_user_ticket_area_tab_label'];
		$new_messages_counter = $swss_ticket_model->count_total_new_admin_messages_per_type();
		
		if($new_messages_counter > 0 && $texts['personal_ticket_area_tab_new_messages_counter_label'] != "")
			$items[$user_ticket_area_endpoint] .=  " ".sprintf($texts['personal_ticket_area_tab_new_messages_counter_label'], $new_messages_counter);
		$items['customer-logout'] = $logout;
		return $items;
	}
	public function render_user_ticket_area()
	{
		global $swss_html_helper, $swss_option_helper, $swss_text_helper, $swss_ticket_model;
		$texts = $swss_text_helper->get_texts();
		
		//swss_var_dump($swss_ticket_model->get_available_statuses());
			
		if( $swss_option_helper->get_all_options('display_user_ticket_area_in_my_account_page')== 'yes')
		{
			if($texts['my_account_tab_page_description'] != ""){
				$swss_action = isset( $_GET["swss_action"] ) ? $_GET["swss_action"] : "";//suncode
				if($swss_action==""){
				echo '<div class="swss_ticket_area_description">'.$texts['my_account_tab_page_description'].'</div>';
				}
			}
			$swss_html_helper->frontend_ticket_area(null,false,false);
		}
	}
}
?>