<?php 
class SWSS_TicketTablePage
{
	var $admin_notice = "";
	public function __construct()
	{
		add_action( 'admin_notices', array($this,'print_admin_result_notice') );
		
		//--------- Columns -------------
		//head
		add_filter( 'manage_edit-swss_ticket_columns', array( &$this, 'add_custom_columns_heads'),15 );
		//content
		add_action( 'manage_swss_ticket_posts_custom_column', array( &$this, 'add_custom_content_columns'), 10, 2 );
		//add_action( 'manage_posts_custom_column', array( &$this, 'add_custom_content_for_taxonomies_columns'), 10, 2 );
		//sortable function
		add_filter( 'manage_edit-swss_ticket_sortable_columns', array( &$this,'sort_columns') );
		//add_action('manage_swss_ticket_columns', array( &$this,'manage_defaults_columns') );
		//--------- End columns ---------
		
		/* add_action('restrict_manage_posts', array( &$this,'add_taxonomy_select_box_filter'));
		add_filter('parse_query',array( &$this,'filter_query_by_taxonomy'));
		add_action('admin_footer-edit.php', array( &$this,'add_bulk_approve_action'));
		add_action('load-edit.php', array( &$this,'approve_bulk_action'));
		add_action('admin_notices', array( &$this,'approve_admin_notices')); */
		
		//Extra dropdown menu and actions
		//add_action('admin_footer-edit.php', array( &$this,'add_extra_action'));
		add_action('restrict_manage_posts', array( &$this,'add_extra_filters'));
		
		//Pre filter
		add_filter('parse_query',array( &$this,'filter_query'));
		add_action( 'pre_get_posts', array( &$this,'set_default_sort'),9 );
		//add_filter('terms_clauses',  array( &$this,'sort_tickets_by_priority'), 10, 3);
		//add_filter('posts_clauses',  array( &$this,'sort_tickets_by_priority'), 10, 2);
	}
	function print_admin_result_notice() 
	{
		if($this->admin_notice == "")
			return;
		?>
		<div class="notice notice-success is-dismissible">
			<p><?php echo $this->admin_notice; ?></p>
		</div>
		<?php
	} 
	public function add_extra_filters()
	{
		global $typenow, $wp_query,$swss_option_helper,$swss_user_model, $swss_ticket_model; 
		if ($typenow=='swss_ticket') 
		{
			$ticket_visibility = $swss_option_helper->get_all_options('ticket_visibility', 'all_tickets'); // all_tickets || only_assigned
			
			wp_enqueue_style( 'swss-select2-style',  SWSS_PLUGIN_PATH.'/css/vendor/select2/select2.css' );
			wp_enqueue_style( 'swss-backend-tickets-table',  SWSS_PLUGIN_PATH.'/css/backend-tickets-table-page.css' );
			
			wp_enqueue_script('swss-select2', SWSS_PLUGIN_PATH.'/js/vendor/select2/select2.min.js', array('jquery'));
			wp_register_script('swss-load-customers-list', SWSS_PLUGIN_PATH.'/js/backend-load-customer-list.js', array('jquery'));
			wp_register_script('swss-custom-ui', SWSS_PLUGIN_PATH.'/js/backend-ticket-table-custom-ui.js', array('jquery'));
			
			//suncode
			$js_variables=array(
			'user' => __('User:','sunticket'),
			'user_id' => __('User ID:','sunticket'),
			'email' => __('Email:','sunticket'),
			'billing' => __('Billing:','sunticket'),
			);
			wp_localize_script( 'swss-custom-ui', 'swss', $js_variables );//suncode
			
			$custom_html_ui_vars = array(
				'filter_button_text' => __( 'Apply', 'sunticket' ),
			);  
			wp_localize_script( 'swss-custom-ui', 'swss_custom_ui', $custom_html_ui_vars );

			wp_localize_script( 'swss-load-customers-list', 'swss', array(
																			 'select2_placeholder' => __( 'Filter by customer', 'sunticket' ),
																			 'selected_user_info_label' => __( 'Showing ticket for user ID: ', 'sunticket' ),
																			 'select2_selected_value' => isset($_GET['customer_id']) ? $_GET['customer_id'] : ""
																			) 
								);
			wp_enqueue_script( 'swss-load-customers-list' );
			wp_enqueue_script( 'swss-custom-ui' );
			
			$selected = isset($_GET['swss_ticket_type']) && $_GET['swss_ticket_type'] ? $_GET['swss_ticket_type']:"none";
			$show_tickets_assigned_to = isset($_GET['swss_show_tickets_assigned_to']) && $_GET['swss_show_tickets_assigned_to'] ? $_GET['swss_show_tickets_assigned_to']:"none";
			$select2_selected = isset($_GET['customer_id']) && $_GET['customer_id'] ? $_GET['customer_id']:"none";
			$selected_status = /* isset($_GET['swss_ticket_bulk_status_assign']) && $_GET['swss_ticket_bulk_status_assign'] ? $_GET['swss_ticket_bulk_status_assign']: */"none";
			$selected_filter_status = isset($_GET['swss_ticket_filter_by_status']) && $_GET['swss_ticket_filter_by_status'] ? $_GET['swss_ticket_filter_by_status']:"none";
			
			if($swss_user_model->is_current_user_administrator() || $ticket_visibility == 'all_tickets'):
			?>
			<select name="swss_show_tickets_assigned_to" >
				<option value="none" <?php if($show_tickets_assigned_to == "none") echo 'selected="selected"';?> ><?php _e('Show ticket assignet to', 'sunticket') ?></option>
				<option value="all" <?php if($show_tickets_assigned_to == "all") echo 'selected="selected"';?>><?php _e('All', 'sunticket') ?></option>
				<option value="to_me" <?php if($show_tickets_assigned_to == "to_me") echo 'selected="selected"';?>><?php _e('To me', 'sunticket') ?></option>
			</select>
			<?php endif; 
			$ticket_types = $swss_ticket_model->get_ticket_types();
			?>
			<select name="swss_ticket_type" >
				<option value="none" <?php if($selected == "none") echo 'selected="selected"';?>><?php _e('Select a ticket type', 'sunticket') ?></option>
				<option value="all" <?php if($selected == "all") echo 'selected="selected"';?>><?php _e('All', 'sunticket') ?></option>
				<?php foreach($ticket_types as $ticket_type => $ticket_name): ?>
				<option value="<?php echo $ticket_type; ?>" <?php if($selected == $ticket_type) echo 'selected="selected"';?>><?php echo $ticket_name; ?></option>
				<?php endforeach;?>
			</select>
			<?php 
			$available_statuses = $swss_ticket_model->get_available_statuses();
			?>
			<select name="swss_ticket_filter_by_status" >
				<option value="none" <?php if($selected_filter_status == "none") echo 'selected="selected"';?>><?php _e('Filter by status', 'sunticket') ?></option>
				<?php foreach($available_statuses as $status_id => $status_data): ?>
				<option value="<?php echo $status_id; ?>" <?php if($selected_filter_status == $status_id) echo 'selected="selected"';?>><?php echo $status_data["label"][$status_data["current_lang"]]; ?></option>
				<?php endforeach;?>
			</select>
			
			<select name="swss_ticket_bulk_status_assign" >
				<option value="none" <?php if($selected_status == "none") echo 'selected="selected"';?>><?php _e('Bulk status assign', 'sunticket') ?></option>
				<?php foreach($available_statuses as $status_id => $status_data): ?>
				<option value="<?php echo $status_id; ?>" <?php if($selected_status == $status_id) echo 'selected="selected"';?>><?php echo $status_data["label"][$status_data["current_lang"]]; ?></option>
				<?php endforeach;?>
			</select>
						
			<select class="js-data-customers-ajax" id="wcst_select2_customer_id" name="customer_id" >
			</select>
			<?php
		}
	}
	function add_extra_action() 
	{
	  global $post_type;
	 
	  if($post_type == 'swss_ticket') {
		?>
		<script type="text/javascript">
		  jQuery(document).ready(function() {
			jQuery('<option>').val('wcuf_delete_uploads').text('<?php _e('Delete ticket', 'sunticket')?>').appendTo("select[name='action']");
			jQuery('<option>').val('wcuf_delete_uploads').text('<?php _e('Delete ticket', 'sunticket')?>').appendTo("select[name='action2']");
		  });
		</script>
		<?php
	  }
	}
	function filter_query($query) 
	{
		global $pagenow, $swss_option_helper, $swss_user_model,$wpdb;
		$qv = &$query->query_vars;
		
		if( $pagenow !='edit.php' || !isset($qv['post_type']) || $qv['post_type'] !='swss_ticket')
			return;
		
		$ticket_visibility =  isset($qv['post_type']) && $qv['post_type'] =='swss_ticket' && isset($swss_option_helper) && is_admin() ? $swss_option_helper->get_all_options('ticket_visibility', 'all_tickets') : 'all_tickets';
		
		$wpdb->query('SET MAX_JOIN_SIZE=9999');
		$wpdb->query('SET SQL_BIG_SELECTS=1');
			
		if ($pagenow=='edit.php' && 
		    isset($qv['post_type']) && $qv['post_type']=='swss_ticket' && isset($_GET['swss_ticket_type']) && ($_GET['swss_ticket_type'] != 'none' && $_GET['swss_ticket_type'] != 'all')) 
		{
			 $qv['meta_query'][] = 
				array(
				 //'relation' => 'OR',
				  array(
					'key' => 'swss_ticket_type',
					'compare' => '=',
					/*'compare' => 'NOT NULL',
					 'type' => 'CHAR' , */
					 'value' => $_GET['swss_ticket_type']
				  ),
				  /*  array(
					'key' => '_wcst_additional_companies',
					'compare' => 'LIKE',
					 'value' => serialize('_wcst_order_trackurl').serialize($_GET['swss_ticket_type'])
				  ) */
			  );
			 // swss_var_dump( $qv['meta_query']);
		}
		if ($pagenow=='edit.php' && 
		    isset($qv['post_type']) && $qv['post_type']=='swss_ticket' && isset($_GET['swss_ticket_bulk_status_assign']) && $_GET['swss_ticket_bulk_status_assign'] != 'none' && isset($_GET['post'])) 
		{
			foreach((array)$_GET['post'] as $ticket_id)
			{
				$swss_ticket_model = new SWSS_Ticket();
				$swss_ticket_model->set_status($ticket_id, $_GET['swss_ticket_bulk_status_assign']);
				$this->admin_notice = __('Statuses successfully applied to selected tickets!','sunticket');
			}
		}
		if (  $pagenow=='edit.php' && 
		     isset($qv['post_type']) && $qv['post_type']=='swss_ticket' && 
			 ( (!$swss_user_model->is_current_user_administrator() && $ticket_visibility != 'all_tickets') || (isset($_GET['swss_show_tickets_assigned_to']) && ($_GET['swss_show_tickets_assigned_to'] != 'none' && $_GET['swss_show_tickets_assigned_to'] != 'all')) ) 
			) 
		{
			/* if(!$swss_user_model->is_current_user_administrator())
				$qv["author__in"][] = get_current_user_id(); */
			 $qv['meta_query'][] = 
				
				/* array(
				  array(
					'key' => 'swss_manager_user_id',
					'compare' => '=',
					 'value' => get_current_user_id() //assigned 
				  ), */
				  
				   array
				   (
				     'relation' => 'OR',
					  array(
						'key' => 'swss_manager_user_id',
						'compare' => '=',
						 'value' => get_current_user_id() //assigned 
					  ),
					  
					  
					  //Enable the followings to make the unassigned ticket visible to all
					 /*  array(
						'key' => 'swss_manager_user_id',
						'compare' => 'NOT EXISTS',
						'value' => ''
					  ),
					  array(
						'key' => 'swss_manager_user_id',
						'compare' => '=',
						'value' => null
					  ) */
					  
					  
					  
				  );
			
			  
			 // swss_var_dump( $qv);
		}
		if ($pagenow=='edit.php' && 
		    isset($qv['post_type']) && $qv['post_type']=='swss_ticket' && isset($_GET['customer_id']) && is_numeric($_GET['customer_id'])) 
			{
				
			 $qv['meta_query'][] = 
				array(
				 //'relation' => 'OR',
				  array(
					'key' => 'swss_associated_user',
					'compare' => '=',
					 'value' => $_GET['customer_id']
				  )
			  );
			}
		if ($pagenow=='edit.php' && 
		    isset($qv['post_type']) && $qv['post_type']=='swss_ticket' && isset($_GET['swss_ticket_filter_by_status']) && $_GET['swss_ticket_filter_by_status'] != 'none') 
			{
				
			 $qv['meta_query'][] = 
				array(
				 //'relation' => 'OR',
				  array(
					'key' => 'swss_status',
					'compare' => '=',
					 'value' => $_GET['swss_ticket_filter_by_status']
				  )
			  );
			}
		
	}
	/* function sort_tickets_by_priority($pieces, $taxonomies, $args) 
	{
	  global $pagenow;
	  if(!is_admin()) 
	  {
		return $pieces;
	  }
	  
	  

	  if(is_admin() && $pagenow == 'edit.php' && $taxonomies[0] == 'swss_ticket_priority' && (!isset($_GET['orderby']) || $_GET['orderby'] == 'swss_ticket_priority')) 
	  {
		 $pieces['join']   .= " INNER JOIN wp_options AS opt ON opt.option_name = concat('issue_',t.term_id,'_issue_date')";
		 $pieces['orderby'] = "ORDER BY opt.option_value";
		 $pieces['order']   = isset($_GET['order']) ? $_GET['order'] : "DESC"; 
		

	  }

	  return $pieces;
	} */
	function sort_tickets_by_priority($clauses, $wp_query) 
	{
	   global $wpdb;
 
		if ( isset( $wp_query->query['orderby'] ) && 'swss_ticket_priority' == $wp_query->query['orderby'] ) 
		{
			$clauses['join'] .= "LEFT OUTER JOIN {$wpdb->term_relationships} ON {$wpdb->posts}.ID={$wpdb->term_relationships}.object_id
							LEFT OUTER JOIN {$wpdb->term_taxonomy} USING (term_taxonomy_id)
							LEFT OUTER JOIN {$wpdb->terms} USING (term_id)";
			 
			$clauses['where'] .= " AND (taxonomy = 'swss_ticket_priority' OR taxonomy IS NULL)";
			$clauses['groupby'] = "object_id";
			$clauses['orderby']  = "GROUP_CONCAT({$wpdb->terms}.name ORDER BY name ASC) ";
			$clauses['orderby'] .= ( 'ASC' == strtoupper( $wp_query->get('order') ) ) ? 'ASC' : 'DESC';
		}
	 
		return $clauses;
	}
	function set_default_sort($query)
	{
		if( ! $query->is_main_query() || 'swss_ticket' != $query->get( 'post_type' )  )
        return;
		$orderby = $query->get( 'orderby');      
		//swss_var_dump($orderby);
		 switch ( $orderby ) 
		{
			   /*  case 'new-messages-counter':
				$query->set( 'meta_key', 'extranet_case_office' );
				$query->set( 'orderby',  'meta_value_num' );
				break;   */
			case '':  // <-- The default empty case
				$query->set( 'order', 'desc' );  
				$query->set( 'orderby',  'modified-date' );
				break;
			case 'open-date':
				$query->set( 'meta_key', 'swss_open_status_date_standard_format' );
				$query->set( 'orderby',  'meta_value' );
				break; 	
			case 'modified-date':
				$query->set( 'orderby',  'post_modified' );
				break; 	
			case 'new-messages-counter':
				$query->set( 'meta_key', 'wcst_new_messages_counter' );
				$query->set( 'orderby',  'meta_value' );
				break; 
			default:
				break;
		} 
	}
	function sort_columns( $columns)
	{
		// $columns['taxonomy-swss_ticket_priority'] = 'taxonomy-swss_ticket_priority';
		$columns['open-date'] = 'open-date';
		$columns['new-messages-counter'] = 'new-messages-counter';
		//$columns['total-messages-counter'] = 'total-messages-counter';
		$columns['modified-date'] = 'modified-date';
		$columns['ticket-id'] = 'id';
		$columns['status'] = 'status';
		return $columns;
	}
	function add_custom_columns_heads($columns)
	{  
		global $swss_user_model;
		//new columns
		$resorted_columns = array();
		$resorted_columns['cb'] = $columns['cb'];
		$resorted_columns['ticket-id'] = __('Id', 'sunticket'); 
		$resorted_columns['ticket-type'] = __('Type', 'sunticket'); 
		$resorted_columns['new-messages-counter'] = __('New messages', 'sunticket'); 
		$resorted_columns['total-messages-counter'] = __('Total messages', 'sunticket'); 
		$resorted_columns['subject'] = __('Subject', 'sunticket'); 
		$resorted_columns['order-user-id'] = __('Order/User', 'sunticket'); 
		$resorted_columns['status'] = __('Status', 'sunticket'); 
		if($swss_user_model->is_current_user_administrator())
			$resorted_columns['assigned-users'] = __('Assigned to', 'sunticket'); 
		
		//not needed elements removal
		unset($columns['title']);
		unset($columns['cb']);
		unset($columns['date']);
		
		foreach($columns as $column_key => $column_content)
			$resorted_columns[$column_key] = $column_content;
		
		//as last elements
		$resorted_columns['who-replied-last'] = __('Who replied last', 'sunticket'); 
		$resorted_columns['modified-date'] = __('Last reply on', 'sunticket'); 
		$resorted_columns['open-date'] = __('Opened on', 'sunticket'); 
		
	   return $resorted_columns;
	}
	function manage_defaults_columns($column)
	{
		
		// swss_var_dump($column);
	}
	/* function add_custom_content_for_taxonomies_columns($column, $ticket_id ) 
	{
		global $swss_ticket_model, $swss_option_helper;
		
		
		if($column == 'taxonomy-swss_ticket_priority')
		{
			$term_id = $swss_ticket_model->get_priority_id($ticket_id);
			$attributes = $swss_option_helper->get_priority_term_attributes($term_id);
			$background_color = isset($attributes['background_color']) ? $attributes['background_color']: "none";
			$content = $background_color != "none" ? "<div style='width:100px; height:30px; background-color:{$background_color}; display:block;'></div>" : __('None', 'sunticket');
		}
		
	} */
	function add_custom_content_columns( $column, $ticket_id ) 
	{
		global $swss_ticket_model, $swss_user_model, $swss_option_helper;
		//swss_var_dump(get_admin_url()."edit.php?post_type=swss_ticket");
		
		
		//Pre operations
		if($column == 'ticket-id' || $column == 'new-messages-counter')
		{
			$new_messages_counter = $swss_ticket_model->count_new_messages($ticket_id);
			$new_messages_counter_label  = $new_messages_counter > 0 ? '<span style="background:#d54e21; padding:5px; color:white;">'.$new_messages_counter.'</strong>' : $new_messages_counter;
		}
		//Columns
		if ( $column == 'ticket-id' ) 
		{
			//priority color lately managed via js (WordPress api doesn't have any method to manipulate taxonomy columns
			$term_id = $swss_ticket_model->get_priority_id($ticket_id);
			$attributes = $swss_option_helper->get_priority_term_attributes($term_id);
			$background_color = isset($attributes['background_color']) ? $attributes['background_color']: "none";
			$text_color = isset($attributes['text_color']) ? $attributes['text_color']: "#000000";
			//end
			
			$ticket = get_post($ticket_id);	
			$id_label = $new_messages_counter > 0 ? "<strong>".$ticket_id."</strong>" : $ticket_id;
			$output = '<a href="'.get_edit_post_link($ticket_id).'" data-is-priority-data-defined="true" data-priority-background-color="'.$background_color.'" data-priority-text-color="'.$text_color.'">'.$id_label.'</a><br/>';
			$output .= '<div class="row-actions">';
			$output .= '<span class="edit"><a href="'.get_edit_post_link($ticket_id).'">'.__('Edit', 'sunticket').'</a> | </span>';
			if($ticket->post_status == 'trash')
				$output .= '<span class="trash"><a href="'.get_delete_post_link($ticket_id, null, true).'">'.__('Delete permanently', 'sunticket').'</a></span>';
			else
				$output .= '<span class="trash"><a href="'.get_delete_post_link($ticket_id).'">'.__('Delete', 'sunticket').'</a></span>';
			$output .= '</div>';
			echo $output;
		}
		if ( $column == 'new-messages-counter' )
		{			
			echo $new_messages_counter_label;
		}
		if ( $column == 'ticket-type' )
		{			
			$type = $swss_ticket_model->get_attributes($ticket_id,'ticket_type');
			$ticket_types = $swss_ticket_model->get_ticket_types();
			echo $ticket_types[$type];
			/* if($type == 'order')
				_e('Order ticket', 'sunticket');
			else
				_e('User ticket', 'sunticket'); */
		}
		if($column == 'total-messages-counter')
		{
			$total_messages_counter = $swss_ticket_model->count_total_messages($ticket_id);
			echo $total_messages_counter;
		}
		if ( $column == 'subject' ) 
		{
			if($swss_ticket_model->get_attributes($ticket_id,'ticket_type') != 'ppt')
			{
				echo "<div class='swss_subject_simple_text'>"; 
				echo $swss_ticket_model->get_subject($ticket_id);
				echo "</div>";
			}
			else 
			{
				echo "<div class='swss_subject_text_container'>"; 
				echo "<span class='swss_highlighted_text'>".__('Product name: ','sunticket')."</span>";
				echo $swss_ticket_model->get_attributes($ticket_id, 'ppt_product_name', "")."<br/><br/>";
				echo "<span class='swss_highlighted_text'>".__('Question left: ','sunticket')."</span>";
				echo $swss_ticket_model->get_attributes($ticket_id, 'number_of_questions_left', "");
				echo "</div>";
			}
		}
		if ( $column == 'order-user-id' ) 
		{
			$type = $swss_ticket_model->get_attributes($ticket_id,'ticket_type');
			if($type == 'order')
			{
				$associated_order = $swss_ticket_model->get_attributes($ticket_id,'associated_order');
				$associated_order = apply_filters('swss_get_order_id', $associated_order);
				echo '<a href="'.get_edit_post_link($associated_order).'" target="_blank">'.$associated_order.'</a>';
			}
			else
			{
				$associated_user_id = $swss_ticket_model->get_attributes($ticket_id,'associated_user');
				$associated_user = get_user_meta($associated_user_id);
				/* $first_name = isset($associated_user['first_name'][0]) ? $associated_user['first_name'][0] : "";
				$last_name = $associated_user['last_name'][0] ? $associated_user['last_name'][0] : ""; */
				$first_name = isset($associated_user['billing_first_name']) && isset($associated_user['billing_first_name'][0]) ? $associated_user['billing_first_name'][0] : "";
				$last_name = isset($associated_user['billing_last_name']) && isset($associated_user['billing_last_name'][0]) ? $associated_user['billing_last_name'][0] : "";
				$email = isset($associated_user['billing_email']) && isset( $associated_user['billing_email'][0]) ? $associated_user['billing_email'][0] : "";
				echo '<a href="'.get_edit_user_link($associated_user_id).'" target="_blank">#'.$associated_user_id." - ".$first_name.' '.$last_name.'<br>('.$email.')</a>';
			}
		}
		if($column =='who-replied-last')
		{
			switch($swss_ticket_model->get_who_replied_latest($ticket_id))
			{
				case 'customer': _e('Customer', 'sunticket'); break;
				case 'staff': _e('Staff', 'sunticket'); break;
			}
		}
		if ( $column == 'modified-date' ) 
			the_modified_date(get_option('date_format')." ".get_option('time_format'));
		if ( $column == 'open-date' ) 
			echo $swss_ticket_model->get_attributes($ticket_id, 'open_status_date', "");
		if ( $column == 'status' ) 
		{
			$ticket_status_data = $swss_ticket_model->get_status_data($ticket_id);
			$status_text = $ticket_status_data['label'][$ticket_status_data['current_lang']];
			$ticket_status = $ticket_status_data['id'];
			 $status_label = '<span style="background:'.$ticket_status_data['background_color'].'; color:'.$ticket_status_data['text_color'].'; padding:5px;">'. $status_text.'</span>';
			/* $status_label = $status_text;
			switch($swss_ticket_model->get_attributes($ticket_id, 'status', "open"))
			{
				case 'open': $status_label = '<span style="background:#00B259; padding:5px; color:white;">'. $status_text.'</span>';break;
				case 'in_progress': $status_label = '<span style="background:#FF9326; padding:5px; color:white;">'. $status_text.'</span>';break;
				case 'closed': $status_label = '<span style="background:#D90000; padding:5px; color:white;">'. $status_text.'</span>';break;
			} */
			echo $status_label;
		}
		if($column == 'assigned-users')
		{
			$user_ids = $swss_ticket_model->get_manager_user_ids($ticket_id);
			if(empty($user_ids))
				_e('Any','sunticket');
			else
				foreach($user_ids as $user_id)
				{
					$user_data = $swss_user_model->get_user_data($user_id);
					if($user_data)
					{
						$user_name = $user_data->first_name.$user_data->last_name != "" ? $user_data->first_name." ".$user_data->last_name : "N/A";
						echo "<div class='swss_manager_user_container'><strong>#".$user_data->ID."</strong> - <a href='".get_edit_user_link($user_data->ID)."' target='_blank' >".$user_name."</a> </div>"; //(".$user_data->user_email.")
					}
				}
		}
		
	}
}
?>