<?php
class SWSS_ProductPage
{
	public function __construct()
	{
		add_action('woocommerce_variation_options',array(&$this,'add_questions_input_text_to_variation'),1,3);
		add_action('woocommerce_product_options_pricing',array(&$this,'add_add_questions_input_text_to_simple_product'));
		add_action( 'save_post', array( &$this, 'on_save' ), 999, 2 );
		add_action( 'wp_ajax_woocommerce_save_variations', array( &$this, 'on_variation_ajax_save' ) );
		add_action( 'woocommerce_variable_product_bulk_edit_actions', array( &$this, 'add_bulk_options_to_select_menu' ) );
		add_action( 'admin_head', array( &$this, 'add_scripts' ), 1 );
	}
	public function add_scripts()
	{
		$page_obj = get_current_screen();
		if(!isset($page_obj ) || $page_obj->id != 'product')
			return;
		
		wp_register_script('swss-product-page', SWSS_PLUGIN_PATH.'/js/backend-product-page.js', array('jquery') );
		$translation_array = array(
			'bulk_questions_number_label' => __( 'Enter a number of questions to assign', 'sunticket' )
		);
		wp_localize_script( 'swss-product-page', 'swss', $translation_array );
		wp_enqueue_script( 'swss-product-page' );
		
		
	}
	public function add_bulk_options_to_select_menu()
	{
		?>
		<optgroup label="<?php esc_attr_e( 'Pay Per Ticket', 'sunticket' ); ?>">
			<option value="ppt_bulk_assign_questions_number"><?php _e( 'Assign questions number to all variations', 'sunticket' ); ?></option>
		</optgroup>
		<?php 
	}
	public function add_questions_input_text_to_variation($loop, $variation_data, $variation )
	{
		
		global $swss_product_model, $swss_wpml_helper;
		//swss_var_dump($variation);
		$variation_id = $swss_wpml_helper->get_main_language_id($variation->ID);
		$value = $swss_product_model->get_product_questions_number($variation_id);
		
		
		woocommerce_wp_text_input( array(
				'id'          => "swss_ppt_questions_number_{$variation->ID}",
				'name'          => "swss_ppt_questions_number[{$variation->ID}]",
				'value'       =>  $value,
				'type'       =>  'number',
				'custom_attributes'       =>  array('min' => 0),
				'class' 			=> 'swss_questions_number_input',
				'wrapper_class'   =>  'form-row form-row-full',
				'label'       => __( 'Questions number', 'sunticket' ),
				'placeholder' => __( 'Questions number', 'sunticket' )
			) );
		//echo '</p>';
	}
	public function add_add_questions_input_text_to_simple_product( )
	{  
		global $post, $swss_product_model, $swss_wpml_helper;
		$product_id = $swss_wpml_helper->get_main_language_id($post->ID);
		$value = $swss_product_model->get_product_questions_number($product_id);
		woocommerce_wp_text_input( array(
				'id'          => 'swss_ppt_questions_number',
				'value'       =>  $value,
				'type'       =>  'number',
				'custom_attributes'       =>  array('min' => 0),
				'label'       => __( 'Questions number', 'sunticket' ),
				'placeholder' => __( 'Questions number', 'sunticket' ),
				//'description' => __( 'Enter the number of questions the user can make.', 'sunticket' ),
			) );
	}
	public function on_save($product_id, $product_obj)
	{
		global $swss_wpml_helper, $swss_product_model;
		$product_id = $swss_wpml_helper->get_main_language_id($product_id);
		
		/*if ( !isset( $_POST['swss_admin_action'] ) || !wp_verify_nonce( $_POST['swss_admin_action'], 'swss_admin_ticket_edit' ) )
			return;*/
		if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) 
        return;
		// AJAX? Not used here
		if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) 
				return;
		if($product_obj->post_type != 'product')
			return;
		
		if(!isset($_POST['swss_ppt_questions_number']))
			return;
		
		
		if(!is_array($_POST['swss_ppt_questions_number']))
				$swss_product_model->update_product_questions_number($product_id, $_POST['swss_ppt_questions_number']);
		else 
			foreach($_POST['swss_ppt_questions_number'] as $variation_id => $questions_number)
			{
				$variation_id = $swss_wpml_helper->get_main_language_id($variation_id);
				$swss_product_model->update_product_questions_number($variation_id, $questions_number);
			}
			
	}
	public function on_variation_ajax_save()
	{
		global $swss_wpml_helper, $swss_product_model;
		if(isset($_POST['swss_ppt_questions_number']) && is_array($_POST['swss_ppt_questions_number']))
			foreach($_POST['swss_ppt_questions_number'] as $variation_id => $questions_number)
			{
				$variation_id = $swss_wpml_helper->get_main_language_id($variation_id);
				$swss_product_model->update_product_questions_number($variation_id, $questions_number);
			}
	}
}
?>