<?php 
if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_57c4404468513',
	'title' => __('Sunticket - Details','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57c4405283c7e',
			'label' => __('Status','sunticket'),
			'name' => 'swss_status',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'multiple' => 0,
			'allow_null' => 0,
			'choices' => array(
				'open' => 'Open',
				'in_progress' => 'In Progress',
				'closed' => 'Closed',
				'5UamyE07B7' => 'Custom 2',
			),
			'default_value' => array(
				0 => 'open',
			),
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_57c443580e386',
			'label' => __('Priority','sunticket'),
			'name' => 'swss_priority',
			'type' => 'taxonomy',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'taxonomy' => 'swss_ticket_priority',
			'field_type' => 'select',
			'multiple' => 0,
			'allow_null' => 0,
			'return_format' => 'object',
			'add_term' => 1,
			'load_terms' => 1,
			'save_terms' => 1,
		),
		array(
			'key' => 'field_57c461c618678',
			'label' =>  __('Open date','sunticket'),
			'name' => 'swss_open_status_date',
			'type' => 'date_time_picker',
			// 'type' => 'jalali_datepicker',
			'instructions' => __('If left empty, the system will automatically fill with the "now" date.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'display_format' => 'Y/m/d H:i',//'F j, Y g:i a',
			'return_format' => 'Y/m/d H:i',//'F j, Y g:i a',
			'first_day' => 1,
			'config-datepicker' => "{calendar:{ persian: { locale: 'en' } }, format: 'YYYY/MM/DD H:mm', timePicker: { enabled: true, meridiem: { enabled: true } }, }",
		),
		array(
			'key' => 'field_57c459a2d89fb',
			'label' => 'Closed date',
			'name' => 'swss_closed_status_date',
			'type' => 'date_time_picker',
			'instructions' => __('If left empty, the system will automatically fill with the "now" date.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57c4405283c7e',
						'operator' => '==',
						'value' => 'closed',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'display_format' => 'F j, Y g:i a',
			'return_format' => 'F j, Y g:i a',
			'first_day' => 1,
		),
		array(
			'key' => 'field_57d2730d39654',
			'label' => __('Email notification recipients override','sunticket'),
			'name' => 'wcst_notification_recipients_override',
			'type' => 'text',
			'instructions' => __('<p>By default admin email notifications are sent to the site admin email address (or the custom recipients configured on <strong>Ticket System Options</strong> menu).</p>
<p>To override those settings specify new recipients in the following text area (in case of multiple recipients, separate them by comma). In this way the notifications will be sent only to the following email addresses.</p>','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => 'admin@yoursite.com, shop_manager@yoursite.com',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'swss_ticket',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'side',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5900cce22558c',
	'title' => __('Sunticket - Text: Topics','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57d5a07f74548',
			'label' => __('Order ticket - Subject type','sunticket'),
			'name' => 'swss_order_ticket_subject_type',
			'type' => 'select',
			'instructions' => __('Ticket subject can be a text input where the user can type text or can be chosen between a set of topic defined by the admin.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'multiple' => 0,
			'allow_null' => 0,
			'choices' => array(
				'text_input' => __('Text input','sunticket'),
				'admin_defined_topics' => __('Admin defined topics','sunticket'),
			),
			'default_value' => array(
				0 => 'text_input',
			),
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_57d65ce6ebe3e',
			'label' => __('Order ticket - Subject topics','sunticket'),
			'name' => 'swss_order_ticket_subject_topics',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d5a07f74548',
						'operator' => '==',
						'value' => 'admin_defined_topics',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => 'field_57d65d31ebe3f',
			'min' => 1,
			'max' => 0,
			'layout' => 'row',
			'button_label' => __('Add Topic','sunticket'),
			'sub_fields' => array(
				array(
					'key' => 'field_57d65d31ebe3f',
					'label' => __('Topic','sunticket'),
					'name' => 'swss_topic',
					'type' => 'text',
					'instructions' => __('Type the topic text','sunticket'),
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_5f86e657f3ff3',
					'label' => __('Email recipient','sunticket'),
					'name' => 'swss_topic_email_recipient',
					'type' => 'text',
					'instructions' => __('For each topic you can set specific <strong>admin notitifcation recipients</strong> (in case of multiple recipients, separate them by comma). In this way the admin notifications will be sent to the specied email addresses. The user notification will be normally sent to the user email address.','sunticket'),
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => 'email1@domain.com, email2@domain.com',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
			),
		),
		array(
			'key' => 'field_57d65d8eebe40',
			'label' => __('User ticket - Subject type','sunticket'),
			'name' => 'swss_user_ticket_subject_type',
			'type' => 'select',
			'instructions' => __('Ticket subject can be a text input where the user can type text or can be chosen between a set of topic defined by the admin.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'multiple' => 0,
			'allow_null' => 0,
			'choices' => array(
				'text_input' => __('Text input','sunticket'),
				'admin_defined_topics' => __('Admin defined topics','sunticket'),
			),
			'default_value' => array(
				0 => 'text_input',
			),
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_57d65da7ebe41',
			'label' => __('User ticket - Subject topics','sunticket'),
			'name' => 'swss_user_ticket_subject_topics',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d65d8eebe40',
						'operator' => '==',
						'value' => 'admin_defined_topics',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => 'field_57d65da7ebe42',
			'min' => 1,
			'max' => 0,
			'layout' => 'row',
			'button_label' => __('Add Topic','sunticket'),
			'sub_fields' => array(
				array(
					'key' => 'field_57d65da7ebe42',
					'label' => __('Topic','sunticket'),
					'name' => 'swss_topic',
					'type' => 'text',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_5f86e6f9f3ff4',
					'label' => __('Email recipient','sunticket'),
					'name' => 'swss_topic_email_recipient',
					'type' => 'text',
					'instructions' => __('For each topic you can set specific <strong>admin notitifcation recipients</strong> (in case of multiple recipients, separate them by comma). In this way the admin notifications will be sent to the specied email addresses. The user notification will be normally sent to the user email address.','sunticket'),
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => 'email1@domain.com, email2@domain.com',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
			),
		),
		array(
			'key' => 'field_5901f5a24401b',
			'label' => __('Automatic ticket - Subject topic','sunticket'),
			'name' => 'swss_automatic_ticket_subject_topic',
			'type' => 'text',
			'instructions' => __('This is the subject for ticket automatically created when order hits the selected statuses. It works only if the special <strong>Automatic ticket</strong> option has been enabled.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-texts',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

//suncode start

global $swss_ticket_model;
if(isset($_REQUEST['post'])){
$related_product = $swss_ticket_model->get_attributes($_REQUEST['post'], 'related_product', "-");
}else{
	$related_product  = "-";
}
if($related_product=="-"){
	$pro_title="-";
}else{
	$pro_title = "<a target='_blank' href='".get_permalink($related_product)."'>".get_the_title($related_product)."</a>";
}

//suncode end

acf_add_local_field_group(array(
	'key' => 'group_57c444e52816c',
	'title' => __('Sunticket - Type','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57d65bfe5027a',
			'label' => __('Ticket type','sunticket'),
			'name' => 'swss_ticket_type',
			'type' => 'select',
			'instructions' => __('Tickets can be Order, User o Pay per ticket type.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'order' => __('Order ticket','sunticket'),
				'user' => __('User ticket','sunticket'),
				'ppt' => __('Pay per ticket','sunticket'),
			),
			'default_value' => array(
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		//suncode start
	array(
			'key' => 'field_1ae6f3c50b4vt',
			'label' => __('User ticket - Related Product','sunticket'),
			'name' => 'swss_related_product',
			'type' => 'text',
			'instructions' => $pro_title,
			'required' => 0,
			'readonly'=> 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d65bfe5027a',
						'operator' => '==',
						'value' => 'user',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',//'proname',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
	//suncode end
		array(
			'key' => 'field_57c444629da86',
			'label' => __('Associated order','sunticket'),
			'name' => 'swss_associated_order',
			'type' => 'post_object',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d65bfe5027a',
						'operator' => '==',
						'value' => 'order',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'shop_order',
			),
			'taxonomy' => array(
			),
			'allow_null' => 0,
			'multiple' => 0,
			'return_format' => 'id',
			'ui' => 1,
		),
		array(
			'key' => 'field_57d65c825027b',
			'label' => __('Associated user','sunticket'),
			'name' => 'swss_associated_user',
			'type' => 'user',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d65bfe5027a',
						'operator' => '==',
						'value' => 'user',
					),
				),
				array(
					array(
						'field' => 'field_57d65bfe5027a',
						'operator' => '==',
						'value' => 'ppt',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'role' => '',
			'allow_null' => 0,
			'multiple' => 0,
			'return_format' => 'array',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'swss_ticket',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_57cd9e7e25c38',
	'title' => __('Sunticket – Options: System','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57cd9dd76709c',
			'label' => __('Subject lenght','sunticket'),
			'name' => 'swss_subject_lenght',
			'type' => 'number',
			'instructions' => __('Max lenght for the Ticket subject.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 100,
			'placeholder' => 'Default value: 100',
			'prepend' => '',
			'append' => '',
			'min' => 1,
			'max' => '',
			'step' => 1,
		),
		array(
			'key' => 'field_57cd9e3e6709d',
			'label' => __('Subject message lenght','sunticket'),
			'name' => 'swss_message_lenght',
			'type' => 'number',
			'instructions' => __('Ticket message lenght.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 500,
			'placeholder' => 'Default value: 500',
			'prepend' => '',
			'append' => '',
			'min' => 1,
			'max' => '',
			'step' => 1,
		),
		array(
			'key' => 'field_57cda0182d364',
			'label' => __('Select which roles can view tickets in Admin area','sunticket'),
			'name' => 'swss_roles_can_manage_ticket_system',
			'type' => 'role_selector',
			'instructions' => __('<p>Select which roles can view tickets. If none is select only the <strong>Shop Manager</strong> and <strong>Administrator</strong> will be able to manage tickets.</p>','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_roles' => '',
			'field_type' => 'checkbox',
		),
		array(
			'key' => 'field_58877a24272d1',
			'label' => __('Display all tickets to non Administrator users (admin area)','sunticket'),
			'name' => 'swss_ticket_visibility',
			'type' => 'select',
			'instructions' => __('<p>Choose if in the admin area the <strong>non-Administrator</strong> accounts can see all the submitted tickets or only the ones assigned by the <strong>Administrator(s)</strong>.</p>','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'all_tickets' => __('All tickets','sunticket'),
				'only_assigned' => __('Only assigned tickets','sunticket'),
			),
			'default_value' => array(
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_588c682cae593',
			'label' => __('Display ticket status on frontend','sunticket'),
			'name' => 'swss_display_ticket_status_on_frontend',
			'type' => 'select',
			'instructions' => __('By default the ticket status is used only for internal tracking purpose. Optionally you can display ticket current status in the frontend in order to give more feedback to the user.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'no' => __('No','sunticket'),
				'yes' => __('Yes','sunticket'),
			),
			'default_value' => array(
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_590c2eb3c826d',
			'label' => __('Display ticket priority selector on frontend','sunticket'),
			'name' => 'swss_display_ticket_priority_selector_on_frontend',
			'type' => 'select',
			'instructions' => __('By default the ticket priority is used only for internal tracking purpose. Optionally you can display ticket status selector in the frontend in order to allow the user to assign a priority to the just created ticket.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'no' => __('No','sunticket'),
				'yes' => __('Yes','sunticket'),
			),
			'default_value' => array(
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
		array(
			'key' => 'field_58c6c0b7c608a',
			'label' => __('Enable Tiny mce editor for ticket message area on frontend','sunticket'),
			'name' => 'swss_frontend_use_tiny_mce',
			'type' => 'true_false',
			'instructions' => __('This option will enable the Tiny MCE editor for ticket input areas. This will allow your customer to enter a more rich texts.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		//suncode start faq questions
		
		array(
			'key' => 'field_18n6c0b7c60bgt',
			'label' => __('Show FAQ Questions in new ticket form','sunticket'),
			'name' => 'swss_show_faqs',
			'type' => 'true_false',
			'instructions' => __('To add FAQ question go to sunticket text settings','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		//suncode end faq questions
		
		//suncode start ticket top message
		
		array(
			'key' => 'field_23n6c0b8d60vga',
			'label' => __('Show Ticket Top Message','sunticket'),
			'name' => 'swss_show_ticket_top_message',
			'type' => 'true_false',
			'instructions' => __('Show a message in top of ticket','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '100',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_16n6y0b1d60tup',
			'label' => __('Ticket Top Message','sunticket'),
			'name' => 'swss_ticket_top_message',
			'type' => 'wysiwyg',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_23n6c0b8d60vga',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '100',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		//suncode end ticket top message
		
		array(
			'key' => 'field_590072b5263f0',
			'label' => __('Ticket area pagination','sunticket'),
			'name' => 'swss_ticket_area_pagination',
			'type' => 'number',
			'instructions' => __('Number of tickets displayed per page in the ticket area.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 10,
			'placeholder' => 'Default value: 10',
			'prepend' => '',
			'append' => '',
			'min' => 1,
			'max' => '',
			'step' => 1,
		),
		array(
			'key' => 'field_5854f7a01dcb2',
			'label' => __('User ticket - Display user ticket area in My account page','sunticket'),
			'name' => 'swss_display_user_ticket_area_in_my_account_page',
			'type' => 'select',
			'instructions' => __('User ticket area can be displayed in My account page in its own tab.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'yes' => __('Yes','sunticket'),
				'no' => __('No','sunticket'),
			),
			'default_value' => array(
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5c933b675f5cb',
			'label' => __('User ticket - Disable user ticket opening','sunticket'),
			'name' => 'swss_disable_user_ticket_opening',
			'type' => 'true_false',
			'instructions' => __('The user won\'t be able to open new user tickets. He can only read the already existing and the ones opened by the Admin.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5ae6c3c50b4eb',
			'label' => __('User ticket - My Account user ticket area URL endpoint','sunticket'),
			'name' => 'swss_user_tickect_area_url_endpoint',
			'type' => 'text',
			'instructions' => __('My Account user ticket area by default has the following url: https://youriste.com/my-account/swss-user-tickets-area/ . The <strong>swss-user-tickets-area</strong> can be customized using a custom text.
If left empty will be used the default <strong>swss-user-tickets-area</strong> endpoint.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5854f7a01dcb2',
						'operator' => '==',
						'value' => 'yes',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 'swss-user-tickets-area',
			'placeholder' => 'swss-user-tickets-area',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_57d67d41bcfe7',
			'label' => __('Order ticket - Enable Order ticket system','sunticket'),
			'name' => 'swss_is_order_ticket_enabled',
			'type' => 'select',
			'instructions' => __('By default order ticket system is enabled and shows ticket area inside every order details page. Select <strong>No</strong> to disable order ticket system display.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'yes' => __('Yes','sunticket'),
				'no' => __('No','sunticket'),
			),
			'default_value' => array(
				0 => 'yes',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_58c6ad3f705cf',
			'label' => __('Order ticket - Display "Tickets" column on My Account -> Order table','sunticket'),
			'name' => 'swss_display_ticket_number_column_on_my_accont_order_table',
			'type' => 'true_false',
			'instructions' => __('Once enable this option, the plugin will display a new "Tickets" column in the order table reporting the number of ticket opened for each order.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d67d41bcfe7',
						'operator' => '==',
						'value' => 'yes',
					),
				),
			),
			'wrapper' => array(
				'width' => '34',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5d820a1c21e47',
			'label' => __('Order ticket - Mark ticket as closed on "completed" status','sunticket'),
			'name' => 'swss_mark_ticket_as_closed_on_completed',
			'type' => 'true_false',
			'instructions' => __('When an order hits the "completed" status, associated tickets will be marked as closed. <strong>Note:</strong> switching back the order to another status, won\'t change the ticket status.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d67d41bcfe7',
						'operator' => '==',
						'value' => 'yes',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_59c29f519e37d',
			'label' => __('Order ticket - Order details area position','sunticket'),
			'name' => 'swss_order_ticket_area_position',
			'type' => 'select',
			'instructions' => __('Select a position for the Ticket area inside the Order details page','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d67d41bcfe7',
						'operator' => '==',
						'value' => 'yes',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'woocommerce_order_details_after_order_table' => __('After order details table','sunticket'),
				'woocommerce_order_details_after_billing_and_shipping_details' => __('After customer billing and shipping addresses','sunticket'),
			),
			'default_value' => array(
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
		),
		array(
			'key' => 'field_5847c90f7b40a',
			'label' => __('Order ticket - Disable tickets by order status','sunticket'),
			'name' => 'swss_order_ticket_system_disabled_order_statuses',
			'type' => 'order_staus_selector',
			'instructions' => __('Select for which order statuses the ticket area will be not displayed in the order details page.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d67d41bcfe7',
						'operator' => '==',
						'value' => 'yes',
					),
				),
			),
			'wrapper' => array(
				'width' => '34',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
		array(
			'key' => 'field_59d24e3ef31b1',
			'label' => __('Order ticket - Display order status on tickets','sunticket'),
			'name' => 'swss_display_order_status_on_order_tickets',
			'type' => 'true_false',
			'instructions' => __('Show order status on order tickets.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d67d41bcfe7',
						'operator' => '==',
						'value' => 'yes',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_59df294ed4280',
			'label' => __('Order ticket - Number of order tickets that can be opened by user','sunticket'),
			'name' => 'swss_order_ticket_limit',
			'type' => 'number',
			'instructions' => __('This is the max number of order tickets that the user can open. Set <strong>-1</strong> for no limits.','sunticket'),
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d67d41bcfe7',
						'operator' => '==',
						'value' => 'yes',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => -1,
			'placeholder' => 'Default value: -1',
			'prepend' => '',
			'append' => '',
			'min' => -1,
			'max' => '',
			'step' => 1,
		),
		array(
			'key' => 'field_5a25161211310',
			'label' => __('User won\'t be able to reply if ticket is marked as closed','sunticket'),
			'name' => 'swss_deny_closed_ticket_reply',
			'type' => 'true_false',
			'instructions' => __('By default user will be able to reply if a ticket was marked as closed. Enable this option to deny user reply for closed tickets','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '34',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5f893ca8c1f2c',
			'label' => __('Order ticket - Prevent the user to post further messages until an admin posted a reply','sunticket'),
			'name' => 'swss_order_ticket_disable_user_reply_until_admin_message',
			'type' => 'true_false',
			'instructions' => __('This option prevents the user to be able to post further messages until he got a reply for the previous one.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5f893d76c1f2d',
			'label' => __('User ticket - Prevent the user to post further messages until an admin posted a reply','sunticket'),
			'name' => 'swss_user_ticket_disable_user_reply_until_admin_message',
			'type' => 'true_false',
			'instructions' => __('This option prevents the user to be able to post further messages until he got a reply for the previous one.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5a0eff8e13e9d',
			'label' => __('Order details page - Disable smooth scroll','sunticket'),
			'name' => 'swss_order_details_page_smooth_scroll',
			'type' => 'true_false',
			'instructions' => __('When the <strong>Get help</strong> button is pressed the user is redirected into the Order details page smoth scolling to the Ticket area. You can disable the smooth scrool feature.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '34',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5c431050ec342',
			'label' => __('Disable "Get help" button','sunticket'),
			'name' => 'swss_disable_get_help_button',
			'type' => 'true_false',
			'instructions' => __('On orders list page, for each order, a "Get help" button is displayed. The "Get help" button redirects the user into the order ticket area. This options disable that button display.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		
		/* 
		comment by suncode
		array(
			'key' => 'field_5a66f8ffc4b5c',
			'label' => __('Ticket messages area - show it already expansed','sunticket'),
			'name' => 'swss_ticket_conversation_is_expansed',
			'type' => 'true_false',
			'instructions' => __('By default Ticket message area is collpased. Enable this option to show it expansed.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		), */
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-options',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5854faf84fc9a',
	'title' => __('Sunticket – Text: My Account page user ticket area','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_5854fb0662bf5',
			'label' => __('Tab label','sunticket'),
			'name' => 'swss_my_account_page_user_ticket_area_tab_label',
			'type' => 'text',
			'instructions' => __('Personal Ticket Area','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('Personal Ticket Area','sunticket'),
			'maxlength' => '',
			'placeholder' => __('Personal Ticket Area','sunticket'),
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5854ff73f4cb7',
			'label' => __('Tab page description','sunticket'),
			'name' => 'swss_my_account_tab_page_description',
			'type' => 'wysiwyg',
			'instructions' => __('This is a description displayed in the User ticket area tab page before the ticket area.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('Create a new ticket or reply to the already opened tickets. <strong>NOTE:</strong> To submit a ticket about an order, please click on <strong>Orders</strong> tab, click on the order you wish and then use the ticket area you find in the its details page.','sunticket'),
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 1,
			'delay' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-texts',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_57cd8ed53fcde',
	'title' => __('Sunticket - Text: Form','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57cd8f23e7e07',
			'label' => __('New ticket description text','sunticket'),
			'name' => 'swss_new_ticket_description_text',
			'type' => 'wysiwyg',
			'instructions' => __('This is a description text showed on new ticket area. Here you can provide more info about response time or whatever you think you customers should know before submitting a new ticket.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 1,
			'delay' => 0,
		),
		array(
			'key' => 'field_57cd8f9e207c8',
			'label' => __('New ticket "succesfully submitted" message','sunticket'),
			'name' => 'swss_new_ticket_succesfully_submitted_message',
			'type' => 'text',
			'instructions' => __('This is the text message showed after a ticket has been sucesfully submitted.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('The ticket has been succesfully submitted!','sunticket'),
			'maxlength' => '',
			'placeholder' => __('The ticket has been succesfully submitted!','sunticket'),
			'prepend' => '',
			'append' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-texts',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));


/* suncode start FAQ */

acf_add_local_field_group(array(
	'key' => 'group_4rtgh9onhsdfwef',
	'title' => __('Sunticket - Text: FAQ','sunticket'),
	'fields' => array(
		
		array(
			'key' => 'field_43bfbfcsdfsdfe',
			'label' => __('FAQ Questions List','sunticket'),
			'name' => 'swss_faq_list',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			/* 'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d5a07f74548',
						'operator' => '==',
						'value' => 'admin_defined_topics',
					),
				),
			), */
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => 'field_57d65d31ebe3f',
			'min' => 1,
			'max' => 0,
			'layout' => 'row',
			'button_label' => __('Add','sunticket'),
			'sub_fields' => array(
				array(
					'key' => 'field_faqd65drgebe3g',
					'label' => __('Title','sunticket'),
					'name' => 'swss_faq_title',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_faqc6e657f3fbg',
					'label' => __('FAQ Content','sunticket'),
					'name' => 'swss_faq_content',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
			),
		),
		
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-texts',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));
/* suncode end FAQ */

acf_add_local_field_group(array(
	'key' => 'group_57cebb0ad6303',
	'title' => __('Sunticket – Options: Attachments','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57ceba6a1373e',
			'label' => __('Allow file(s) attachment?','sunticket'),
			'name' => 'swss_allow_files_attachment',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 0,
			'message' => __('Enable','sunticket'),
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_57ceba931373f',
			'label' => __('Number of uploadable files','sunticket'),
			'name' => 'swss_num_of_uploadable_files',
			'type' => 'number',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57ceba6a1373e',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => 1,
			'min' => 1,
			'max' => '',
			'step' => 1,
			'placeholder' => 1,
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_57cebab813740',
			'label' => __('Allowed file types','sunticket'),
			'name' => 'swss_allowed_file_types',
			'type' => 'text',
			'instructions' => __('Specify which file type(s) are allowed. Leave empty to allow all file types. In case of multiple file types, specify extension separating value by comma. Ex.: ".jpg, .pdf, .png".','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57ceba6a1373e',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '.jpg, .pdf, .png',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_57cebb4613741',
			'label' => __('Max file size','sunticket'),
			'name' => 'swss_max_file_size',
			'type' => 'number',
			'instructions' => __('Specify the max size of the uploadable files. Size is expressed in <strong>Kb</strong>.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57ceba6a1373e',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => 4096,
			'min' => 1,
			'max' => '',
			'step' => 1,
			'placeholder' => 4096,
			'prepend' => '',
			'append' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-options',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5976f6ab1668c',
	'title' => __('Sunticket - Texts: Misc','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_5976f6bfbe525',
			'label' => __('Email sender name used for notification emails','sunticket'),
			'name' => 'swss_email_sender_name',
			'type' => 'text',
			'instructions' => __('Leave empty to use the Blog name as sender name.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_59672946edbea',
			'label' => __('Pay Per Ticket - No more questions left message','sunticket'),
			'name' => 'swss_ppt_no_more_questions_left_message',
			'type' => 'text',
			'instructions' => __('This text is displayed on the fronted when the users cannot hasn\'t left any more question.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '33',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('You cannot ask any more question.','sunticket'),
			'placeholder' => __('You cannot ask any more question.','sunticket'),
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_59cd150ab226d',
			'label' => __('Order list page - Get help button text','sunticket'),
			'name' => 'swss_get_help_button_text',
			'type' => 'text',
			'instructions' => __('Text for the "Get help" button showed in the order list page.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '34',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('Get Help','sunticket'),
			'placeholder' => __('Get Help','sunticket'),
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_59ce451e95d57',
			'label' => __('Personal Ticket Area tab - new messages counter label','sunticket'),
			'name' => 'swss_personal_ticket_area_tab_new_messages_counter_label',
			'type' => 'text',
			'instructions' => __('<p>Every time a new messages are available, this text will be showed notifing the new number of messages. Use the special %s as placeholder for the number of messages.</p>
<p><strong>NOTE:</strong> to not display the label, leave empty this field</p>','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('(new messages: %s)','sunticket'),
			'placeholder' => __('(new messages: %s)','sunticket'),
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_59df25449fab2',
			'label' => __('Staff label on admin replies','sunticket'),
			'name' => 'swss_staff_label_text',
			'type' => 'text',
			'instructions' => __('On admin replies, "Staff" is used as author. You can customize that text by using this option.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('Staff','sunticket'),
			'placeholder' => __('Staff','sunticket'),
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-texts',
			),
		),
	),
	'menu_order' => 2,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_57d28ca45f907',
	'title' => __('Sunticket – Options: Email notifications','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57d28c39a0404',
			'label' => __('User - Email notifications','sunticket'),
			'name' => 'swss_user_email_notifications',
			'type' => 'true_false',
			'instructions' => __('Enable user email notifications.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 1,
			'message' => __('Enable','sunticket'),
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_57d28bf1a0403',
			'label' => __('User - New ticket submission notification','sunticket'),
			'name' => 'swss_user_new_ticket_submission_notification',
			'type' => 'true_false',
			'instructions' => __('A notification email will be sent to the user after he has submitted a new ticket.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d28c39a0404',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 1,
			'message' => __('Enable','sunticket'),
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_57d28c81a0405',
			'label' => __('User - Reply by admin notification','sunticket'),
			'name' => 'swss_user_reply_by_admin_notification',
			'type' => 'true_false',
			'instructions' => __('A notification email will be sent to the user whenever an admin replies to his ticket.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d28c39a0404',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 1,
			'message' => __('Enable','sunticket'),
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_57d28cf0a0406',
			'label' => __('Admin - Email notifications','sunticket'),
			'name' => 'swss_admin_email_notifications',
			'type' => 'true_false',
			'instructions' => __('Enable admin email notifications.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 1,
			'message' => __('Enable','sunticket'),
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_57d28d2aa0407',
			'label' => __('Admin - New ticket submission notification','sunticket'),
			'name' => 'swss_admin_new_ticket_submission_notification',
			'type' => 'true_false',
			'instructions' => __('A notification email will be sent to the admin after an user has submitted a new ticket.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d28cf0a0406',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 1,
			'message' =>  __('Enable','sunticket'),
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_57d28d90a0408',
			'label' => __('Admin -	Reply by user notification','sunticket'),
			'name' => 'swss_admin_reply_by_user_notification',
			'type' => 'true_false',
			'instructions' => __('A notification email will be sent to the admin whenever an user replies to his ticket.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_57d28cf0a0406',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 1,
			'message' =>  __('Enable','sunticket'),
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_57d3d61a3ae48',
			'label' => __('Custom admin recipients','sunticket'),
			'name' => 'swss_admin_custom_email_recipiens',
			'type' => 'text',
			'instructions' => __('By default sends admin email notifications to the default WordPress admin email address. You can override this behaviour by specifing one or more email addresses in the following text are. In case of multiple recipients, separate email addresses with commas.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => 'admin@yoursite.com, shop_manager@yoursite.com',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5a66f6ca6de96',
			'label' => __('Disable email header and footer','sunticket'),
			'name' => 'swss_disable_email_header_and_footer',
			'type' => 'true_false',
			'instructions' => __('If you are experiencing any layout issue due to a 3rd party email customizer plugin, try disable the email header and footer rendering.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5a66fb598baa6',
			'label' => __('Email from address','sunticket'),
			'name' => 'wcst_email_from_address',
			'type' => 'email',
			'instructions' => __('By default as notification from email address will be used <i>noprely@\'yourdomain\'</i>. You can however customize using this option. Leave empty to use the default one.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-options',
			),
		),
	),
	'menu_order' => 2,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5cee5d9a2c70b',
	'title' => __('Sunticket – Options: Pay per ticket','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_5cee5daf526dc',
			'label' => __('Disable payment detection','sunticket'),
			'name' => 'swss_ppt_disable_payment_detection',
			'type' => 'true_false',
			'instructions' => __('<p>By default Pay Per Tickets will be available only after a payment is detected. In case of a not automatic payment method (like "checks" or "cash on delivery"), WooCommerce	considers the payment as perfromed once the checkout is completed. So tickets will be available just after the checkout has been even if they have been actually paid.</p>
<p>Disabling the payment detection will make the Pay Per Tickets available only when the order hits the <strong>Completed</strong> status (so you can make sure orders have been paid).</p>','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-options',
			),
		),
	),
	'menu_order' => 2,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_5b961d6f32570',
	'title' => __('Sunticket – Texts: Automatic ticket first message','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_5b961d9fc01ae',
			'label' => __('First message','sunticket'),
			'name' => 'swss_automatic_ticket_first_message',
			'type' => 'wysiwyg',
			'instructions' => __('When an automatick ticket is opened you can optionally send a first message to the user. Leave empty if you don\'t want to send any first message.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-texts',
			),
		),
	),
	'menu_order' => 2,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_57d2ac98d4a98',
	'title' => __('Sunticket - Texts: emails sent to User','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57d2abe7b351f',
			'label' => __('User - New ticket email subject (Order ticket type)','sunticket'),
			'name' => 'swss_user_new_ticket_subject_text',
			'type' => 'text',
			'instructions' => __('This is the subject used for the notification email sent to the user after he has placed a new ticket. You can use the special <strong>{ticket_id}</strong> to display the ticket id.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('New ticket #{ticket_id} submitted','sunticket'),
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_57d2ac9d7b149',
			'label' => __('User - New ticket email body (Order ticket type)','sunticket'),
			'name' => 'swss_user_new_ticket_email_body_message',
			'type' => 'wysiwyg',
			'instructions' => __('This is the email body used for the notification email sent to the user after he has placed a new ticket. You can use the special <strong>{order_page_url}</strong>, <strong>{ticket_id}</strong>, <strong>{subject}</strong> and <strong>{message}</strong> shotcodes in the message body to embed the ticket details page link, display the ticket id, ticket subject and the message replied by the admin.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('Thank you for contacting us. You ticket has been received, we will contact you back as soon as possible.','sunticket'),
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
		),
		array(
			'key' => 'field_57d2b0b80e885',
			'label' => __('User - New reply by admin email subject (Order ticket type)','sunticket'),
			'name' => 'swss_user_new_reply_by_admin_email_subject_text',
			'type' => 'text',
			'instructions' => __('This is the subject used for the notification email sent to the user after an admin has replyed to his ticket. You can use the special <strong>{ticket_id}</strong> to display the ticket id.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('New reply to ticket #{ticket_id}','sunticket'),
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_57d2b0f60e886',
			'label' => __('User - New reply by admin email body (Order ticket type)','sunticket'),
			'name' => 'swss_user_new_reply_by_admin_email_body',
			'type' => 'wysiwyg',
			'instructions' => __('This is the email body used for the notification email sent to the user after an admin has replied to his ticket.	You can use the special <strong>{order_page_url}</strong>, <strong>{ticket_id}</strong>, <strong>{subject}</strong> and <strong>{message}</strong> shotcodes	in the message body to embed the ticket details page link, display the ticket id and the message replied by the admin.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('The admin has replied to your ticket:

<i>
{message}
</i>
<br/>
Reply by clicking on the following link: {order_page_url}','sunticket'),
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
		),
		array(
			'key' => 'field_58b7db3c7b32a',
			'label' => __('User - New ticket email subject (User ticket type)','sunticket'),
			'name' => 'swss_user_new_ticket_subject_text_user_type',
			'type' => 'text',
			'instructions' => __('This is the subject used for the notification email sent to the user after he has placed a new ticket. You can use the special <strong>{ticket_id}</strong> to display the ticket id.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('New ticket #{ticket_id} submitted','sunticket'),
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_58b7db567b32b',
			'label' => __('User - New ticket email body (User ticket type)','sunticket'),
			'name' => 'swss_user_new_ticket_email_body_message_user_type',
			'type' => 'wysiwyg',
			'instructions' => __('This is the email body used for the notification email sent to the user after he has placed a new ticket. You can use the special, <strong>{ticket_page_url}</strong> (My Account -> User ticket area page), <strong>{ticket_id}</strong>, <strong>{subject}</strong> and <strong>{message}</strong> shotcodes in the message body to embed the ticket details page link, display the ticket id, ticket subject and the message replied by the admin.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('Thank you for contacting us. You ticket has been received, we will contact you back as soon as possible.','sunticket'),
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
		),
		array(
			'key' => 'field_58b7db6c7b32c',
			'label' => __('User - New reply by admin email subject (User ticket type)','sunticket'),
			'name' => 'swss_user_new_reply_by_admin_email_subject_text_user_type',
			'type' => 'text',
			'instructions' => __('This is the subject used for the notification email sent to the user after an admin has replyed to his ticket. You can use the special <strong>{ticket_id}</strong>to display the ticket id.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('New reply to ticket #{ticket_id}','sunticket'),
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_58b7db857b32d',
			'label' => __('User - New reply by admin email body (User ticket type)','sunticket'),
			'name' => 'swss_user_new_reply_by_admin_email_body_user_type',
			'type' => 'wysiwyg',
			'instructions' => __('This is the email body used for the notification email sent to the user after an admin has replied to his ticket.	You can use the special <strong>{ticket_page_url}</strong> (My Account -> User ticket area page), <strong>{ticket_id}</strong>, <strong>{subject}</strong> and <strong>{message}</strong> shotcodes	in the message body to embed the ticket details page link, display the ticket id and the message replied by the admin.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('The admin has replied to your ticket:

<i>
{message}
</i>','sunticket'),
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-texts',
			),
		),
	),
	'menu_order' => 3,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

acf_add_local_field_group(array(
	'key' => 'group_59008adf19314',
	'title' =>__( 'Sunticket – Automatic ticket','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_5901ae40a7bf4',
			'label' => __('Open automatically a ticket when an order hits a particular status?','sunticket'),
			'name' => 'swss_open_ticket_automatically',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5901ae8aa7bf5',
			'label' => __('Select for which order status','sunticket'),
			'name' => 'swss_automatic_ticket_order_status',
			'type' => 'order_staus_selector',
			'instructions' => __('When the order will hit the selected statuses, a ticket will automtaically opened.','sunticket'),
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_5901ae40a7bf4',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-options',
			),
		),
	),
	'menu_order' => 3,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));


/* adding user signature start */

$current_user = wp_get_current_user();
if ( 0 != $current_user->ID ){
$swss_user_id = $current_user->ID;
acf_add_local_field_group(array(
	'key' => 'group_76038gcf19809',
	'title' =>__( 'Sunticket – User Signature','sunticket'),
	'fields' => array(
	array(
			'key' => 'field_2301ab30a7ct9',
			'label' => __('User Signature','sunticket'),
			'name' => 'swss_active_user_signature_'.$swss_user_id,
			'type' => 'true_false',
			'instructions' => __('If this field is enabled, the signature text will be added at the end of the support user response.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		
	array(
			'key' => 'field_981ab30a7cd7',
			'label' => __('User Text Signature','sunticket'),
			'name' => 'swss_user_sign_text_'.$swss_user_id,
			'type' => 'wysiwyg',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_2301ab30a7ct9',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => "",
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-options',
			),
		),
	),
	'menu_order' => 3,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));
}
/* adding user signature end */


/* adding floating button setting start */

acf_add_local_field_group(array(
	'key' => 'group_12038gdf19303',
	'title' =>__( 'Sunticket – Floating Button','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_1101ab30a7bt6',
			'label' => __('Floating Support Button','sunticket'),
			'name' => 'swss_active_floating_btn',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_2101ah1aa7bx5',
			'label' => __('Title','sunticket'),
			'name' => 'swss_floating_btn_title',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_1101ab30a7bt6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
		array(
			'key' => 'field_18c4405483c6z',
			'label' => __('Position','sunticket'),
			'name' => 'swss_floating_btn_position',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_1101ab30a7bt6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'multiple' => 0,
			'allow_null' => 0,
			'choices' => array(
				'topleft' =>     __('Top Left','sunticket'),
				'topright' =>    __('Top Right','sunticket'),
				'bottomleft' =>  __('Bottom Left','sunticket'),
				'bottomright' => __('Bottom Right','sunticket'),
			),
			'default_value' => array(
				0 => 'bottomright',
			),
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'return_format' => 'value',
		),
		array(
			'key' => 'field_2601am1aa7hy5',
			'label' => __('Top/Bottom Offset','sunticket'),
			'name' => 'swss_top_btm_offset',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_1101ab30a7bt6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
		array(
			'key' => 'field_2301ay1ua7xy5',
			'label' => __('Left/Right Offset','sunticket'),
			'name' => 'swss_left_right_offset',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_1101ab30a7bt6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
		
		array(
			'key' => 'field_1101ae4aa7bf6',
			'label' => __('Background Color','sunticket'),
			'name' => 'swss_floating_btn_bgcolor',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_1101ab30a7bt6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
		
		array(
			'key' => 'field_1701ae3aa7bl9',
			'label' => __('Background Color Hover','sunticket'),
			'name' => 'swss_floating_btn_bgcolor_hover',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_1101ab30a7bt6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
		
		
		array(
			'key' => 'field_1201ae6aa7bc2',
			'label' => __('Color','sunticket'),
			'name' => 'swss_floating_btn_color',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_1101ab30a7bt6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
		array(
			'key' => 'field_1401ab1aa7bf2',
			'label' => __('Hover Color','sunticket'),
			'name' => 'swss_floating_btn_color_hover',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_1101ab30a7bt6',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '25',
				'class' => '',
				'id' => '',
			),
			'return_value' => 'name',
			'allowed_order_statuses' => '',
			'field_type' => 'checkbox',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-options',
			),
		),
	),
	'menu_order' => 3,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));
/* adding floating button setting end */

acf_add_local_field_group(array(
	'key' => 'group_58b7d9ce4580e',
	'title' => __('Sunticket - Texts: emails sent to Admin','sunticket'),
	'fields' => array(
		array(
			'key' => 'field_57d2b1e50e887',
			'label' => __('Admin - New ticket submitted by user email subject','sunticket'),
			'name' => 'swss_admin_new_ticket_subject_text',
			'type' => 'text',
			'instructions' => __('This is the subject used for the notification email sent to the admin after an user has submitted a ticket. You can use the special {ticket_id} to display the ticket id.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('New ticket #{ticket_id} submitted','sunticket'),
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_57d2b2550e888',
			'label' => __('Admin - New ticket submitted by user email body','sunticket'),
			'name' => 'swss_admin_new_ticket_email_body_message',
			'type' => 'wysiwyg',
			'instructions' => __('This is the email body used for the notification email sent to the user after an admin has replied to his ticket.	You can use the special <strong>{admin_ticket_page}</strong>, <strong>{ticket_id}</strong>, <strong>{subject}</strong> and <strong>{message}</strong> shotcodes in the message body to embed the ticket details page link, display the ticket id and the message replied by the admin.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('The user has submitted a new ticket:
<h3>Ticket subject</h3>
<i>
{subject}
</i>
<h3>Message</h3>
<i>
{message}
</i>
<br/>
Reply by clicking on the following link: {admin_ticket_page}','sunticket'),
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
		),
		array(
			'key' => 'field_57d2b2ce0e889',
			'label' => __('Admin - New reply by user email subject','sunticket'),
			'name' => 'swss_admin_new_reply_by_user_email_subject_text',
			'type' => 'text',
			'instructions' => __('This is the subject used for the notification email sent to the admin after an user has replied to a ticket. You can use the special {ticket_id} to display the ticket id.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('New reply from user to ticket #{ticket_id}','sunticket'),
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_57d2b3150e88a',
			'label' => __('Admin - New reply by user email body','sunticket'),
			'name' => 'swss_admin_new_reply_by_user_email_body',
			'type' => 'wysiwyg',
			'instructions' => __('This is the email body used for the notification email sent to the user after an admin has replied to his ticket.	You can use the special <strong>{admin_ticket_page}</strong>, <strong>{ticket_id}</strong>, <strong>{subject}</strong> and <strong>{message}</strong> shotcodes in the message body to embed the ticket details page link, display the ticket id and the message replied by the admin.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('The user has replied to your ticket:
<h3>Ticket subject</h3>
<i>
{subject}
</i>
<h3>Message</h3>
<i>
{message}
</i>
<br/>
Reply by clicking on the following link: {admin_ticket_page}','sunticket'),
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
		),
		array(
			'key' => 'field_5889ab35ef424',
			'label' => __('Admin - New ticket assigned email subject','sunticket'),
			'name' => 'swss_admin_new_ticket_assigned_email_subject_text',
			'type' => 'text',
			'instructions' => __('This is the subject used for the notification email sent to the user to whom has been assigned the ticket. You can use the special {ticket_id} to display the ticket id.','sunticket'),
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('Following tickets have been assigned: {ticket_id}','sunticket'),
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_5889ababef425',
			'label' => __('Admin - New ticket assigned email body','sunticket'),
			'name' => 'swss_admin_new_ticket_assigned_email_body',
			'type' => 'wysiwyg',
			'instructions' => __('This is the email body used for the notification email sent to the user when a new ticket has been assigned.	You can use the special <strong>{ticket_id}</strong>,<strong>{admin_ticket_page}</strong> shortcodes in the message body to display the ticket id and the ticket details page link.','sunticket'),
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => __('Following tickets have been assigned: {ticket_id}. <br/>
Reply by clicking on the following link(s): {admin_ticket_page}','sunticket'),
			'tabs' => 'all',
			'toolbar' => 'basic',
			'media_upload' => 0,
			'delay' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'options_page',
				'operator' => '==',
				'value' => 'acf-options-ticket-system-texts',
			),
		),
	),
	'menu_order' => 4,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
));

endif;
?>