<?php
/**
 * Force user to enter their mobile number
 * author: Javad Pourshahabadi
 * creation date: 1403-08-10
 **/

add_action('wp_footer','sc_compulsion_mobile_num');
function sc_compulsion_mobile_num(){
    
    if ( !is_user_logged_in() ) {
	    return;
    }
    
    // Get the current user ID
    $user_id = get_current_user_id();

    // Get the user mobile from your custom table
    global $wpdb;
    $table_name = $wpdb->prefix . 'sc_otp_tbl';
    $user_mobile = $wpdb->get_var($wpdb->prepare("SELECT mobile_number FROM $table_name WHERE user_id = %d", $user_id));
    
    if(!$user_mobile){
        
        wp_enqueue_script('compulsion_mobile_number', plugin_dir_url(__FILE__) . 'js/compulsion_mobile_number.js', array('jquery'), '1.0', true);
        wp_localize_script('compulsion_mobile_number', 'cmn_ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
        
        $compulsion_mob = 0;
        if ( class_exists( 'Redux') ) {
            $compulsion_mob   = codebean_option('compulsion_mobile_num');
        }
        if($compulsion_mob == 1){
           
           ?>
           <style>
               .compulsion_mobile_num_holder { position: fixed; left: 0; right: 0; top: 0; bottom: 0; z-index: 10000000000000000000000000000000000000; background: #0000009e; padding: 10px; justify-content: center; align-items: center; display: flex; }
               .cmn_content { max-width: 400px; margin: 0 auto; background: #ffffff; padding: 10px; border-radius: 5px; }
               div#sc_cmn_phone_message { position: relative; min-height: 40px; align-content: center; }
               @keyframes sc_otp_spinner {      to {transform: rotate(360deg);}    }
               .sc_otp_spinner:before { content: ''; box-sizing: border-box; position: absolute; top: 50%; left: 50%; width: 20px; height: 20px; margin-top: -10px; margin-left: -10px; border-radius: 50%; border: 1px solid #f6f; border-top-color: #0e0; border-right-color: #0dd; border-bottom-color: #f90; animation: sc_otp_spinner .6s linear infinite; }
                .cmn_phone_sbtn,.cmn_phone_vcheck { min-width: 48%; }
                .cmn_phone_sbtn.sc_cmn_timer_on { background: gainsboro; }
           </style>
           <div class="compulsion_mobile_num_holder">
               <div class="cmn_content">
                   <p class="mb-30"><?php echo  __('Please enter your mobile number to get access to site','studiare-core'); ?></p>
                    <label style="display:none;" for="cmn_phone"><?php echo __('Phone Number', 'studiare-core'); ?>:</label>
                    <input class="mb-30" type="text" name="cmn_phone" id="cmn_phone" placeholder="<?php echo __('Mobile Number', 'studiare-core'); ?>" required>
                    <input style="display:none;" class="mb-30" type="text" name="cmn_phone_otp" id="cmn_phone_otp" placeholder="<?php echo __('OTP', 'studiare-core'); ?>" required>
                   <button class="button cmn_phone_sbtn" type="submit" data-mtitle="<?php echo __('Send Verification Code', 'studiare-core'); ?>" data-countertxt="<?php echo __('Seconds', 'studiare-core'); ?>"><?php echo __('Send Verification Code', 'studiare-core'); ?></button>
                   <button style="display:none;" class="button cmn_phone_vcheck" type="submit"><?php echo __('Submit mobile number', 'studiare-core'); ?></button>
                   <div id="sc_cmn_phone_message" ></div>
               </div>
           </div>
           
           <?php
        }
    
    }
    
}


//Ajax part
add_action('wp_ajax_sc_compulsion_mobile_number_act', 'sc_compulsion_mobile_number_act');
add_action('wp_ajax_nopriv_sc_compulsion_mobile_number_act', 'sc_compulsion_mobile_number_act');
function sc_compulsion_mobile_number_act(){
    
    $cmn_phone   = $_POST['cmn_phone'];
    // Validate the phone number before proceeding
    $validated_phone = sc_validate_phone_number($cmn_phone);
    if (!$validated_phone) {
        wp_send_json_error(array('message' => __('Invalid phone number.', 'studiare-core')));
        return;
    }
    
    //check if mobile number is used by other account
    global $wpdb;
    $table_name   = $wpdb->prefix . 'sc_otp_tbl';
    $check_number = $wpdb->get_var($wpdb->prepare("SELECT user_id FROM $table_name WHERE mobile_number = %d", $validated_phone));
    if($check_number){
        wp_send_json_error(array('message' => __('Mobile number is in use by another account.', 'studiare-core')));
        return;
    }
    
    
    //wp_send_json_error(array('message' => __('send timer on', 'studiare-core')));
    //return;
    // Call your SMS provider's API to send the verification code
    $apiResponse = sc_call_sms_provider_api($validated_phone);
    $apiResponse = json_decode($apiResponse, true);
    
    if ($apiResponse['status'] === 'ارسال موفق بود') {
        $otp = $apiResponse['code'];
        
        $expiration_time = date('Y-m-d H:i:s', strtotime('+2 minutes')); // Set expiration time for 2 minutes
        // Get the current user ID
        $user_id = get_current_user_id();
        $check_user_id = $wpdb->get_var($wpdb->prepare("SELECT * FROM $table_name WHERE user_id = %d", $user_id));
        if ($check_user_id) {
            
            // Update the existing record
            $wpdb->update($table_name, array(
                'verify_code' => $otp,
                'code_expiration_time' => $expiration_time
            ), array('user_id' => $user_id));
            
        }else{
            
            // Insert new record
            $wpdb->insert($table_name, array(
                'user_id' => $user_id,
                'verify_code' => $otp,
                'code_expiration_time' => $expiration_time,
            ));
            
        }
        wp_send_json_success(array('message' => __('Verification code sent successfully.', 'studiare-core')));
    }else{
        wp_send_json_error(array('message' => __('Failed to send verification code.', 'studiare-core')));
    }
    

}


add_action('wp_ajax_sc_compulsion_mobile_number_save_to_db', 'sc_compulsion_mobile_number_save_to_db');
add_action('wp_ajax_nopriv_sc_compulsion_mobile_number_save_to_db', 'sc_compulsion_mobile_number_save_to_db');
function sc_compulsion_mobile_number_save_to_db(){
    
    $cmn_phone   = $_POST['cmn_phone'];
    $cmn_phone_otp   = $_POST['cmn_phone_otp'];
    // Validate the phone number before proceeding
    $validated_phone = sc_validate_phone_number($cmn_phone);
    if (!$validated_phone) {
        wp_send_json_error(array('message' => __('Invalid phone number.', 'studiare-core')));
        return;
    }
    
    global $wpdb;
    $table_name   = $wpdb->prefix . 'sc_otp_tbl';
    
    // Get the current user ID
    $user_id = get_current_user_id();
    $check_user_id     = $wpdb->get_var($wpdb->prepare("SELECT * FROM $table_name WHERE user_id = %d", $user_id));
    $check_used_number = $wpdb->get_var($wpdb->prepare("SELECT * FROM $table_name WHERE mobile_number = %d", $validated_phone));
    
    // Fetch latest OTP details
    $otp_info = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table_name WHERE user_id = %s ORDER BY id DESC LIMIT 1", $user_id));
    if ($otp_info) {
        // Check if the code matches and ensure it's not expired
        if ($otp_info->verify_code === $cmn_phone_otp && new DateTime() < new DateTime($otp_info->code_expiration_time)) {
            
            if(!$check_used_number){
                if ($check_user_id) {
                    // Update the existing record
                    $wpdb->update($table_name, array(
                        'mobile_number' => $validated_phone,
                    ), array('user_id' => $user_id));
                    
                    wp_send_json_success(array('message' => __('Your mobile number updated successfully.', 'studiare-core')));
                } else {
                    // Insert new record
                    $wpdb->insert($table_name, array(
                        'mobile_number' => $validated_phone,
                        'user_id' => $user_id,
                    ));
                    wp_send_json_success(array('message' => __('Your mobile number submitted successfully.', 'studiare-core')));
                }
            }else{
                 wp_send_json_error(array('message' => __('Mobile number is in use by another account.', 'studiare-core')));
            }
            
        }
        else {
            wp_send_json_error(array('message' => __('Invalid or expired OTP', 'studiare-core')));
        }
    }
    else {
        wp_send_json_error(array('message' => __('No OTP found for this mobile number', 'studiare-core')));
    }
    /*
    
    */
    
}