(function($) {
    // Flag to track if a quiz is active (for beforeunload warning)
    var isQuizActive = false;
    var timerInterval = null;

    function initializeQuiz($quiz) {
        var quizId = $quiz.attr('id').replace('studiare-quiz-', '');
        var pid = $quiz.attr('pid');//javad
        var $startCountdown = $quiz.find('#quiz-start-countdown-' + quizId);
        var $startButton = $quiz.find('.start-quiz-button');
        var $content = $quiz.find('#quiz-content-' + quizId);

        // Initialize start countdown if it exists
        if ($startCountdown.length) {
            var startTime = $startCountdown.data('start-time');
            if (startTime) {
                try {
                    // Parse the date in mm/dd/YYYY HH:MM format
                    var dateParts = startTime.match(/(\d{2})\/(\d{2})\/(\d{4}) (\d{2}):(\d{2})/);
                    if (dateParts) {
                        // Create a Date object (month is 0-based in JavaScript, so subtract 1)
                        var startDate = new Date(dateParts[3], dateParts[1] - 1, dateParts[2], dateParts[4], dateParts[5]);
                        if (!isNaN(startDate.getTime())) {
                            $startCountdown.countdown(startDate)
                                .on('update.countdown', function(event) {
                                    // Update countdown display
                                    $startCountdown.find('.countdown-days').text(event.strftime('%-D'));
                                    $startCountdown.find('.countdown-hours').text(event.strftime('%H'));
                                    $startCountdown.find('.countdown-minutes').text(event.strftime('%M'));
                                    $startCountdown.find('.countdown-seconds').text(event.strftime('%S'));
                                })
                                .on('finish.countdown', function() {
                                    // Refresh the page to show the quiz
                                    window.location.reload();
                                });
                        }
                    }
                } catch (e) {}
            }
        }

        // Handle start button click with AJAX
        $startButton.on('click', function() {
            $startButton.prop('disabled', true); // Disable button to prevent multiple clicks

            $.ajax({
                url: window.studiareQuiz && window.studiareQuiz.ajaxurl ? window.studiareQuiz.ajaxurl : '/wp-admin/admin-ajax.php',
                type: 'POST',
                data: {
                    action: 'studiare_load_quiz_content',
                    quiz_id: quizId,
                    pid: pid,//javad
                },
                success: function(response) {
                    if (response.success) {
                        // Hide start button and show content
                        $startButton.parent('.quiz-start').hide();
                        $content.html(response.data.html).show();

                        // Initialize quiz content (timer, pagination, form submission)
                        initializeQuizContent($quiz, quizId);
                    } else {
                        $content.html('<p>' + response.data.message + '</p>').show();
                    }
                    $startButton.prop('disabled', false); // Re-enable button
                },
                error: function() {
                    $content.html('<p>' + (window.studiareQuiz && window.studiareQuiz.start_error ? window.studiareQuiz.start_error : 'Cannot start quiz.') + '</p>').show();
                    $startButton.prop('disabled', false); // Re-enable button
                }
            });
        });
    }

    function initializeQuizContent($quiz, quizId) {
        var $content = $quiz.find('#quiz-content-' + quizId);
        var $pages = $content.find('.quiz-page');
        var $prevButton = $content.find('#quiz-prev-page-' + quizId);
        var $nextButton = $content.find('#quiz-next-page-' + quizId);
        var $submitButton = $content.find('#quiz-submit-' + quizId);
        var $form = $content.find('#quiz-form-' + quizId);
        var $timer = $quiz.find('#quiz-timer-' + quizId);
        var currentPage = 0;

        // Pagination logic
        function updatePagination() {
            $pages.hide();
            $pages.eq(currentPage).show();
            $prevButton.prop('disabled', currentPage === 0);
            $nextButton.toggle(currentPage < $pages.length - 1);
            $submitButton.toggle(currentPage === $pages.length - 1);
        }

        if ($pages.length) {
            updatePagination();
        }

        $prevButton.on('click', function() {
            if (currentPage > 0) {
                currentPage--;
                updatePagination();
            }
        });

        $nextButton.on('click', function() {
            if (currentPage < $pages.length - 1) {
                currentPage++;
                updatePagination();
            }
        });

        // Initialize timer if it exists
        if ($timer.length) {
            var seconds = parseInt($timer.data('timer-seconds'), 10);
            var $display = $timer.find('.timer-display');
            
            if (seconds > 0) {
                isQuizActive = true; // Set quiz as active for beforeunload warning

                // Start a simple countdown timer
                timerInterval = setInterval(function() {
                    if (seconds <= 0) {
                        clearInterval(timerInterval);
                        $display.html('<span class="timer-minutes">00</span>:<span class="timer-seconds">00</span>');
                        isQuizActive = false; // Quiz is no longer active
                        // Auto-submit the quiz when time is up
                        $form.submit();
                        return;
                    }

                    var minutes = Math.floor(seconds / 60);
                    var remainingSeconds = seconds % 60;
                    $display.html(
                        '<span class="timer-minutes">' + (minutes < 10 ? '0' + minutes : minutes) + '</span>:' +
                        '<span class="timer-seconds">' + (remainingSeconds < 10 ? '0' + remainingSeconds : remainingSeconds) + '</span>'
                    );
                    seconds--;
                }, 1000);
            }
        }

        // Prevent page refresh or close while quiz is active
        $(window).on('beforeunload.quiz-' + quizId, function(e) {
            if (isQuizActive) {
                var message = 'Are you sure you want to leave? Your quiz progress will be lost.';
                e.returnValue = message; // Standard for most browsers
                return message; // For some older browsers
            }
        });

        // Handle form submission
        $form.on('submit', function(e) {
            e.preventDefault();

            // Stop the timer if it exists
            if (timerInterval) {
                clearInterval(timerInterval);
                isQuizActive = false; // Quiz is no longer active
                $(window).off('beforeunload.quiz-' + quizId); // Remove beforeunload handler
            }

            // Submit the form
            $.ajax({
                url: window.studiareQuiz && window.studiareQuiz.ajaxurl ? window.studiareQuiz.ajaxurl : '/wp-admin/admin-ajax.php',
                type: 'POST',
                data: {
                    action: 'studiare_quiz_submit',
                    form_data: $form.serialize()
                },
                success: function(response) {
                    if (response.success) {
                        $('#quiz-result-' + quizId).html(response.data.html);
                    } else {
                        $('#quiz-result-' + quizId).html('<p>' + response.data.message + '</p>');
                    }
                    $form.hide();
                    $timer.hide();
                },
                error: function() {
                    alert(window.studiareQuiz && window.studiareQuiz.error_message ? window.studiareQuiz.error_message : 'Error submitting quiz.');
                }
            });
        });
        // Add selected class to label of checked radio
        $content.on('change', 'input[type="radio"]', function () {
            var name = $(this).attr('name');
            // Remove 'selected' class from all related labels
            $content.find('input[name="' + name + '"]').each(function () {
                $(this).closest('label').removeClass('selected');
            });
            // Add 'selected' class to the currently checked one
            $(this).closest('label').addClass('selected');
        });

    }

    // Initialize accordion for quiz results
    function initializeAccordion() {
        // Remove any existing click handlers to prevent multiple bindings
        $('.quiz-results-accordion .sc-accordion-toggle').off('click.accordion');

        // Bind click event with a namespace
        $('.quiz-results-accordion .sc-accordion-toggle').on('click.accordion', function(e) {
            e.preventDefault(); // Prevent default button behavior
            e.stopPropagation(); // Prevent event bubbling

            var $this = $(this);
            var $content = $this.next('.accordion-content');

            // Toggle accordion
            $this.toggleClass('active');
            $content.slideToggle(300).toggleClass('active');
        });
    }

    // Initialize existing quizzes
    $('.studiare-quiz').each(function() {
        var $quiz = $(this);
        if (!$quiz.data('quiz-initialized')) {
            initializeQuiz($quiz);
            $quiz.data('quiz-initialized', true);
        }
    });

    // Initialize accordion on page load
    $(document).ready(function() {
        initializeAccordion();
    });

    // Support dynamic loading (e.g., Elementor AJAX, tabs)
    $(document).on('DOMContentLoaded elementor/popup/show elementor/tabs/activate', function() {
        $('.studiare-quiz').each(function() {
            var $quiz = $(this);
            if (!$quiz.data('quiz-initialized')) {
                initializeQuiz($quiz);
                $quiz.data('quiz-initialized', true);
            }
        });
        // Re-initialize accordion for dynamically loaded content
        initializeAccordion();
    });

    // Handle quiz result details in modal via AJAX
    $(document).on('click', '.quiz-result-details', function(e) {
        e.preventDefault();
        e.stopPropagation();

        var $this = $(this);
        var resultId = $this.data('result-id');
        var modal = $('#quiz-result-details-modal');
        var modalContent = $('#quiz-result-details-content');

        // Show loading message
        modalContent.html('<p>Loading...</p>');

        // Show modal and scroll to it
        modal.show();
        window.scrollTo({ top: 0, behavior: 'smooth' });

        // AJAX request to load details
        $.ajax({
            url: window.studiareQuiz && window.studiareQuiz.ajaxurl ? window.studiareQuiz.ajaxurl : '/wp-admin/admin-ajax.php',
            type: 'POST',
            data: {
                action: 'studiare_load_quiz_result_details',
                result_id: resultId,
                user_id: $this.closest('.studiare-quiz-results').data('user-id') || 0
            },
            success: function(response) {
                if (response.success) {
                    modalContent.html(response.data.html);
                    // Re-initialize accordion for any accordions inside modal
                    initializeAccordion();
                } else {
                    modalContent.html('<p>Error loading details.</p>');
                }
            },
            error: function() {
                modalContent.html('<p>Error loading details.</p>');
            }
        });
    });

    // Close modal when clicking the close button
    $(document).on('click', '.quiz-modal-close', function() {
        $('#quiz-result-details-modal').hide();
    });

    // Close modal when clicking outside of it
    $(window).on('click', function(event) {
        var modal = $('#quiz-result-details-modal');
        if (event.target == modal[0]) {
            modal.hide();
        }
    });

    // Handle "Show All Attempts" toggle inside the modal
    $(document).on('click', '.show-all-attempts', function() {
        var attemptsId = $(this).data('attempts-id');
        var $attemptsDetails = $('#attempts-details-' + attemptsId);
        if ($attemptsDetails.is(':visible')) {
            $attemptsDetails.hide();
            $(this).text(window.studiareQuiz.show_all_attempts_text || 'Show All Attempts');
        } else {
            $attemptsDetails.show();
            $(this).text(window.studiareQuiz.hide_attempts_text || 'Hide Attempts');
        }
    });

})(jQuery);