<?php
/**
 * Plugin Name: Studiare Messages
 * Plugin URI: https://studiaretheme.ir/
 * Description: Adding chat to studiare core
 * Author: Suncode
 * Author URI: https://studiaretheme.ir/
 * Version: 1.0.0
 * License: GPL3
 * License URI: http://www.gnu.org/licenses/gpl-3.0.txt
 * Text Domain: studiare-core
 * Domain Path: /languages
 * @package stc
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if ( !class_exists( 'Studiare_Matching' ) ) {
    class Studiare_Matching { 
        public $functions;
        public $class;
        public $db;
        public $chat;
        public $chat_view;
        public $credits;
        
        public static function instance() {
            // Store the instance locally to avoid private static replication
            static $instance = null;
            // Only run these methods if they haven't been run previously
            if ( null === $instance ) {
                $instance = new Studiare_Matching();
            
                   $instance->setup_actions();
                   $instance->setup_classes(); 
              
                
            }
            // Always return the instance
            return $instance;
            // The last metroid is in captivity. The galaxy is at peace.
        }

        public function setup_actions() {

            $this->require_files();  
            
            //if(isset($_GET['tab']) && $_GET['tab'] == 'messages') {
               
                add_action('wp_enqueue_scripts', array($this, 'load_assets') ); 
                
            //}
            


        }
        

        
        public function load_assets() {
            
           
         
            $dependencies = apply_filters( 'stc_settings_script_dependencies', array('jquery','wp-i18n') );
          
            wp_enqueue_script(
                'toastify',
                plugins_url('/assets/js/lib/toastify.js', __FILE__),
                $dependencies,
                '1.0',
                true
            );
            
            wp_enqueue_script(
                'stc-chat',
                plugins_url('/assets/js/chat/chat.js', __FILE__),
                $dependencies,
                '1.0',
                true
            );
            
            wp_enqueue_script(
                'stc-chat-template',
                plugins_url('/assets/js/chat/chat_template.js', __FILE__),
                $dependencies,
                '1.0',
                true
            );
            
            wp_enqueue_script(
                'stc-chat-data',
                plugins_url('/assets/js/chat/chat_data.js', __FILE__),
                $dependencies,
                '1.0',
                true
            );

            
            wp_enqueue_script(
                'emojionearea',
                plugins_url('/assets/js/lib/emojionearea.min.js', __FILE__),
                $dependencies,
                '1.0',
                true
            );
         
            wp_enqueue_style('emojionearea', plugins_url('/assets/css/emojionearea.min.css', __FILE__),'stc-chat', '1.0' , 'all' );
            wp_enqueue_style('stc_front', plugins_url('/assets/css/stc-front.css', __FILE__),'stc-front', '1.0' , 'all' );
          
            $bp_emojionearea = array(
        		'recent'            => __( 'Recent', 'studiare-core' ),
        		'smileys_people'    => __( 'Smileys & People', 'studiare-core' ),
        		'animals_nature'    => __( 'Animals & Nature', 'studiare-core' ),
        		'food_drink'        => __( 'Food & Drink', 'studiare-core' ),
        		'activity'          => __( 'Activity', 'studiare-core' ),
        		'travel_places'     => __( 'Travel & Places', 'studiare-core' ),
        		'objects'           => __( 'Objects', 'studiare-core' ),
        		'symbols'           => __( 'Symbols', 'studiare-core' ),
        		'flags'             => __( 'Flags', 'studiare-core' ),
        		'tones'             => __( 'Diversity', 'studiare-core' ),
        		'searchPlaceholder' => __( 'Search', 'studiare-core' ),
        	);
        
        	wp_localize_script( 'emojionearea', 'bp_emojionearea', $bp_emojionearea );

            $url = stc_chat_page_url();
            
            //javad start
            $chat_emojies=false;
            $chat_gif=false;
            $chat_file=false;
            if ( class_exists('Redux')) {
                $chat_settings = get_option("codebean_option");
                $chat_gif     = $chat_settings['chat_gif'];
                $chat_file    = $chat_settings['chat_file'];
                $chat_emojies = $chat_settings['chat_emojies'];
            }
            //echo "salam $chat_emojies";
            //javad end 
            

            wp_localize_script(
        			'stc-chat',
        			'stc_chat',
        			array(
                       /*'media_size' => stc_theme_get_option('stc_chat_file_size'),
                       'chat_gift' => stc_theme_get_option('stc_chat_gift'),  
                       'chat_gif' => stc_theme_get_option('stc_chat_gif'),  
                       'chat_file' => stc_theme_get_option('stc_chat_file'),  javad */
                       
                       //'chat_gift' => $chat_emojies,  //javad 
                       'chat_gif' => $chat_gif,  //javad 
                       'chat_file' => $chat_file,  //javad 
                       'chat_emojies' => $chat_emojies,  //javad 
                       
                       'scsearchusers' => esc_html__('Search users','studiare-core'),//suncode  
					   'subject_placeholder' => esc_html__('Subject', 'studiare-core'),//suncode  
                        'create_conversation' => esc_html__('Create Conversation', 'studiare-core'),//suncode  
						'scdelete_text' => esc_html__('Delete', 'studiare-core'),//suncode  
						'screply_text' => esc_html__('Reply', 'studiare-core'),//suncode  
						'online_text'  => esc_html__('Online', 'studiare-core'),//suncode  
						'offline_text' => esc_html__('Offline', 'studiare-core'),//suncode  
						'participants_text' => esc_html__('Participants', 'studiare-core'),//suncode  
                       
                       'gif_text' => esc_html__('Gif','studiare-core'),
                       'gift_text' => esc_html__('Gift','studiare-core'),
                       'file_text' => esc_html__('File','studiare-core'),
                       'reply_text' => esc_html__('Reply to message','studiare-core'),
                       'edit_text' => esc_html__('Edit message','studiare-core'),
                       'confirm_delete_conversation_text' => esc_html__('You have already liked this message','studiare-core'),
                       'message_deleted_text' => esc_html__('This message was deleted','studiare-core'),
                       'user_removed_text' => esc_html__('User removed','studiare-core'),
                       'send' => esc_html__('Send','studiare-core'),
                       'search_gif' => esc_html__('Search GIPHY...','studiare-core'),
                       'delete_conversation' => esc_html__('Delete conversation','studiare-core'),
                       'Subject' => __('Subject','studiare-core'),
                       'unblock' => esc_html__('Unblock','studiare-core'),  
                       'block_report' => esc_html__('Block and report','studiare-core'),  
                       'chat_page' => $url,
                       'stc_nonce' => wp_create_nonce( 'stc_nonce_value' ),
                       'ajax_url'        => admin_url( 'admin-ajax.php' ),
        			)
        	);
            
            
            wp_set_script_translations( 'stc-chat-data' , 'studiare-core', CD_PLUGIN_PATH . 'languages/' );
            wp_set_script_translations( 'ws-chat-template' , 'studiare-core', CD_PLUGIN_PATH . 'languages/' );
            wp_set_script_translations( 'stc-chat' , 'studiare-core', CD_PLUGIN_PATH . 'languages/' );
      

        }

        public function require_files() { 
            
            // Admin
          
            require_once 'admin/table.php'; 
      
        
            require_once 'inc/template_function.php';  
            
            /* Chat */
            
            require_once 'inc/chat.php';  
            require_once 'inc/chat/template_vew.php'; 
            require_once 'inc/chat/chat_action.php'; 
            require_once 'inc/chat/function.php'; 
            require_once 'inc/chat/file_upload/class.php';
            
          
        }

        public function setup_classes() { 
            

            $this->db = Studiare_Matching_Db();
            $this->chat = Studiare_Dashboard_Chat();
            $this->chat_view = Studiare_Chat_View();
            
            Studiare_Chat_File();
            Studiare_Chat_Class();
        
        }


    }
}

function Studiare_Matching() {
    return Studiare_Matching::instance();
}

function Studiare_Matching_Init() { 

    Studiare_Matching();

}

add_action( 'plugins_loaded', 'Studiare_Matching_Init', 20 );

function activate_stc_matching() {
	Studiare_Matching()->db->create_table();
}


register_activation_hook( __FILE__, 'activate_stc_matching' );

define( 'CD_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'CD_PLUGIN_URL', plugin_dir_url( __FILE__ ) );

function Studiare_Matching_Domain() {
    //load_plugin_textdomain( 'studiare-core', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' ); 
}
//add_action( 'plugins_loaded', 'Studiare_Matching_Domain' );


/** by javad **/
add_action('wp_head', 'stc_check_user_activity');
function stc_check_user_activity() {
    
    if (is_user_logged_in()) {
        $user_id = get_current_user_id();
        update_user_meta($user_id, 'last_activity', current_time('timestamp'));
    }
    
}
function stc_avatar_default() {
    
    //$image = jws_theme_get_option('image_default');
    $return = CD_PLUGIN_URL . 'assets/image/img_avatar.png';
    if(isset($image['url']) && !empty($image['url'])) {
        $return = $image['url'];
    }

    return $return;
}

function stc_is_user_online($user_id) {
    $last_activity = get_user_meta($user_id, 'last_activity', true);
    $timeout = 3 * MINUTE_IN_SECONDS; 
    if (!$last_activity) {
        return false; 
    }

    return (current_time('timestamp') - $last_activity) <= $timeout;
}


/**
 * Add stc_chat chat page to WooCommerce My Account section
 */
function add_stc_chat_my_account_endpoint() {
    // First check if WooCommerce is active
    if (!class_exists('WooCommerce')) {
        return;
    }

    // Add rewrite endpoint
    add_rewrite_endpoint('chat', EP_ROOT | EP_PAGES);
    
    // Flush rewrite rules if this is the first time adding the endpoint
    if (!get_option('stc_chat_my_account_chat_endpoint_added')) {
        flush_rewrite_rules();
        update_option('stc_chat_my_account_chat_endpoint_added', true);
    }
}
add_action('init', 'add_stc_chat_my_account_endpoint');

/**
 * Add new query var for our endpoint
 */
function add_stc_chat_query_vars($vars) {
    $vars[] = 'chat';
    return $vars;
}
add_filter('woocommerce_get_query_vars', 'add_stc_chat_query_vars');

/**
 * Set endpoint title
 */
function set_stc_chat_endpoint_title($title) {
    if (is_wc_endpoint_url('chat')) {
        $title = __('Chat', 'studiare-core');
    }
    return $title;
}
add_filter('the_title', 'set_stc_chat_endpoint_title');

/**
 * Add menu item for our endpoint
 */
function add_stc_chat_my_account_menu_item($items) {
    // Place the chat item before logout
    $logout = $items['customer-logout'];
    unset($items['customer-logout']);
    
    $items['chat'] = __('Chat page', 'studiare-core');
    $items['customer-logout'] = $logout;
    
    return $items;
}
add_filter('woocommerce_account_menu_items', 'add_stc_chat_my_account_menu_item');

/**
 * Content for our endpoint
 */
function stc_chat_endpoint_content() {
    echo do_shortcode('[stc_chat]');
}
add_action('woocommerce_account_chat_endpoint', 'stc_chat_endpoint_content');
