<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       https://studiaretheme.ir
 * @since      1.0.0
 *
 * @package    Studiare_Dashboard_Notifications
 * @subpackage Studiare_Dashboard_Notifications
 */

class Studiare_Chat_Class {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**<!-- phpDesigner :: Timestamp -->12/21/2023 9:41:58 AM<!-- /Timestamp -->
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;
   
    public static function instance() {
            // Store the instance locally to avoid private static replication
            static $instance = null;
            // Only run these methods if they haven't been run previously
            if ( null === $instance ) {
                
                $instance = new Studiare_Chat_Class();
  
            }
            // Always return the instance
            return $instance;
            // The last metroid is in captivity. The galaxy is at peace.
     }

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct() {

       
  
       add_action('wp_ajax_stc_load_conversation_data', array($this , 'stc_load_conversation_data'));
       
       add_action('wp_ajax_stc_load_messages_data', array($this , 'stc_load_messages_data'));

       add_action('wp_ajax_stc_get_conversation_create', array($this , 'stc_get_conversation_create'));
       
       add_action('wp_ajax_nopriv_stc_get_conversation_create', array($this , 'stc_get_conversation_create'));
       
       add_action('wp_ajax_stc_get_conversation_create_multi', array($this , 'stc_get_conversation_create_multi'));

       add_action('wp_ajax_send_messages', array($this , 'send_messages'));
       
       add_action('wp_ajax_stc_messages_check_data', array($this , 'stc_messages_check_data'));
       
       add_action('wp_ajax_stc_like_message', array($this , 'stc_like_message'));
       
       add_action('wp_ajax_stc_delete_message', array($this , 'stc_delete_message'));

	}
    
      public function stc_delete_message() {
        
        
          $defaults  = array(
             'id' => '',
             'thread_id' => '',
		  );  
          $args = wp_parse_args( $_POST , $defaults );
      
          extract( $args );
          
       
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
     
          global $wpdb;
        
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
          
          $is_owner = stc_check_sender_id($id);
          
        
          if($is_owner) {
            
            stc_update_message_meta( $id , 'delete' , true );
   
          
             $message_data = stc_get_message_item_data($id);
   
            if($message_data) {
                
               $messages_data = $this->stc_messages_load_item_data($message_data);
               
            }
            
            $data = array(
          
                
                 'thread_id' => $thread_id,
                 'sender_id' => $this->stc_get_user_last($thread_id),
                 'user_start' => stc_check_start_conversation($thread_id),
                 'messages' => $messages_data,
               
    
             );
              
            wp_send_json_success($data); 
         
            
          }else {
            
            $errors->add(
                   'delete_err',
                   esc_html('The message is not from you.','studiare-core')
            );
            wp_send_json_error( $errors );
            
          }
          
          
        
    }
    
    public function stc_like_message() {
        
        
          $defaults  = array(
             'id' => '',
             'thread_id' => '',
		  );  
          $args = wp_parse_args( $_POST , $defaults );
      
          extract( $args );
          
       
       
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
     
          global $wpdb;
        
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
          
          $is_owner = stc_check_sender_id($id);
          
          $liked = stc_get_message_meta($id, 'liked');
          
          if($liked) {
            
            $errors->add(
                   'like_err',
                   esc_html('You have already liked this message','studiare-core')
            );
            wp_send_json_error( $errors );
            
          }
        
          if($is_owner) {
            
            stc_update_message_meta( $id , 'liked' , get_current_user_id() );
            
            $message = esc_html__('Message liked','studiare-core');
            
          
             $message_data = stc_get_message_item_data($id);
   
            if($message_data) {
                
               $messages_data = $this->stc_messages_load_item_data($message_data);
               
            }
            
            $data = array(
          
                
                 'thread_id' => $thread_id,
                 'sender_id' => $this->stc_get_user_last($thread_id),
                 'user_start' => stc_check_start_conversation($thread_id),
                 'messages' => $messages_data,
               
    
             );
              
            wp_send_json_success($data); 
        
          }else {
            
            $errors->add(
                   'delete_err',
                   esc_html('The message is not from you.','studiare-core')
            );
            wp_send_json_error( $errors );
            
          }
          
          
        
    }
    

     
     public function stc_messages_load_item_data($message) {  
                       $user_id = get_current_user_id(); 
                    $messages_data = array(
                        'id' => $message->id,
                        'is_me' => $message->sender_id == $user_id ? 'me' : 'orther',
                        'is_deleted' => stc_get_message_meta($message->id , 'delete'),
                        'sender_id' => $message->sender_id,
                        'content' => esc_html($message->message),
                        'time' => date_i18n('h:i A', $message->created_at),// date('h:i A', $message->created_at), javad
                        'reply' => $this->stc_get_messages_reply($message->id ),
                        'is_like' => stc_get_message_meta($message->id, 'liked'),
                        'last_date' => $message->created_at,
                        'display_time' => stc_get_time_messages($message->created_at),
                    
                    );
                    
                      
                   if($message->message == 'gift') {
                    
                      $meta = stc_get_message_meta($message->id , 'send_gift');
                      $image = get_post_meta($meta,'thumbnail',true);
                      $messages_data['gift'] = wp_get_attachment_image_url( $image, 'thumbnail' );
                      
                   
                   }elseif($message->message == 'gif') {
                       $meta = stc_get_message_meta($message->id , 'send_gif');
                       $gif_info = json_decode(stripslashes($meta), true);
                       $messages_data['gif'] = array(
                         'image_url' => $gif_info['image_url'],
                         'video_url' => $gif_info['video_url'],
                       );
                   } elseif($message->message == 'media') { 
                    
                      $meta = stc_get_message_meta($message->id , 'send_media');
                      $media = explode(",",$meta);
                      if(!empty($media)) {
                      
                         foreach($media as $id) {
                               
                              $messages_data['media'][] =  $this->get_attachment_file($id);
                               
                         }
                        
                      }
                      
                   }
                  
                  
                  return $messages_data;
        
     }
    
     public function stc_messages_check_data() { 
        
         $defaults  = array(
            'thread_id' => '',
            'last_date' => '',
            'conversation' => ''
         );  
         //   wp_send_json_success('no_data');
          $args = wp_parse_args( $_POST , $defaults );

          extract( $args );
          
          $user_id = get_current_user_id(); 
       
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
     
          global $wpdb;
        
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
          
     

          $data = array();
          
          $messages_data = [];
          
         
          $count = 0;
          if(!empty($conversation)) {
           
            foreach($conversation as $conversation_item) {
                
                 $messages = $this->stc_get_conversation_messages_realtime($conversation_item['thread_id'] ,$conversation_item['last_date']);
     
                 if($messages) {
                    
                   
                    
                   foreach($messages as $key => $message) { 
                         
                        if($user_id != $message->sender_id) { 
                            $count++;
                        }
                            
                        $messages_data[$key] = $this->stc_messages_load_item_data($message);
                          
                    
                   }  
               
        
                  $data[] = array(

                     'thread_id' => $conversation_item['thread_id'],
                     'sender_id' => $this->stc_get_user_last($conversation_item['thread_id']),
                     'user_start' => stc_check_start_conversation($conversation_item['thread_id']),
                     'recipients' => $this->stc_get_user_recipients($conversation_item['thread_id']),
                     'messages' => $messages_data,
                     'unread' => stc_get_messages_unread_count($conversation_item['thread_id'],$user_id),
                     'total_messages' => stc_get_messages_total_count($conversation_item['thread_id']), 
              
                  );
                 }
            }
          }
          
      
          
          if(empty($data)) {
            
             wp_send_json_success('no_data');
            
          }
          
          wp_send_json_success($data);
            
        
    }
    
    public function send_messages() { 
        
             
          $defaults  = array(
             'message_content' => '',
             'message_gift' => '',
             'message_gif' => '',
             'message_media' => '',
             'thread_id' => '',
             'action' => 'load',
             'reply_message' => ''
		  );  
          $args = wp_parse_args( $_POST , $defaults );
          $time = stc_get_microtime();
      
          extract( $args );
          
        
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
          
          
          $user_id = get_current_user_id();
          
          $rel_user = $this->stc_get_user_last($thread_id);
          
          global $wpdb;
        
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
  
 
          if(!empty($message_gif)) {
            
            $message_content = 'gif';
            
          }

          
          if(!empty($message_enmoji)) {
            
            $message_content = 'enmoji';
            
          }
          
          if(!empty($message_media)) {
            
            $message_content = 'media';
            
          }
          
          if ( empty($message_content) ) {
            
        		$errors->add(
                       'mess_miss',
                       esc_html('empty.','studiare-core')
                );
                wp_send_json_error( $errors );
                
          }
    
          
          $table_recipients = stc_get_table('recipients');
          $table_threads = stc_get_table('threads');
          $table_messages = stc_get_table('messages');
  
          $is_owner = stc_check_owner_conversation($thread_id);
            
                  
          if ( !$is_owner ) {
        		$errors->add(
                       'is_owner',
                       esc_html('You do not have permission to access.','studiare-core')
                );
                wp_send_json_error( $errors );
          }
       
          
    
          $wpdb->insert(
                $table_messages,
                array(
                    'thread_id' => $thread_id,
                    'sender_id' => get_current_user_id(),
                    'message' => $message_content,
                    'created_at' => $time,
                    'updated_at' => $time
                ),
                array(
                    '%d',
                    '%d',
                    '%s'
                )
           );
           
           $message_id = $wpdb->insert_id;
     
           if($message_content == 'gif' && $message_id) {
          
              stc_update_message_meta( $message_id, 'send_gif' , $message_gif);
            
           }
           
           if($message_content == 'media' && $message_id) {
          
              stc_update_message_meta( $message_id , 'send_media' , $message_media);
            
           }
           
           if(!empty($reply_message)) {
            
            stc_update_message_meta( $message_id, 'reply' , $reply_message );
            
           }
       
          
        
          $message = stc_get_message_item_data($message_id);
           
          
          $messages_data = $this->stc_messages_load_item_data($message);
          
          $users = $this->stc_get_users_last($thread_id);
          
          foreach($users as $user) {
            
            stc_add_messages_unread_count( 1 , $thread_id , $user );
      
              /* Send email */   
                
              if(!stc_is_user_online($user)) {
                 
                   $table_name = $wpdb->prefix . 'ld_dashboard_notification';
            
                    $wpdb->insert(
                        $table_name,
                        [
                            'user_id' => $user,
                            'type' =>  'chat',
                            'status' =>  'false',
                            'thread_id' => $thread_id,
                            'created' => current_time('mysql')
                        ]
                    );
                    
              }
            
          }
      
          
          $data = array(
          
            'thread' => array(
            
             'thread_id' => $thread_id,
             'sender_id' => $rel_user,
             'user_start' => stc_check_start_conversation($thread_id),
             'messages' => $messages_data,
             'total_messages' => stc_add_messages_total_count($thread_id), 

            
            )

          );
          
        
              
          
          wp_send_json_success($data);
          
        
    }
    
    public function stc_get_conversation_create_multi() { 
        
          $defaults  = array(
            'users' => '',
            'subject' => ''
         );  
     
          $args = wp_parse_args( $_POST , $defaults );
      
          extract( $args );
          
          $current_user_id = get_current_user_id(); 
       
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
     
          global $wpdb;
        
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
          
           if(!is_user_logged_in()) { 
        
                $errors->add(
                       'login',
                       esc_html('First, you have to login','studiare-core')
                );
                wp_send_json_error( $errors );
             
            }
          
           if(empty($users)) {
          
    		$errors->add(
                   'miss_recipients',
                   esc_html('Please add the message recipients.','studiare-core')
            );
            wp_send_json_error( $errors );
     
            
          }
          
          $users[] = $current_user_id;
          
          if(count($users) <= 2) {
            
              $thread_id = stc_check_two_user($users[0]);
          
              if($thread_id) {
              
        		$errors->add(
                       'thread_id_exit',
                       esc_html('The conversation already exists.','studiare-core')
                );
                wp_send_json_error( $errors );
         
                
              }
            
          }
          
          if(empty($subject)) {
            
              $errors->add(
                       'subject',
                       esc_html('Please add subject','studiare-core')
                );
                wp_send_json_error( $errors );
            
          }
      
              
          $table_recipients = stc_get_table('recipients');
          $table_threads = stc_get_table('threads');
          $time = stc_get_microtime();
          
       
          if(!empty($users) && count($users) > 1 ) {
            
            
           $subject = $subject;
           
           $type_thread = count($users) > 2 ? 'group' : 'thread'; 
        
            $wpdb->insert($table_threads, [
                'subject' => $subject,
                'type' => $type_thread,
                'user_start' => $current_user_id,
            ]);
            
            if ($wpdb->insert_id) {    
                
                $thread_id = $wpdb->insert_id;
            
                foreach($users as $user) {

                    $wpdb->insert($table_recipients, [
                            'user_id' => $user,
                            'thread_id' => $thread_id,
                            'last_update' => $time,
                    ]);
           
    
                }
                
               $message = esc_html__('Conversation created successfully','studiare-core');
               
               wp_send_json_success(compact('message','thread_id'));
        
             }
            
          }
  
          
         wp_send_json_error( $users );
        
    }
    
    public function stc_get_conversation_create() {
        
         $defaults  = array(
            'sender_id' => ''
         );  
         
          $args = wp_parse_args( $_POST , $defaults );
      
          extract( $args );
          
          $user_id = get_current_user_id(); 
       
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
     
          global $wpdb;
        
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
          
           if(!is_user_logged_in()) { 
        
                $errors->add(
                       'login',
                       esc_html('First, you have to login','studiare-core')
                );
                wp_send_json_error( $errors );
             
            }
          
           if(empty($sender_id)) {
          
    		$errors->add(
                   'miss_recipients',
                   esc_html('Please add the message recipients.','studiare-core')
            );
            wp_send_json_error( $errors );
     
            
          }
          
          $thread_id = stc_check_two_user($sender_id);
          
          if($thread_id) {
          
    		$errors->add(
                   'thread_id_exit',
                   esc_html('The conversation already exists.','studiare-core')
            );
            wp_send_json_error( $errors );
     
            
          }
          
          $table_recipients = stc_get_table('recipients');
          $table_threads = stc_get_table('threads');
          $time = stc_get_microtime();
          
         
            if (!$thread_id) {
      
            $subject = "check thread";
            $type = 'thread'; 
        
            $wpdb->insert($table_threads, [
                'subject' => $subject,
                'type' => $type,
                'user_start' => get_current_user_id(),
            ]);
        
            
            if ($wpdb->insert_id) { 
                
                $thread_id = $wpdb->insert_id;
                
                 $wpdb->insert($table_recipients, [
                        'user_id' => $sender_id,
                        'thread_id' => $thread_id,
                        'last_update' => $time,
                 ]);
                
                $wpdb->insert($table_recipients, [
                        'user_id' => get_current_user_id(),
                        'thread_id' => $thread_id,
                        'last_update' => $time,
                ]);
          
                $url = stc_chat_page_url($sender_id);
                    wp_send_json_success(compact('url'));
            }
   
        }
        
    }
    
    public function stc_load_messages_data() { 
        
         $defaults  = array(
            'thread_id' => '',
            'offset' => 0,
         );  
          
          $args = wp_parse_args( $_POST , $defaults );
      
          extract( $args );
          
          $user_id = get_current_user_id(); 
          
          $limit = "5"; //stc_theme_get_option('stc_chat_messages_display');//javad add from theme option then
       
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
     
          global $wpdb;
        
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
          
          $messages = $this->stc_get_conversation_messages($thread_id , $offset , $limit);
     
          $messages_data = [];
          
          if($messages) {
                
              foreach($messages as $key => $message) {
          
                $messages_data[$key] = $this->stc_messages_load_item_data($message);
                
                
              }
                
          }
          
         
          
          $data = array(
          
            'thread' => array(
             
             'thread_id' => $thread_id,
             'sender_id' => $this->stc_get_user_last($thread_id),
             'user_start' => stc_check_start_conversation($thread_id),
             'recipients' => $this->stc_get_user_recipients($thread_id),
             'messages' => $messages_data,
             'unread' => stc_add_messages_unread_count( -1 , $thread_id),
             'subject' => stc_get_subject_conversation($thread_id),
             'type' => stc_check_type_conversation($thread_id),
            
            )

          );
          
          wp_send_json_success($data);
            
        
    }
    
     public function get_attachment_file($attachment_id) { 
        
         
            $attachment_url = wp_get_attachment_url($attachment_id);
            $attachment_mime_type = get_post_mime_type($attachment_id);
            $file_name = basename($attachment_url);
            
            $data = array();
            
            $data['url'] =  $attachment_url;
            $data['name'] = $file_name;
            $data['mime_type'] = get_post_mime_type($attachment_id);
            
            
            if (strpos($attachment_mime_type, 'image/') !== false) {
               
               $data['type'] = 'image';
           
            } elseif (strpos($attachment_mime_type, 'video/') !== false) {
               
                $data['type'] = 'video';
                
                 
            } elseif ($attachment_mime_type === 'audio/mpeg') {
               
                $data['type'] = 'audio';
              
               
            }
            
            return $data;
        
     }
     
     public function stc_get_messages_reply($id) { 
    
       $reply = stc_get_message_meta( $id , 'reply'); 
       
       $data = '';
        
       if($reply) {
        
         $message = stc_get_message_item_data($reply);
   
         $data = $message->message; 
       
        }
        
        return $data;
        
     }
    
     public function stc_get_conversation_messages($thread_id, $offset = 0, $limit = 20) { 
        
        global $wpdb;

        
        $table_name = stc_get_table('messages'); 
   
        $query = $wpdb->prepare(
            "SELECT * FROM $table_name 
            WHERE thread_id = %d 
            ORDER BY created_at DESC
            LIMIT %d OFFSET %d",
            $thread_id , $limit, $offset
        );

        
        $messages = $wpdb->get_results($query);
        
        if ($messages) { 

           return $messages; 
            
        } else {
            
           return false;
            
        }

     }
     
     
      public function stc_get_conversation_messages_realtime($thread_id, $last_time = '') { 
        
        global $wpdb;

        $table_name = stc_get_table('messages'); 
   
        if(!empty($last_time)) {
            
            $query = $wpdb->prepare(
                "SELECT * FROM $table_name WHERE created_at > %d AND thread_id = %d ORDER BY created_at ASC",
                $last_time, $thread_id
            );
            
            $messages = $wpdb->get_results($query);
        
            if ($messages) { 
    
               return $messages; 
                
            } else {
                
               return false;
                
            }
                    
        }


     }
     
    
     public function stc_load_conversation_data() { 
        
          
          $user_id = get_current_user_id(); 

          $defaults  = array();  
          
          $args = wp_parse_args( $_POST , $defaults );
      
          extract( $args );
       
       
          $secure = check_ajax_referer( 'stc_nonce_value', 'nonce', false );
        
          $errors = new WP_Error(); 
     
      
          if ( ! $secure ) {
        		$errors->add(
                       'secure_miss',
                       esc_html('Some thing went wrong, try again','studiare-core')
                );
                wp_send_json_error( $errors );
          }
                  
    
         
              $data = array(
                'threads' => $this->stc_get_order_conversation()
              );
           
 
          
          wp_send_json_success($data);
            
        
    }
    
    
    
    function stc_get_order_conversation() { 
        
        $user_id = get_current_user_id();
    
    
        global $wpdb;
    
        $table_recipients = stc_get_table('recipients');
        $table_messages = stc_get_table('messages');
       
        $time = stc_get_microtime();
      
        $threads = $wpdb->get_results("SELECT thread_id , last_update  FROM $table_recipients WHERE user_id = $user_id");
      
        $created_at_array = [];
        
        foreach ($threads as $thread) {
            $thread_id = $thread->thread_id;
            $last_update = $thread->last_update;
            $created_at = $wpdb->get_var(
                $wpdb->prepare(
                    "SELECT created_at FROM $table_messages WHERE thread_id = %d ORDER BY created_at DESC LIMIT 1",
                    $thread_id
                )
            );
        
       
            $ast_mess_data = stc_get_last_messages($thread_id);
            
            $last_mess = $ast_mess_data ? $ast_mess_data->message : '';
            $last_message_sender = $ast_mess_data ? $ast_mess_data->sender_id : '';
            $last_sender_id = $ast_mess_data ? $ast_mess_data->sender_id : '';
            
           
            $created_at_array[] = [
                'thread_id' => $thread_id,
                'last_date' => $created_at ? $created_at : $last_update,
                'sender_id' => $this->stc_get_user_last($thread_id),
                'last_message' => esc_html($last_mess),
                'last_message_sender' => $last_message_sender,
                'is_me' => $last_sender_id == $user_id ? 'me' : 'orther',
                'display_time' => stc_get_time_messages($created_at),
                'unread' => stc_get_messages_unread_count($thread_id,$user_id),
                'recipients' => $this->stc_get_user_recipients($thread_id),
                'total_messages' => stc_get_messages_total_count($thread_id), 
                'type' => stc_check_type_conversation($thread_id),
                'subject' => stc_get_subject_conversation($thread_id)
            ];
        }
    
       
        usort($created_at_array, function($a, $b) {
            return $b['last_date'] - $a['last_date'];
        });
        
      
  
        return $created_at_array;
      
    }
    
    
    function stc_get_user_recipients($thread_id) {  
        
     $data = [];
         
     $users = wp_cache_get('stc_get_user_threads_'.$thread_id, 'stc_chat');

     if ($users === false) {
     
     global $wpdb;
     
     $table_recipients = stc_get_table('recipients');
    
     $thread_exists = $wpdb->prepare(
            "SELECT user_id  FROM $table_recipients WHERE thread_id = %d",
            $thread_id
     );
      
     $users = $wpdb->get_col($thread_exists);
     
     wp_cache_set('stc_get_user_threads_'.$thread_id, $users, 'stc_chat');
 
     
     }  
     
     foreach ($users as $user) { 
        
        $user_info = get_userdata($user);

        $avatar_id  = get_user_meta( $user , 'mm_sua_attachment_id', true );
        //$attachment_src =  wp_get_attachment_image_src( $avatar_id, 'thumbnail' );
        $attachment_src =  get_user_meta($user, 'profile_picture', true);//javad
         if (!empty($attachment_src)) {$uavat =$attachment_src;}else{$uavat =stc_avatar_default();}
        $data[$user] = array(
         
         'id' => $user,
         //'avatar' => $attachment_src !== false ? $attachment_src[0] : stc_avatar_default(),
         'avatar' => $uavat,//javad 
         'user_link' => get_author_posts_url($user),
         'user_name' => $user_info->display_name,
         'is_you' => false,
         'is_online' => stc_is_user_online($user),
         'is_report' => false,
         'is_favorite' => false
        
        );
        
     } 
    
     return $data;
        
    }
    
    function stc_get_user_last($thread_id) { 
         
         $data = '';
   
         $users = stc_get_user_threads($thread_id);
        
         foreach($users as $user) {
                                    
           
            if(get_current_user_id() == $user) continue;
            
            $data = $user;
       
                                                    
         }
         
         return $data;
    
    }
    
    function stc_get_users_last($thread_id) { 
         
         $data = array();
   
         $users = stc_get_user_threads($thread_id);
        
         foreach($users as $user) {
                                    
           
            if(get_current_user_id() != $user) {
                 
                $data[] = $user;
                
            };

                                                    
         }
         
         return $data;
    
    }

}    
function Studiare_Chat_Class() {
    return Studiare_Chat_Class::instance();
}    