<?php
/**
 * story metabox 
 * created 2025-03-07
 * Java Pourshahabadi
 * Suncode Team
 * https://uiinitiative.com/catalog/stories-slider
 * */



//start cmb2 fields
add_action('cmb2_admin_init', 'sc_story_metabox');
function sc_story_metabox() {
    $prefix = 'sc_story_';

    $cmb = new_cmb2_box(
        array(
        'id'            => $prefix . 'metabox',
        'title'         => __('Story Details', 'studiare-core'),
        'object_types'  => array('sc_story'),
        'context'       => 'normal',
        'priority'      => 'high',
        'show_names'    => true,
        )
        
  
    
    );
    
   /* $cmb->add_field(
        array(
	    'name'        => __('Story State', 'studiare-core'),
	    'id'	      => $prefix . 'is_active',
		'type'        => 'radio_inline',
		'options' => array(
            'active'    => __('Active', 'studiare-core'),
            'deactive'  => __('Deactive', 'studiare-core'),
        ),
        'default' => 'active',
        )
        );
*/
    $group_field_id = $cmb->add_field(array(
        'id'          => $prefix . 'stories',
        'type'        => 'group',
        'description' => __('Add multiple stories', 'studiare-core'),
        'options'     => array(
            'group_title'   => __('Story {#}', 'studiare-core'),
            'add_button'    => __('Add Another Story', 'studiare-core'),
            'remove_button' => __('Remove Story', 'studiare-core'),
            'sortable'      => true,
        ),
    ));

    $cmb->add_group_field($group_field_id, array(
        'name'    => __('Story Type', 'studiare-core'),
        'id'      => 'type',
        'type'    => 'radio_inline',
        'options' => array(
            'image' => __('Image', 'studiare-core'),
            'video' => __('Video', 'studiare-core'),
        ),
        'default' => 'image',
    ));

    $cmb->add_group_field($group_field_id, array(
        'name' => __('Story Title', 'studiare-core'),
        'id'   => 'title',
        'type' => 'text',
    ));

    $cmb->add_group_field($group_field_id, array(
        'name' => __('Story Date', 'studiare-core'),
        'id'   => 'date',
        'type' => 'text_date',
    ));

    $cmb->add_group_field($group_field_id, array(
        'name' => __('Media URL', 'studiare-core'),
        'id'   => 'media_url',
        'type' => 'text_url',
    ));
    $cmb->add_group_field($group_field_id, array(
        'name' => __('Story Link', 'studiare-core'),
        'id'   => 'story_link',
        'type' => 'text_url',
    ));
}

//end cmb2 fields