<?php
/**
 * The notification Post Type
 */

if ( !defined( 'ABSPATH' ) )
	die( '-1' );

if ( ! class_exists( 'Studiare_Notification' ) ) {

	class Studiare_Notification {

		public static $instance;

		// Setup a single instance using the singleton pattern
		public static function init() {

			if ( is_null( self::$instance ) ) {
				self::$instance = new Studiare_Notification();
			}
			return self::$instance;

		}

		function __construct() {

			add_action( 'init', array($this, 'register_post_type' ), 5 );
			add_action( 'cmb2_admin_init', array($this,'register_meta_boxes' ));
			
			//since version 13 adding conditional select
			add_action( 'admin_footer', array($this,'register_style_js' ));

			if( is_admin() ) {

				add_filter( 'manage_edit-teacher_columns' , array( $this,'add_sc_notification_columns' ) );
				

			}
			
			// Add AJAX search functionality
            add_action('admin_enqueue_scripts', array($this, 'enqueue_ajax_scripts'));
            add_action('wp_ajax_sc_specific_users_search', array($this, 'sc_specific_users_search_callback'));
            add_action('wp_ajax_nopriv_sc_specific_users_search', array($this, 'sc_specific_users_search_callback'));
            add_action('wp_ajax_sc_get_product_list_search', array($this, 'sc_get_product_list_search_callback'));
            add_action('wp_ajax_nopriv_sc_get_product_list_search', array($this, 'sc_get_product_list_search_callback'));
		}
		
		// Enqueue necessary scripts for AJAX search
        public function enqueue_ajax_scripts() {
             $class_file_path = plugins_url('', __FILE__);
            wp_enqueue_script('sc-ajax-search-notif',  $class_file_path . '/ajax-search.js', array('jquery'), '1.0', true);
            wp_localize_script('sc-ajax-search-notif', 'sc_ajax', array(
                'ajaxurl' => admin_url('admin-ajax.php'),
            ));
            
            // Check if WooCommerce is active
            if (is_plugin_active('woocommerce/woocommerce.php')) {
                // Check if Select2 is not already enqueued
                if (!wp_script_is('select2', 'enqueued')) {
                    // Enqueue Select2 script
                    wp_enqueue_script('select2', $class_file_path . '/select2.full.min.js', array('jquery'), '4.0.13', true);
                }
            }
        }
        
        // AJAX search callback
        public function sc_specific_users_search_callback() {
            $return = array();
            
            // Prepare the search query
            $search_query = sanitize_text_field( $_GET['q'] );
        
            // Create a new WP_User_Query
            $user_query = new WP_User_Query( array(
                'search' => '*' . esc_attr( $search_query ) . '*',
                'search_columns' => array( 'user_login', 'user_nicename', 'user_email' ),
            ) );
        
            // Get results
            if ( ! empty( $user_query->get_results() ) ) {
                foreach ( $user_query->get_results() as $user ) {
                    $return[] = array( $user->ID, $user->user_login );
                }
            }
        
            echo json_encode( $return );
            wp_die();
        }
        
        // AJAX search callback
        public function sc_get_product_list_search_callback() {
            $return = array();
            
            // Prepare the search query
            $search_query = sanitize_text_field( $_GET['q'] );
        
            // Create a new WP_Query to fetch products
            $args = array(
                'post_type' => 'product',
                's' => $search_query,
                'posts_per_page' => -1, // Get all matching products
            );
        
            $product_query = new WP_Query( $args );
        
            // Get results
            if ( $product_query->have_posts() ) {
                while ( $product_query->have_posts() ) {
                    $product_query->the_post();
                    $return[] = array( get_the_ID(), get_the_title() );
                }
                wp_reset_postdata(); // Reset post data
            }
        
            echo json_encode( $return );
            wp_die();
        }

		function register_post_type() {

 			//$options = get_option( 'studiare-core-options' );
			//$options = codebean_option( 'sc_notification-slug' );
			$options = "";
			if(empty($options) || $options=='' || $options==null){
			    $options = 'notifications';
			}

			if ( post_type_exists( 'sc_notification' ) ) {
				return;
			}

			$labels = array(
				'name'                => _x( 'اطلاعیه', 'Post Type General Name', 'studiare-core' ),
				'singular_name'       => _x( 'اطلاعیه', 'Post Type Singular Name', 'studiare-core' ),
				'menu_name'           => __( 'اطلاعیه', 'studiare-core' ),
				'parent_item_colon'   => __( 'اطلاعیه والد:', 'studiare-core' ),
				'all_items'           => __( ' اطلاعیه ها', 'studiare-core' ),
				'view_item'           => __( 'مشاهده', 'studiare-core' ),
				'add_new_item'        => __( 'افزودن جدید', 'studiare-core' ),
				'add_new'             => __( 'افزودن جدید', 'studiare-core' ),
				'edit_item'           => __( 'ویرایش اطلاعیه', 'studiare-core' ),
				'update_item'         => __( 'بروزرسانی اطلاعیه', 'studiare-core' ),
				'search_items'        => __( 'جستجوی اطلاعیه', 'studiare-core' ),
				'not_found'           => __( 'یافت نشد', 'studiare-core' ),
				'not_found_in_trash'  => __( 'در سطل زباله یافت نشد', 'studiare-core' ),
			);

			$rewrite = array(
				'slug'                => $options,
				'with_front'          => false,
			);

			$args = array(
				'label'               => __( 'download', 'studiare-core' ),
				'description'         => __( 'Download Post Type', 'studiare-core' ),
				'labels'              => $labels,
				// 'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
				'supports'            => array( 'title', 'editor' ),
				'hierarchical'        => false,
				'public'              => true,
				'show_ui'             => true,
                'show_in_menu'       => 'studiare_panel',
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => false,
				'menu_position'       => 20,
				'can_export'          => true,
				'has_archive'         => false,
				'exclude_from_search' => true,
				'publicly_queryable'  => false,
				'query_var'           => true,
				'rewrite'             => $rewrite,
				'menu_icon'           => 'dashicons-bell',
				'capability_type'     => 'post',
			);

			register_post_type( 'sc_notification', $args );

		}

		function register_meta_boxes() {

			$prefix = '_studiare_';

			 $sc_notification_metaboxes = new_cmb2_box( array(
				'id'           => 'sc_notification_metabox',
				'title'        => esc_html__( 'Notification Settings', 'studiare-core' ),
				'object_types' => array( 'sc_notification' ),
				'context'      => 'normal',
				'priority'     => 'high',
				'show_names'   => true,
			) ); 

			

			$sc_notification_metaboxes->add_field( array(
				'name' => esc_html__( 'Notification type', 'studiare-core' ),
				'id' => 'notif_type',
				'type'             => 'select',
                'show_option_none' => false,
                'default'          => 'public',
                'options'          => array(
                    'public'  => __( 'Public', 'studiare-core' ),
                    'private' => __( 'Private', 'studiare-core' ),
                ),
			) ); 
			
			$group_field_id = $sc_notification_metaboxes->add_field( array(
                'id'          => 'private_notif_selector',
                'type'        => 'group',
                'description' => __( 'Select the User ID, User Groups, or specific product buyers to whom you want to send notifications.', 'studiare-core' ),
                'repeatable'  => false, // use false if you want non-repeatable group
                'options'     => array(
                    'group_title'       => '', // since version 1.1.4, {#} gets replaced by row number
                ),
            ) );
            
            
            
            $specific_users_list = array('' => __('Select', 'studiare-core'));
            
            if (isset($_GET['post'])) {
                $specific_users = get_post_meta($_GET['post'], 'private_notif_selector', true);
                if($specific_users){
                    if( isset($specific_users[0]['specific_users']) ){
                        unset($specific_users_list[0]);
                        foreach($specific_users[0]['specific_users'] as $user){
                            if(!empty($user) || $user !=''){
                                $user_data = get_user_by( 'id', $user );
                                $specific_users_list[$user] = $user_data->data->user_login; 
                            }
                        } 
                    } 
                } 
            }
            
            $sc_notification_metaboxes->add_group_field( $group_field_id, array(
                'name' => __( 'Specific Users', 'studiare-core' ),
                'id'   => 'specific_users',
                'type' => 'pw_multiselect',
                'options' => $specific_users_list,
            ) );
            
            
            $product_buyers_list = array('' => __('Select', 'studiare-core'));
            
            if (isset($_GET['post'])) {
                $product_buyers = get_post_meta($_GET['post'], 'private_notif_selector', true);
                if($product_buyers){
                    if( isset($product_buyers[0]['product_buyers']) ){
                        unset($specific_users_list[0]);
                        foreach($product_buyers[0]['product_buyers'] as $pro_id){
                            if(!empty($pro_id) || $pro_id !=''){
                                $product_buyers_list[$pro_id] = get_the_title($pro_id); 
                            }
                        } 
                    } 
                } 
            }
            
            $sc_notification_metaboxes->add_group_field( $group_field_id, array(
                'name' => __( 'Product Buyers', 'studiare-core' ),
                'id'   => 'product_buyers',
                'type' => 'pw_multiselect',
                'options' =>  $product_buyers_list,
            ) );
			
			
		}
		
		function register_style_js(){
		    ?>
			<style>
			    #private_notif_selector_repeat .cmbhandle,#private_notif_selector_repeat h3.cmb-group-title{display:none;}
			   #private_notif_selector_repeat{display:none;}
			    #private_notif_selector_repeat.sett_on{display:block;}
			</style>
			<script>
			    jQuery(document).ready(function($){
			        
			        $("#notif_type").on("change",function(){
			            var val = $(this).val();
			            
			            if(val== 'private'){
			                $("#private_notif_selector_repeat").addClass("sett_on");
			            }else{
			                $("#private_notif_selector_repeat").removeClass("sett_on");
			            }
			        });
			        
			        
			            var notif_type = $("#notif_type").val();
			            
			            if(notif_type== 'private'){
			                $("#private_notif_selector_repeat").addClass("sett_on");
			            }
			       
			        
			    });
			</script>
			<?php
		}

		function add_sc_notification_columns( $cols ) {

			$cols = array(
				'cb'        =>   '<input type="checkbox" />',
				'title'     => __( 'Title', 'studiare-core' ),
				'thumbnail' => __( 'Thumbnail', 'studiare-core')
			);

			return $cols;

		}

		

	}

	Studiare_Notification::init();
}
