<?php
/**
 * The Download Custom Post Type
 */

if ( !defined( 'ABSPATH' ) )
	die( '-1' );

if ( ! class_exists( 'Studiare_Cdownload' ) ) {

	class Studiare_Cdownload {

		public static $instance;

		// Setup a single instance using the singleton pattern
		public static function init() {

			if ( is_null( self::$instance ) ) {
				self::$instance = new Studiare_Cdownload();
			}
			return self::$instance;

		}

		function __construct() {

			add_action( 'init', array($this, 'register_post_type' ), 5 );
			add_action( 'cmb2_admin_init', array($this,'register_meta_boxes' ));

			if( is_admin() ) {

				add_filter( 'manage_edit-teacher_columns' , array( $this,'add_cdownload_columns' ) );
				add_action( 'manage_teacher_posts_custom_column' , array( $this,'set_teacher_columns_content' ), 10, 2 );

			}
		}

		function register_post_type() {

			$options = get_option( 'studiare-core-options' );

			if ( post_type_exists( 'cdownload' ) ) {
				return;
			}

			$labels = array(
				'name'                => _x( 'دانلودهای محافظت شده', 'Post Type General Name', 'studiare-core' ),
				'singular_name'       => _x( 'دانلود', 'Post Type Singular Name', 'studiare-core' ),
				'menu_name'           => __( 'دانلودهای محافظت شده', 'studiare-core' ),
				'parent_item_colon'   => __( 'دانلود والد:', 'studiare-core' ),
				'all_items'           => __( 'همه دانلود ها', 'studiare-core' ),
				'view_item'           => __( 'مشاهده', 'studiare-core' ),
				'add_new_item'        => __( 'افزودن جدید', 'studiare-core' ),
				'add_new'             => __( 'افزودن جدید', 'studiare-core' ),
				'edit_item'           => __( 'ویرایش دانلود', 'studiare-core' ),
				'update_item'         => __( 'بروزرسانی دانلود', 'studiare-core' ),
				'search_items'        => __( 'جستجوی دانلود', 'studiare-core' ),
				'not_found'           => __( 'یافت نشد', 'studiare-core' ),
				'not_found_in_trash'  => __( 'در سطل زباله یافت نشد', 'studiare-core' ),
			);

			$rewrite = array(
				'slug'                => 'cdownload', // $options['cdownload-slug'],
				'with_front'          => false,
			);

			$args = array(
				'label'               => __( 'download', 'studiare-core' ),
				'description'         => __( 'Download Post Type', 'studiare-core' ),
				'labels'              => $labels,
				// 'supports'            => array( 'title', 'editor', 'thumbnail', 'excerpt' ),
				'supports'            => array( 'title' ),
				'hierarchical'        => false,
				'public'              => false,//2023 edited
				'show_ui'             => true,
            'show_in_menu'       => 'studiare_panel',
				'show_in_nav_menus'   => false,
				'show_in_admin_bar'   => false,
				'menu_position'       => 20,
				'can_export'          => true,
				'has_archive'         => false,
				'exclude_from_search' => true,
				'publicly_queryable'  => false,//2023 edited
				'query_var'           => false,//2023 edited
				'rewrite'             => $rewrite,
				'menu_icon'           => 'dashicons-download',
				'capability_type'     => 'post',
			);

			register_post_type( 'cdownload', $args );

		}

		function register_meta_boxes() {

			$prefix = '_studiare_';

			$cdownload_metaboxes = new_cmb2_box( array(
				'id'           => 'cdownload_metabox',
				'title'        => esc_html__( 'اطلاعات دانلود', 'studiare' ),
				'object_types' => array( 'cdownload' ),
				'context'      => 'normal',
				'priority'     => 'high',
				'show_names'   => true,
			) );

			

			$cdownload_metaboxes->add_field( array(
				'name' => esc_html__( 'لینک فایل', 'studiare' ),
				'id' => 'file_url',
				'type' => 'file',
			) );

			
			
		}

		function add_cdownload_columns( $cols ) {

			$cols = array(
				'cb'        =>   '<input type="checkbox" />',
				'title'     => __( 'Title', 'studiare-core' ),
				'thumbnail' => __( 'Thumbnail', 'studiare-core')
			);

			return $cols;

		}

		function set_teacher_columns_content( $column, $post_id ) {

			$width = (int) 35;
			$height = (int) 35;

			switch( $column ) {

				case 'thumbnail' :
					$thumbnail_id = get_post_meta( $post_id, '_thumbnail_id', true );
					$attachments = get_children( array('post_parent' => $post_id, 'post_type' => 'attachment', 'post_mime_type' => 'image') );

					if ( $thumbnail_id ) {
						$thumb = wp_get_attachment_image( $thumbnail_id, array($width, $height), true );
					} elseif ( $attachments ) {
						foreach ( $attachments as $attachment_id => $attachment ) {
							$thumb = wp_get_attachment_image( $attachment_id, array($width, $height), true );
						}
					}

					if ( isset( $thumb ) && $thumb ) {
						echo wp_kses_post( $thumb );
					} else {
						echo __('None', 'studiare-core');
					}

					break;

			}

		}

	}

	Studiare_Cdownload::init();
}
